package net.ibizsys.centralstudio.dto;

import java.math.BigDecimal;
import java.sql.Timestamp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * <B>PSSYSCONTENTCAT</B>系统内容分类 模型传输对象
 * <P>
 * 系统内容分类模型，为通用内容对象提供分类能力
 */
public class PSSysContentCatDTO extends net.ibizsys.centralstudio.util.PSModelDTOBase {

    public PSSysContentCatDTO(){
    }      

    /**
     * <B>CATTAG</B>&nbsp;分类标记，指定内容分类标记值
     * <P>
     * 字符串：最大长度 200
     */
    public final static String FIELD_CATTAG = "cattag";

    /**
     * 设置 分类标记，详细说明：{@link #FIELD_CATTAG}
     * 
     * @param catTag
     * 
     */
    @JsonProperty(FIELD_CATTAG)
    public void setCatTag(String catTag){
        this.set(FIELD_CATTAG, catTag);
    }
    
    /**
     * 获取 分类标记  
     * @return
     */
    @JsonIgnore
    public String getCatTag(){
        Object objValue = this.get(FIELD_CATTAG);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 分类标记 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isCatTagDirty(){
        if(this.contains(FIELD_CATTAG)){
            return true;
        }
        return false;
    }

    /**
     * 重置 分类标记
     */
    @JsonIgnore
    public void resetCatTag(){
        this.reset(FIELD_CATTAG);
    }

    /**
     * 设置 分类标记，详细说明：{@link #FIELD_CATTAG}
     * <P>
     * 等同 {@link #setCatTag}
     * @param catTag
     */
    @JsonIgnore
    public PSSysContentCatDTO cattag(String catTag){
        this.setCatTag(catTag);
        return this;
    }

    /**
     * <B>CATTAG2</B>&nbsp;分类标记2，指定内容分类标记值2
     * <P>
     * 字符串：最大长度 200
     */
    public final static String FIELD_CATTAG2 = "cattag2";

    /**
     * 设置 分类标记2，详细说明：{@link #FIELD_CATTAG2}
     * 
     * @param catTag2
     * 
     */
    @JsonProperty(FIELD_CATTAG2)
    public void setCatTag2(String catTag2){
        this.set(FIELD_CATTAG2, catTag2);
    }
    
    /**
     * 获取 分类标记2  
     * @return
     */
    @JsonIgnore
    public String getCatTag2(){
        Object objValue = this.get(FIELD_CATTAG2);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 分类标记2 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isCatTag2Dirty(){
        if(this.contains(FIELD_CATTAG2)){
            return true;
        }
        return false;
    }

    /**
     * 重置 分类标记2
     */
    @JsonIgnore
    public void resetCatTag2(){
        this.reset(FIELD_CATTAG2);
    }

    /**
     * 设置 分类标记2，详细说明：{@link #FIELD_CATTAG2}
     * <P>
     * 等同 {@link #setCatTag2}
     * @param catTag2
     */
    @JsonIgnore
    public PSSysContentCatDTO cattag2(String catTag2){
        this.setCatTag2(catTag2);
        return this;
    }

    /**
     * <B>CODENAME</B>&nbsp;代码标识，指定系统内容分类的代码标识，需要在所在的模型域（父分类、系统模块或系统）中具有唯一性
     * <P>
     * 字符串：最大长度 50，由字母、数字、下划线组成，且开始必须为字母
     */
    public final static String FIELD_CODENAME = "codename";

    /**
     * 设置 代码标识，详细说明：{@link #FIELD_CODENAME}
     * 
     * @param codeName
     * 
     */
    @JsonProperty(FIELD_CODENAME)
    public void setCodeName(String codeName){
        this.set(FIELD_CODENAME, codeName);
    }
    
    /**
     * 获取 代码标识  
     * @return
     */
    @JsonIgnore
    public String getCodeName(){
        Object objValue = this.get(FIELD_CODENAME);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 代码标识 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isCodeNameDirty(){
        if(this.contains(FIELD_CODENAME)){
            return true;
        }
        return false;
    }

    /**
     * 重置 代码标识
     */
    @JsonIgnore
    public void resetCodeName(){
        this.reset(FIELD_CODENAME);
    }

    /**
     * 设置 代码标识，详细说明：{@link #FIELD_CODENAME}
     * <P>
     * 等同 {@link #setCodeName}
     * @param codeName
     */
    @JsonIgnore
    public PSSysContentCatDTO codename(String codeName){
        this.setCodeName(codeName);
        return this;
    }

    /**
     * <B>CREATEDATE</B>&nbsp;建立时间
     */
    public final static String FIELD_CREATEDATE = "createdate";

    /**
     * 设置 建立时间
     * 
     * @param createDate
     * 
     */
    @JsonProperty(FIELD_CREATEDATE)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    public void setCreateDate(Timestamp createDate){
        this.set(FIELD_CREATEDATE, createDate);
    }
    
    /**
     * 获取 建立时间  
     * @return
     */
    @JsonIgnore
    public Timestamp getCreateDate(){
        Object objValue = this.get(FIELD_CREATEDATE);
        if(objValue==null){
            return null;
        }
        return (Timestamp)objValue;
    }

    /**
     * 判断 建立时间 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isCreateDateDirty(){
        if(this.contains(FIELD_CREATEDATE)){
            return true;
        }
        return false;
    }

    /**
     * 重置 建立时间
     */
    @JsonIgnore
    public void resetCreateDate(){
        this.reset(FIELD_CREATEDATE);
    }

    /**
     * 设置 建立时间
     * <P>
     * 等同 {@link #setCreateDate}
     * @param createDate
     */
    @JsonIgnore
    public PSSysContentCatDTO createdate(Timestamp createDate){
        this.setCreateDate(createDate);
        return this;
    }

    /**
     * <B>CREATEMAN</B>&nbsp;建立人
     * <P>
     * 字符串：最大长度 60
     */
    public final static String FIELD_CREATEMAN = "createman";

    /**
     * 设置 建立人
     * 
     * @param createMan
     * 
     */
    @JsonProperty(FIELD_CREATEMAN)
    public void setCreateMan(String createMan){
        this.set(FIELD_CREATEMAN, createMan);
    }
    
    /**
     * 获取 建立人  
     * @return
     */
    @JsonIgnore
    public String getCreateMan(){
        Object objValue = this.get(FIELD_CREATEMAN);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 建立人 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isCreateManDirty(){
        if(this.contains(FIELD_CREATEMAN)){
            return true;
        }
        return false;
    }

    /**
     * 重置 建立人
     */
    @JsonIgnore
    public void resetCreateMan(){
        this.reset(FIELD_CREATEMAN);
    }

    /**
     * 设置 建立人
     * <P>
     * 等同 {@link #setCreateMan}
     * @param createMan
     */
    @JsonIgnore
    public PSSysContentCatDTO createman(String createMan){
        this.setCreateMan(createMan);
        return this;
    }

    /**
     * <B>MEMO</B>&nbsp;备注
     * <P>
     * 字符串：最大长度 2000
     */
    public final static String FIELD_MEMO = "memo";

    /**
     * 设置 备注
     * 
     * @param memo
     * 
     */
    @JsonProperty(FIELD_MEMO)
    public void setMemo(String memo){
        this.set(FIELD_MEMO, memo);
    }
    
    /**
     * 获取 备注  
     * @return
     */
    @JsonIgnore
    public String getMemo(){
        Object objValue = this.get(FIELD_MEMO);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 备注 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isMemoDirty(){
        if(this.contains(FIELD_MEMO)){
            return true;
        }
        return false;
    }

    /**
     * 重置 备注
     */
    @JsonIgnore
    public void resetMemo(){
        this.reset(FIELD_MEMO);
    }

    /**
     * 设置 备注
     * <P>
     * 等同 {@link #setMemo}
     * @param memo
     */
    @JsonIgnore
    public PSSysContentCatDTO memo(String memo){
        this.setMemo(memo);
        return this;
    }

    /**
     * <B>ORDERVALUE</B>&nbsp;排序值，指定内容分类的排序值
     */
    public final static String FIELD_ORDERVALUE = "ordervalue";

    /**
     * 设置 排序值，详细说明：{@link #FIELD_ORDERVALUE}
     * 
     * @param orderValue
     * 
     */
    @JsonProperty(FIELD_ORDERVALUE)
    public void setOrderValue(Integer orderValue){
        this.set(FIELD_ORDERVALUE, orderValue);
    }
    
    /**
     * 获取 排序值  
     * @return
     */
    @JsonIgnore
    public Integer getOrderValue(){
        Object objValue = this.get(FIELD_ORDERVALUE);
        if(objValue==null){
            return null;
        }
        return (Integer)objValue;
    }

    /**
     * 判断 排序值 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isOrderValueDirty(){
        if(this.contains(FIELD_ORDERVALUE)){
            return true;
        }
        return false;
    }

    /**
     * 重置 排序值
     */
    @JsonIgnore
    public void resetOrderValue(){
        this.reset(FIELD_ORDERVALUE);
    }

    /**
     * 设置 排序值，详细说明：{@link #FIELD_ORDERVALUE}
     * <P>
     * 等同 {@link #setOrderValue}
     * @param orderValue
     */
    @JsonIgnore
    public PSSysContentCatDTO ordervalue(Integer orderValue){
        this.setOrderValue(orderValue);
        return this;
    }

    /**
     * <B>PPSSYSCONTENTCATID</B>&nbsp;父分类，指定内容分类的父分类
     * <P>
     * 引用连接属性：对象&nbsp;{@link net.ibizsys.centralstudio.dto.PSSysContentCatDTO} 
     */
    public final static String FIELD_PPSSYSCONTENTCATID = "ppssyscontentcatid";

    /**
     * 设置 父分类，详细说明：{@link #FIELD_PPSSYSCONTENTCATID}
     * 
     * @param pPSSysContentCatId
     * 
     */
    @JsonProperty(FIELD_PPSSYSCONTENTCATID)
    public void setPPSSysContentCatId(String pPSSysContentCatId){
        this.set(FIELD_PPSSYSCONTENTCATID, pPSSysContentCatId);
    }
    
    /**
     * 获取 父分类  
     * @return
     */
    @JsonIgnore
    public String getPPSSysContentCatId(){
        Object objValue = this.get(FIELD_PPSSYSCONTENTCATID);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 父分类 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPPSSysContentCatIdDirty(){
        if(this.contains(FIELD_PPSSYSCONTENTCATID)){
            return true;
        }
        return false;
    }

    /**
     * 重置 父分类
     */
    @JsonIgnore
    public void resetPPSSysContentCatId(){
        this.reset(FIELD_PPSSYSCONTENTCATID);
    }

    /**
     * 设置 父分类，详细说明：{@link #FIELD_PPSSYSCONTENTCATID}
     * <P>
     * 等同 {@link #setPPSSysContentCatId}
     * @param pPSSysContentCatId
     */
    @JsonIgnore
    public PSSysContentCatDTO ppssyscontentcatid(String pPSSysContentCatId){
        this.setPPSSysContentCatId(pPSSysContentCatId);
        return this;
    }

    /**
     * 设置 父分类，包括引用对象的其它关系属性
     * <P>
     * 等同 {@link #setPPSSysContentCatId}
     * @param pSSysContentCat 引用对象
     */
    @JsonIgnore
    public PSSysContentCatDTO ppssyscontentcatid(PSSysContentCatDTO pSSysContentCat){
        if(pSSysContentCat == null){
            this.setPPSSysContentCatId(null);
            this.setPPSSysContentCatName(null);
        }
        else{
            this.setPPSSysContentCatId(pSSysContentCat.getPSSysContentCatId());
            this.setPPSSysContentCatName(pSSysContentCat.getPSSysContentCatName());
        }
        return this;
    }

    /**
     * <B>PPSSYSCONTENTCATNAME</B>&nbsp;父分类，指定内容分类的父分类
     * <P>
     * 引用附加属性：连接&nbsp;{@link #FIELD_PPSSYSCONTENTCATID}
     */
    public final static String FIELD_PPSSYSCONTENTCATNAME = "ppssyscontentcatname";

    /**
     * 设置 父分类，详细说明：{@link #FIELD_PPSSYSCONTENTCATNAME}
     * 
     * @param pPSSysContentCatName
     * 
     */
    @JsonProperty(FIELD_PPSSYSCONTENTCATNAME)
    public void setPPSSysContentCatName(String pPSSysContentCatName){
        this.set(FIELD_PPSSYSCONTENTCATNAME, pPSSysContentCatName);
    }
    
    /**
     * 获取 父分类  
     * @return
     */
    @JsonIgnore
    public String getPPSSysContentCatName(){
        Object objValue = this.get(FIELD_PPSSYSCONTENTCATNAME);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 父分类 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPPSSysContentCatNameDirty(){
        if(this.contains(FIELD_PPSSYSCONTENTCATNAME)){
            return true;
        }
        return false;
    }

    /**
     * 重置 父分类
     */
    @JsonIgnore
    public void resetPPSSysContentCatName(){
        this.reset(FIELD_PPSSYSCONTENTCATNAME);
    }

    /**
     * 设置 父分类，详细说明：{@link #FIELD_PPSSYSCONTENTCATNAME}
     * <P>
     * 等同 {@link #setPPSSysContentCatName}
     * @param pPSSysContentCatName
     */
    @JsonIgnore
    public PSSysContentCatDTO ppssyscontentcatname(String pPSSysContentCatName){
        this.setPPSSysContentCatName(pPSSysContentCatName);
        return this;
    }

    /**
     * <B>PSMODULEID</B>&nbsp;系统模块，指定系统内容分类所在的系统模块
     * <P>
     * 引用连接属性：对象&nbsp;{@link net.ibizsys.centralstudio.dto.PSModuleDTO} 
     */
    public final static String FIELD_PSMODULEID = "psmoduleid";

    /**
     * 设置 系统模块，详细说明：{@link #FIELD_PSMODULEID}
     * 
     * @param pSModuleId
     * 
     */
    @JsonProperty(FIELD_PSMODULEID)
    public void setPSModuleId(String pSModuleId){
        this.set(FIELD_PSMODULEID, pSModuleId);
    }
    
    /**
     * 获取 系统模块  
     * @return
     */
    @JsonIgnore
    public String getPSModuleId(){
        Object objValue = this.get(FIELD_PSMODULEID);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 系统模块 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSModuleIdDirty(){
        if(this.contains(FIELD_PSMODULEID)){
            return true;
        }
        return false;
    }

    /**
     * 重置 系统模块
     */
    @JsonIgnore
    public void resetPSModuleId(){
        this.reset(FIELD_PSMODULEID);
    }

    /**
     * 设置 系统模块，详细说明：{@link #FIELD_PSMODULEID}
     * <P>
     * 等同 {@link #setPSModuleId}
     * @param pSModuleId
     */
    @JsonIgnore
    public PSSysContentCatDTO psmoduleid(String pSModuleId){
        this.setPSModuleId(pSModuleId);
        return this;
    }

    /**
     * 设置 系统模块，包括引用对象的其它关系属性
     * <P>
     * 等同 {@link #setPSModuleId}
     * @param pSModule 引用对象
     */
    @JsonIgnore
    public PSSysContentCatDTO psmoduleid(PSModuleDTO pSModule){
        if(pSModule == null){
            this.setPSModuleId(null);
            this.setPSModuleName(null);
        }
        else{
            this.setPSModuleId(pSModule.getPSModuleId());
            this.setPSModuleName(pSModule.getPSModuleName());
        }
        return this;
    }

    /**
     * <B>PSMODULENAME</B>&nbsp;系统模块，指定系统内容分类所在的系统模块
     * <P>
     * 引用附加属性：连接&nbsp;{@link #FIELD_PSMODULEID}
     */
    public final static String FIELD_PSMODULENAME = "psmodulename";

    /**
     * 设置 系统模块，详细说明：{@link #FIELD_PSMODULENAME}
     * 
     * @param pSModuleName
     * 
     */
    @JsonProperty(FIELD_PSMODULENAME)
    public void setPSModuleName(String pSModuleName){
        this.set(FIELD_PSMODULENAME, pSModuleName);
    }
    
    /**
     * 获取 系统模块  
     * @return
     */
    @JsonIgnore
    public String getPSModuleName(){
        Object objValue = this.get(FIELD_PSMODULENAME);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 系统模块 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSModuleNameDirty(){
        if(this.contains(FIELD_PSMODULENAME)){
            return true;
        }
        return false;
    }

    /**
     * 重置 系统模块
     */
    @JsonIgnore
    public void resetPSModuleName(){
        this.reset(FIELD_PSMODULENAME);
    }

    /**
     * 设置 系统模块，详细说明：{@link #FIELD_PSMODULENAME}
     * <P>
     * 等同 {@link #setPSModuleName}
     * @param pSModuleName
     */
    @JsonIgnore
    public PSSysContentCatDTO psmodulename(String pSModuleName){
        this.setPSModuleName(pSModuleName);
        return this;
    }

    /**
     * <B>PSSYSCONTENTCATID</B>&nbsp;系统内容分类标识
     * <P>
     * 字符串：最大长度 100
     */
    public final static String FIELD_PSSYSCONTENTCATID = "pssyscontentcatid";

    /**
     * 设置 系统内容分类标识
     * 
     * @param pSSysContentCatId
     * 
     */
    @JsonProperty(FIELD_PSSYSCONTENTCATID)
    public void setPSSysContentCatId(String pSSysContentCatId){
        this.set(FIELD_PSSYSCONTENTCATID, pSSysContentCatId);
    }
    
    /**
     * 获取 系统内容分类标识  
     * @return
     */
    @JsonIgnore
    public String getPSSysContentCatId(){
        Object objValue = this.get(FIELD_PSSYSCONTENTCATID);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 系统内容分类标识 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSSysContentCatIdDirty(){
        if(this.contains(FIELD_PSSYSCONTENTCATID)){
            return true;
        }
        return false;
    }

    /**
     * 重置 系统内容分类标识
     */
    @JsonIgnore
    public void resetPSSysContentCatId(){
        this.reset(FIELD_PSSYSCONTENTCATID);
    }

    /**
     * 设置 系统内容分类标识
     * <P>
     * 等同 {@link #setPSSysContentCatId}
     * @param pSSysContentCatId
     */
    @JsonIgnore
    public PSSysContentCatDTO pssyscontentcatid(String pSSysContentCatId){
        this.setPSSysContentCatId(pSSysContentCatId);
        return this;
    }

    /**
     * <B>PSSYSCONTENTCATNAME</B>&nbsp;系统内容分类名称，指定系统内容分类的名称，需要在所在的模型域（父分类、系统模块或系统）中具有唯一性
     * <P>
     * 字符串：最大长度 200
     */
    public final static String FIELD_PSSYSCONTENTCATNAME = "pssyscontentcatname";

    /**
     * 设置 系统内容分类名称，详细说明：{@link #FIELD_PSSYSCONTENTCATNAME}
     * 
     * @param pSSysContentCatName
     * 
     */
    @JsonProperty(FIELD_PSSYSCONTENTCATNAME)
    public void setPSSysContentCatName(String pSSysContentCatName){
        this.set(FIELD_PSSYSCONTENTCATNAME, pSSysContentCatName);
    }
    
    /**
     * 获取 系统内容分类名称  
     * @return
     */
    @JsonIgnore
    public String getPSSysContentCatName(){
        Object objValue = this.get(FIELD_PSSYSCONTENTCATNAME);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 系统内容分类名称 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSSysContentCatNameDirty(){
        if(this.contains(FIELD_PSSYSCONTENTCATNAME)){
            return true;
        }
        return false;
    }

    /**
     * 重置 系统内容分类名称
     */
    @JsonIgnore
    public void resetPSSysContentCatName(){
        this.reset(FIELD_PSSYSCONTENTCATNAME);
    }

    /**
     * 设置 系统内容分类名称，详细说明：{@link #FIELD_PSSYSCONTENTCATNAME}
     * <P>
     * 等同 {@link #setPSSysContentCatName}
     * @param pSSysContentCatName
     */
    @JsonIgnore
    public PSSysContentCatDTO pssyscontentcatname(String pSSysContentCatName){
        this.setPSSysContentCatName(pSSysContentCatName);
        return this;
    }

    @JsonIgnore
    public String getName(){
        return this.getPSSysContentCatName();
    }

    @JsonIgnore
    public void setName(String strName){
        this.setPSSysContentCatName(strName);
    }

    @JsonIgnore
    public PSSysContentCatDTO name(String strName){
        this.setPSSysContentCatName(strName);
        return this;
    }

    /**
     * <B>PSSYSDYNAMODELID</B>&nbsp;动态系统模型
     * <P>
     * 引用连接属性：对象&nbsp;{@link net.ibizsys.centralstudio.dto.PSSysDynaModelDTO} 
     */
    public final static String FIELD_PSSYSDYNAMODELID = "pssysdynamodelid";

    /**
     * 设置 动态系统模型
     * 
     * @param pSSysDynaModelId
     * 
     */
    @JsonProperty(FIELD_PSSYSDYNAMODELID)
    public void setPSSysDynaModelId(String pSSysDynaModelId){
        this.set(FIELD_PSSYSDYNAMODELID, pSSysDynaModelId);
    }
    
    /**
     * 获取 动态系统模型  
     * @return
     */
    @JsonIgnore
    public String getPSSysDynaModelId(){
        Object objValue = this.get(FIELD_PSSYSDYNAMODELID);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 动态系统模型 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSSysDynaModelIdDirty(){
        if(this.contains(FIELD_PSSYSDYNAMODELID)){
            return true;
        }
        return false;
    }

    /**
     * 重置 动态系统模型
     */
    @JsonIgnore
    public void resetPSSysDynaModelId(){
        this.reset(FIELD_PSSYSDYNAMODELID);
    }

    /**
     * 设置 动态系统模型
     * <P>
     * 等同 {@link #setPSSysDynaModelId}
     * @param pSSysDynaModelId
     */
    @JsonIgnore
    public PSSysContentCatDTO pssysdynamodelid(String pSSysDynaModelId){
        this.setPSSysDynaModelId(pSSysDynaModelId);
        return this;
    }

    /**
     * 设置 动态系统模型，包括引用对象的其它关系属性
     * <P>
     * 等同 {@link #setPSSysDynaModelId}
     * @param pSSysDynaModel 引用对象
     */
    @JsonIgnore
    public PSSysContentCatDTO pssysdynamodelid(PSSysDynaModelDTO pSSysDynaModel){
        if(pSSysDynaModel == null){
            this.setPSSysDynaModelId(null);
            this.setPSSysDynaModelName(null);
        }
        else{
            this.setPSSysDynaModelId(pSSysDynaModel.getPSSysDynaModelId());
            this.setPSSysDynaModelName(pSSysDynaModel.getPSSysDynaModelName());
        }
        return this;
    }

    /**
     * <B>PSSYSDYNAMODELNAME</B>&nbsp;动态系统模型
     * <P>
     * 引用附加属性：连接&nbsp;{@link #FIELD_PSSYSDYNAMODELID}
     */
    public final static String FIELD_PSSYSDYNAMODELNAME = "pssysdynamodelname";

    /**
     * 设置 动态系统模型
     * 
     * @param pSSysDynaModelName
     * 
     */
    @JsonProperty(FIELD_PSSYSDYNAMODELNAME)
    public void setPSSysDynaModelName(String pSSysDynaModelName){
        this.set(FIELD_PSSYSDYNAMODELNAME, pSSysDynaModelName);
    }
    
    /**
     * 获取 动态系统模型  
     * @return
     */
    @JsonIgnore
    public String getPSSysDynaModelName(){
        Object objValue = this.get(FIELD_PSSYSDYNAMODELNAME);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 动态系统模型 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSSysDynaModelNameDirty(){
        if(this.contains(FIELD_PSSYSDYNAMODELNAME)){
            return true;
        }
        return false;
    }

    /**
     * 重置 动态系统模型
     */
    @JsonIgnore
    public void resetPSSysDynaModelName(){
        this.reset(FIELD_PSSYSDYNAMODELNAME);
    }

    /**
     * 设置 动态系统模型
     * <P>
     * 等同 {@link #setPSSysDynaModelName}
     * @param pSSysDynaModelName
     */
    @JsonIgnore
    public PSSysContentCatDTO pssysdynamodelname(String pSSysDynaModelName){
        this.setPSSysDynaModelName(pSSysDynaModelName);
        return this;
    }

    /**
     * <B>UPDATEDATE</B>&nbsp;更新时间
     */
    public final static String FIELD_UPDATEDATE = "updatedate";

    /**
     * 设置 更新时间
     * 
     * @param updateDate
     * 
     */
    @JsonProperty(FIELD_UPDATEDATE)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    public void setUpdateDate(Timestamp updateDate){
        this.set(FIELD_UPDATEDATE, updateDate);
    }
    
    /**
     * 获取 更新时间  
     * @return
     */
    @JsonIgnore
    public Timestamp getUpdateDate(){
        Object objValue = this.get(FIELD_UPDATEDATE);
        if(objValue==null){
            return null;
        }
        return (Timestamp)objValue;
    }

    /**
     * 判断 更新时间 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUpdateDateDirty(){
        if(this.contains(FIELD_UPDATEDATE)){
            return true;
        }
        return false;
    }

    /**
     * 重置 更新时间
     */
    @JsonIgnore
    public void resetUpdateDate(){
        this.reset(FIELD_UPDATEDATE);
    }

    /**
     * 设置 更新时间
     * <P>
     * 等同 {@link #setUpdateDate}
     * @param updateDate
     */
    @JsonIgnore
    public PSSysContentCatDTO updatedate(Timestamp updateDate){
        this.setUpdateDate(updateDate);
        return this;
    }

    /**
     * <B>UPDATEMAN</B>&nbsp;更新人
     * <P>
     * 字符串：最大长度 60
     */
    public final static String FIELD_UPDATEMAN = "updateman";

    /**
     * 设置 更新人
     * 
     * @param updateMan
     * 
     */
    @JsonProperty(FIELD_UPDATEMAN)
    public void setUpdateMan(String updateMan){
        this.set(FIELD_UPDATEMAN, updateMan);
    }
    
    /**
     * 获取 更新人  
     * @return
     */
    @JsonIgnore
    public String getUpdateMan(){
        Object objValue = this.get(FIELD_UPDATEMAN);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 更新人 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUpdateManDirty(){
        if(this.contains(FIELD_UPDATEMAN)){
            return true;
        }
        return false;
    }

    /**
     * 重置 更新人
     */
    @JsonIgnore
    public void resetUpdateMan(){
        this.reset(FIELD_UPDATEMAN);
    }

    /**
     * 设置 更新人
     * <P>
     * 等同 {@link #setUpdateMan}
     * @param updateMan
     */
    @JsonIgnore
    public PSSysContentCatDTO updateman(String updateMan){
        this.setUpdateMan(updateMan);
        return this;
    }

    /**
     * <B>USERCAT</B>&nbsp;用户分类
     * <P>
     * 值参考&nbsp;{@link net.ibizsys.model.PSModelEnums.ModelUserCat} 
     */
    public final static String FIELD_USERCAT = "usercat";

    /**
     * 设置 用户分类
     * 
     * @param userCat
     * 
     */
    @JsonProperty(FIELD_USERCAT)
    public void setUserCat(String userCat){
        this.set(FIELD_USERCAT, userCat);
    }
    
    /**
     * 获取 用户分类  
     * @return
     */
    @JsonIgnore
    public String getUserCat(){
        Object objValue = this.get(FIELD_USERCAT);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 用户分类 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUserCatDirty(){
        if(this.contains(FIELD_USERCAT)){
            return true;
        }
        return false;
    }

    /**
     * 重置 用户分类
     */
    @JsonIgnore
    public void resetUserCat(){
        this.reset(FIELD_USERCAT);
    }

    /**
     * 设置 用户分类
     * <P>
     * 等同 {@link #setUserCat}
     * @param userCat
     */
    @JsonIgnore
    public PSSysContentCatDTO usercat(String userCat){
        this.setUserCat(userCat);
        return this;
    }

     /**
     * 设置 用户分类
     * <P>
     * 等同 {@link #setUserCat}
     * @param userCat
     */
    @JsonIgnore
    public PSSysContentCatDTO usercat(net.ibizsys.model.PSModelEnums.ModelUserCat userCat){
        if(userCat == null){
            this.setUserCat(null);
        }
        else{
            this.setUserCat(userCat.value);
        }
        return this;
    }

    /**
     * <B>USERTAG</B>&nbsp;用户标记
     * <P>
     * 字符串：最大长度 200
     */
    public final static String FIELD_USERTAG = "usertag";

    /**
     * 设置 用户标记
     * 
     * @param userTag
     * 
     */
    @JsonProperty(FIELD_USERTAG)
    public void setUserTag(String userTag){
        this.set(FIELD_USERTAG, userTag);
    }
    
    /**
     * 获取 用户标记  
     * @return
     */
    @JsonIgnore
    public String getUserTag(){
        Object objValue = this.get(FIELD_USERTAG);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 用户标记 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUserTagDirty(){
        if(this.contains(FIELD_USERTAG)){
            return true;
        }
        return false;
    }

    /**
     * 重置 用户标记
     */
    @JsonIgnore
    public void resetUserTag(){
        this.reset(FIELD_USERTAG);
    }

    /**
     * 设置 用户标记
     * <P>
     * 等同 {@link #setUserTag}
     * @param userTag
     */
    @JsonIgnore
    public PSSysContentCatDTO usertag(String userTag){
        this.setUserTag(userTag);
        return this;
    }

    /**
     * <B>USERTAG2</B>&nbsp;用户标记2
     * <P>
     * 字符串：最大长度 200
     */
    public final static String FIELD_USERTAG2 = "usertag2";

    /**
     * 设置 用户标记2
     * 
     * @param userTag2
     * 
     */
    @JsonProperty(FIELD_USERTAG2)
    public void setUserTag2(String userTag2){
        this.set(FIELD_USERTAG2, userTag2);
    }
    
    /**
     * 获取 用户标记2  
     * @return
     */
    @JsonIgnore
    public String getUserTag2(){
        Object objValue = this.get(FIELD_USERTAG2);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 用户标记2 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUserTag2Dirty(){
        if(this.contains(FIELD_USERTAG2)){
            return true;
        }
        return false;
    }

    /**
     * 重置 用户标记2
     */
    @JsonIgnore
    public void resetUserTag2(){
        this.reset(FIELD_USERTAG2);
    }

    /**
     * 设置 用户标记2
     * <P>
     * 等同 {@link #setUserTag2}
     * @param userTag2
     */
    @JsonIgnore
    public PSSysContentCatDTO usertag2(String userTag2){
        this.setUserTag2(userTag2);
        return this;
    }

    /**
     * <B>USERTAG3</B>&nbsp;用户标记3
     * <P>
     * 字符串：最大长度 50
     */
    public final static String FIELD_USERTAG3 = "usertag3";

    /**
     * 设置 用户标记3
     * 
     * @param userTag3
     * 
     */
    @JsonProperty(FIELD_USERTAG3)
    public void setUserTag3(String userTag3){
        this.set(FIELD_USERTAG3, userTag3);
    }
    
    /**
     * 获取 用户标记3  
     * @return
     */
    @JsonIgnore
    public String getUserTag3(){
        Object objValue = this.get(FIELD_USERTAG3);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 用户标记3 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUserTag3Dirty(){
        if(this.contains(FIELD_USERTAG3)){
            return true;
        }
        return false;
    }

    /**
     * 重置 用户标记3
     */
    @JsonIgnore
    public void resetUserTag3(){
        this.reset(FIELD_USERTAG3);
    }

    /**
     * 设置 用户标记3
     * <P>
     * 等同 {@link #setUserTag3}
     * @param userTag3
     */
    @JsonIgnore
    public PSSysContentCatDTO usertag3(String userTag3){
        this.setUserTag3(userTag3);
        return this;
    }

    /**
     * <B>USERTAG4</B>&nbsp;用户标记4
     * <P>
     * 字符串：最大长度 50
     */
    public final static String FIELD_USERTAG4 = "usertag4";

    /**
     * 设置 用户标记4
     * 
     * @param userTag4
     * 
     */
    @JsonProperty(FIELD_USERTAG4)
    public void setUserTag4(String userTag4){
        this.set(FIELD_USERTAG4, userTag4);
    }
    
    /**
     * 获取 用户标记4  
     * @return
     */
    @JsonIgnore
    public String getUserTag4(){
        Object objValue = this.get(FIELD_USERTAG4);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 用户标记4 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUserTag4Dirty(){
        if(this.contains(FIELD_USERTAG4)){
            return true;
        }
        return false;
    }

    /**
     * 重置 用户标记4
     */
    @JsonIgnore
    public void resetUserTag4(){
        this.reset(FIELD_USERTAG4);
    }

    /**
     * 设置 用户标记4
     * <P>
     * 等同 {@link #setUserTag4}
     * @param userTag4
     */
    @JsonIgnore
    public PSSysContentCatDTO usertag4(String userTag4){
        this.setUserTag4(userTag4);
        return this;
    }

    @JsonIgnore
    @Override
    public String getSrfkey(){
        return this.getPSSysContentCatId();
    }

    @JsonIgnore
    public void setSrfkey(String strValue){
        this.setPSSysContentCatId(strValue);
    }

    @JsonIgnore
    public String getId(){
        return this.getPSSysContentCatId();
    }

    @JsonIgnore
    public void setId(String strValue){
        this.setPSSysContentCatId(strValue);
    }

    @JsonIgnore
    public PSSysContentCatDTO id(String strValue){
        this.setPSSysContentCatId(strValue);
        return this;
    }

    @Override
    public void copyTo(net.ibizsys.centralstudio.util.IEntity iEntity){
        if(iEntity instanceof PSSysContentCatDTO){
            PSSysContentCatDTO dto = (PSSysContentCatDTO)iEntity;
        }
        super.copyTo(iEntity);
    }
}
