/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.web;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.swagger.models.Swagger;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponents;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;
import springfox.documentation.swagger2.web.HostNameProvider;

@Controller
@ApiIgnore
public class JsmSwaggerController {
    @Value(value="${jsm.swagger.host:DEFAULT}")
    private String hostNameOverride;
    @Resource
    private DocumentationCache documentationCache;
    @Resource
    private ServiceModelToSwagger2Mapper mapper;
    @Resource
    private JsonSerializer jsonSerializer;

    @ApiIgnore
    @RequestMapping(value={"${jsm.swagger.docPath:/v1/swagger-api-docs}"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    @ResponseBody
    public ResponseEntity<Json> getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest servletRequest) {
        String groupName = (String)Optional.fromNullable((Object)swaggerGroup).or((Object)"default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Swagger swagger = this.mapper.mapDocumentation(documentation);
        if (Strings.isNullOrEmpty((String)swagger.getHost())) {
            UriComponents uriComponents = HostNameProvider.componentsFrom((HttpServletRequest)servletRequest);
            swagger.basePath(Strings.isNullOrEmpty((String)uriComponents.getPath()) ? "/" : uriComponents.getPath());
            swagger.host(this.hostName(uriComponents));
        }
        return new ResponseEntity((Object)this.jsonSerializer.toJson((Object)swagger), HttpStatus.OK);
    }

    private String hostName(UriComponents uriComponents) {
        if ("DEFAULT".equals(this.hostNameOverride)) {
            String host = uriComponents.getHost();
            int port = uriComponents.getPort();
            return port > -1 ? String.format("%s:%d", host, port) : host;
        }
        return this.hostNameOverride;
    }
}

