/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.utils.LogUtil;
import java.io.File;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;

public class XmlUtil {
    private static Logger log = LogUtil.log(XmlUtil.class);

    public static Document parseText(String xmlStr) {
        try {
            return DocumentHelper.parseText((String)xmlStr);
        }
        catch (DocumentException e) {
            log.error("parse xml error:" + xmlStr, (Throwable)e);
            return null;
        }
    }

    public static String toXml(Document document) {
        return document.asXML();
    }

    public static Document createNewDoc() {
        return XmlUtil.createNewDoc("utf8");
    }

    public static Document createNewDoc(String encode) {
        Document doc = DocumentHelper.createDocument();
        doc.setXMLEncoding(encode);
        return doc;
    }

    public static Document loadXml(String xmlPath) {
        SAXReader sax = new SAXReader();
        try {
            return sax.read(new File(xmlPath));
        }
        catch (DocumentException e) {
            log.error("loadXml erorr:" + xmlPath, (Throwable)e);
            return null;
        }
    }

    public static Document loadClassPathXml(String xmlPath) {
        SAXReader sax = new SAXReader();
        try {
            return sax.read(ClassLoader.getSystemResourceAsStream(xmlPath));
        }
        catch (DocumentException e) {
            log.error("loadXml erorr:" + xmlPath, (Throwable)e);
            return null;
        }
    }

    public static Element find(Element root, String elementName, String attrName, String attrVal) {
        for (Element element : root.elements(elementName)) {
            Attribute name = element.attribute(attrName);
            if (name == null) continue;
            String value = name.getValue();
            if (value != null && attrVal.equals(value)) {
                return element;
            }
            XmlUtil.find(element, elementName, attrName, attrVal);
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(XmlUtil.createNewDoc().asXML());
    }
}

