/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.stat.JsmAlarmService;
import cn.ibaijia.jsm.stat.model.Alarm;
import cn.ibaijia.jsm.stat.model.DiskStat;
import cn.ibaijia.jsm.stat.model.SystemHealth;
import cn.ibaijia.jsm.stat.model.SystemStat;
import cn.ibaijia.jsm.utils.DateUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public class SystemUtil {
    public static final String JAVA_VERSION = SystemUtil.getSystemProperty("java.version");
    public static final String OS_NAME = SystemUtil.getSystemProperty("os.name");
    public static final String OS_VERSION = SystemUtil.getSystemProperty("os.version");
    public static final boolean IS_OS_AIX = SystemUtil.getOSMatches("AIX");
    public static final boolean IS_OS_HP_UX = SystemUtil.getOSMatches("HP-UX");
    public static final boolean IS_OS_IRIX = SystemUtil.getOSMatches("Irix");
    public static final boolean IS_OS_LINUX = SystemUtil.getOSMatches("Linux") || SystemUtil.getOSMatches("LINUX");
    public static final boolean IS_OS_MAC = SystemUtil.getOSMatches("Mac");
    public static final boolean IS_OS_MAC_OSX = SystemUtil.getOSMatches("Mac OS X");
    public static final boolean IS_OS_OS2 = SystemUtil.getOSMatches("OS/2");
    public static final boolean IS_OS_SOLARIS = SystemUtil.getOSMatches("Solaris");
    public static final boolean IS_OS_SUN_OS = SystemUtil.getOSMatches("SunOS");
    public static final boolean IS_OS_UNIX = IS_OS_AIX || IS_OS_HP_UX || IS_OS_IRIX || IS_OS_LINUX || IS_OS_MAC_OSX || IS_OS_SOLARIS || IS_OS_SUN_OS;
    public static final boolean IS_OS_WINDOWS = SystemUtil.getOSMatches("Windows");
    public static final boolean IS_OS_WINDOWS_2000 = SystemUtil.getOSMatches("Windows", "5.0");
    public static final boolean IS_OS_WINDOWS_95 = SystemUtil.getOSMatches("Windows 9", "4.0");
    public static final boolean IS_OS_WINDOWS_98 = SystemUtil.getOSMatches("Windows 9", "4.1");
    public static final boolean IS_OS_WINDOWS_ME = SystemUtil.getOSMatches("Windows", "4.9");
    public static final boolean IS_OS_WINDOWS_NT = SystemUtil.getOSMatches("Windows NT");
    public static final boolean IS_OS_WINDOWS_XP = SystemUtil.getOSMatches("Windows", "5.1");

    private static boolean getOSMatches(String osNamePrefix) {
        if (OS_NAME == null) {
            return false;
        }
        return OS_NAME.startsWith(osNamePrefix);
    }

    private static boolean getOSMatches(String osNamePrefix, String osVersionPrefix) {
        if (OS_NAME == null || OS_VERSION == null) {
            return false;
        }
        return OS_NAME.startsWith(osNamePrefix) && OS_VERSION.startsWith(osVersionPrefix);
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException localSecurityException) {
            System.err.println("Caught a SecurityException reading the system property '" + property + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    public static SystemStat getSystemStat() {
        SystemStat systemStat = new SystemStat();
        systemStat.osName = System.getProperty("os.name");
        systemStat.osVersion = System.getProperty("os.version");
        systemStat.osArch = System.getProperty("os.arch");
        systemStat.userName = System.getProperty("user.name");
        systemStat.userHome = System.getProperty("user.home");
        systemStat.userDir = System.getProperty("user.dir");
        systemStat.userTimezone = System.getProperty("user.timezone");
        systemStat.userLanguage = System.getProperty("user.language");
        systemStat.tmpDir = System.getProperty("java.io.tmpdir");
        systemStat.runtimeName = System.getProperty("java.runtime.name");
        systemStat.runtimeVersion = System.getProperty("java.version");
        systemStat.jvmName = System.getProperty("java.vm.name");
        systemStat.jvmVersion = System.getProperty("java.vm.version");
        systemStat.javaHome = System.getProperty("java.home");
        systemStat.javaVersion = System.getProperty("java.version");
        systemStat.fileEncoding = System.getProperty("file.encoding");
        systemStat.catalinaHome = System.getProperty("catalina.home");
        systemStat.totalMemory = Runtime.getRuntime().totalMemory();
        systemStat.freeMemory = Runtime.getRuntime().freeMemory();
        systemStat.useMemory = systemStat.totalMemory - systemStat.freeMemory;
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        if (osmxb != null) {
            double cpuLoad = osmxb.getProcessCpuLoad();
            systemStat.cpuRatio = Double.valueOf(cpuLoad * 100.0).intValue();
        }
        ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
        while (parentThread.getParent() != null) {
            parentThread = parentThread.getParent();
        }
        systemStat.threadCount = parentThread.activeCount();
        systemStat.clusterId = AppContext.getClusterId();
        systemStat.diskInfo = StringUtil.toJson(SystemUtil.getDiskStat());
        systemStat.time = DateUtil.currentTime();
        return systemStat;
    }

    public static void addAlarm(Alarm alarm) {
        JsmAlarmService alarmService = SpringContext.getBean(JsmAlarmService.class);
        alarmService.add(alarm);
    }

    public static void clearAlarms() {
        JsmAlarmService alarmService = SpringContext.getBean(JsmAlarmService.class);
        alarmService.clear();
    }

    public static List<Alarm> pullAlarms() {
        JsmAlarmService alarmService = SpringContext.getBean(JsmAlarmService.class);
        return alarmService.pull();
    }

    public static List<DiskStat> getDiskStat() {
        File[] roots = File.listRoots();
        ArrayList<DiskStat> diskStatList = new ArrayList<DiskStat>();
        for (File file : roots) {
            DiskStat diskStat = new DiskStat();
            diskStat.path = file.getPath();
            diskStat.total = file.getTotalSpace();
            diskStat.free = file.getFreeSpace();
            diskStatList.add(diskStat);
        }
        return diskStatList;
    }

    public static SystemHealth getSystemHealth() {
        SystemHealth systemHealth = new SystemHealth();
        systemHealth.systemStat = SystemUtil.getSystemStat();
        systemHealth.alarmList = SystemUtil.pullAlarms();
        return systemHealth;
    }
}

