/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.utils.FileUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class SensitiveWordUtil {
    private static Logger logger = LogUtil.log(SensitiveWordUtil.class);
    private static Map sensitiveWordMap = new HashMap();
    public static final int MATCH_TYPE_MIN = 1;
    public static final int MATCH_TYPE_MAX = 2;
    private static String END_TRUE = "1";
    private static String END_FALSE = "0";
    private static String END_FLAG = "end";

    public static void init() {
        String[] wordsArr = SensitiveWordUtil.loadSensitiveDic();
        SensitiveWordUtil.createSensitiveWordMap(wordsArr);
    }

    private static String[] loadSensitiveDic() {
        String filename = "sensitive-words";
        try {
            String txt = FileUtil.readFileAsText(SensitiveWordUtil.class.getClassLoader().getResourceAsStream(filename));
            return txt.split(";");
        }
        catch (Exception e) {
            logger.error("loadSensitiveDic error.", (Throwable)e);
            return null;
        }
    }

    private static void createSensitiveWordMap(String[] words) {
        sensitiveWordMap = new HashMap(words.length);
        for (String word : words) {
            HashMap<Object, Object> parentMap = sensitiveWordMap;
            for (int i = 0; i < word.length(); ++i) {
                char keyChar = word.charAt(i);
                Object childMap = parentMap.get(Character.valueOf(keyChar));
                if (childMap != null) {
                    parentMap = (Map)childMap;
                } else {
                    HashMap<Object, Object> newWordMap = new HashMap<Object, Object>();
                    newWordMap.put(END_FLAG, END_FALSE);
                    parentMap.put(Character.valueOf(keyChar), newWordMap);
                    parentMap = newWordMap;
                }
                if (i != word.length() - 1) continue;
                parentMap.put(END_FLAG, END_TRUE);
            }
        }
    }

    private static String createReplaceString(char replaceChar, int length) {
        char[] resultReplace = new char[length];
        for (int i = 0; i < length; ++i) {
            resultReplace[i] = replaceChar;
        }
        return String.valueOf(resultReplace);
    }

    public static String findAndReplaceSensitiveWord(String txt, int matchType, char replaceChar) {
        String resultTxt = txt;
        Set<String> set = SensitiveWordUtil.getSensitiveWord(txt, matchType);
        for (String word : set) {
            String replaceString = SensitiveWordUtil.createReplaceString(replaceChar, word.length());
            resultTxt = resultTxt.replaceAll(word, replaceString);
        }
        return resultTxt;
    }

    private static int checkSensitiveWordLength(String txt, int beginIndex, int matchType) {
        boolean flag = false;
        int matchFlag = 0;
        char word = '\u0000';
        Map currentMap = sensitiveWordMap;
        for (int i = beginIndex; i < txt.length() && (currentMap = (Map)currentMap.get(Character.valueOf(word = txt.charAt(i)))) != null; ++i) {
            ++matchFlag;
            if (!END_TRUE.equals(currentMap.get(END_FLAG))) continue;
            flag = true;
            if (1 == matchType) break;
        }
        if (matchFlag < 2 || !flag) {
            matchFlag = 0;
        }
        return matchFlag;
    }

    public static Set<String> getSensitiveWord(String txt, int matchType) {
        HashSet<String> sensitiveWordList = new HashSet<String>();
        for (int i = 0; i < txt.length(); ++i) {
            int length = SensitiveWordUtil.checkSensitiveWordLength(txt, i, matchType);
            if (length <= 0) continue;
            sensitiveWordList.add(txt.substring(i, i + length));
            i = i + length - 1;
        }
        return sensitiveWordList;
    }
}

