/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.utils.LogUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public class ReflectionUtil {
    private static Logger logger = LogUtil.log(ReflectionUtil.class);

    public static boolean isInt(Class clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class;
    }

    public static boolean isLong(Class clazz) {
        return clazz == Long.TYPE || clazz == Long.class;
    }

    public static boolean isShort(Class clazz) {
        return clazz == Short.TYPE || clazz == Short.class;
    }

    public static boolean isByte(Class clazz) {
        return clazz == Byte.TYPE || clazz == Byte.class;
    }

    public static boolean isDouble(Class clazz) {
        return clazz == Double.TYPE || clazz == Double.class;
    }

    public static boolean isFloat(Class clazz) {
        return clazz == Float.TYPE || clazz == Float.class;
    }

    public static boolean isString(Class clazz) {
        return clazz == String.class;
    }

    public static boolean isBoolean(Class clazz) {
        return clazz == Boolean.TYPE || clazz == Boolean.class;
    }

    public static boolean isCharacter(Class clazz) {
        return clazz == Character.TYPE || clazz == Character.class;
    }

    public static boolean isBigDecimal(Class clazz) {
        return clazz == BigDecimal.class;
    }

    public static boolean isDate(Class clazz) {
        return clazz == Date.class;
    }

    public static boolean isBaseType(Class clazz) {
        return ReflectionUtil.isFloat(clazz) || ReflectionUtil.isDouble(clazz) || ReflectionUtil.isLong(clazz) || ReflectionUtil.isInt(clazz) || ReflectionUtil.isShort(clazz) || ReflectionUtil.isByte(clazz) || ReflectionUtil.isBoolean(clazz) || ReflectionUtil.isCharacter(clazz) || ReflectionUtil.isString(clazz);
    }

    public static boolean isNumberType(Class clazz) {
        return ReflectionUtil.isFloat(clazz) || ReflectionUtil.isDouble(clazz) || ReflectionUtil.isLong(clazz) || ReflectionUtil.isInt(clazz) || ReflectionUtil.isShort(clazz) || ReflectionUtil.isByte(clazz) || ReflectionUtil.isBigDecimal(clazz);
    }

    public static boolean isPlanType(Class clazz) {
        return ReflectionUtil.isBaseType(clazz) || ReflectionUtil.isDate(clazz) || ReflectionUtil.isBigDecimal(clazz);
    }

    public static boolean isObjectType(Class clazz) {
        return clazz == Object.class;
    }

    public static boolean isInt(String clazz) {
        return clazz.equals("Integer") || clazz.equals("int");
    }

    public static boolean isLong(String clazz) {
        return clazz.equals("Long") || clazz.equals("long");
    }

    public static boolean isShort(String clazz) {
        return clazz.equals("Short") || clazz.equals("short");
    }

    public static boolean isByte(String clazz) {
        return clazz.equals("Byte") || clazz.equals("byte");
    }

    public static boolean isDouble(String clazz) {
        return clazz.equals("Double") || clazz.equals("double");
    }

    public static boolean isFloat(String clazz) {
        return clazz.equals("Float") || clazz.equals("float");
    }

    public static boolean isString(String clazz) {
        return clazz.equals("String");
    }

    public static boolean isBoolean(String clazz) {
        return clazz.equals("Boolean") || clazz.equals("boolean");
    }

    public static boolean isCharacter(String clazz) {
        return clazz.equals("Character") || clazz.equals("Char");
    }

    public static boolean isBigDecimal(String clazz) {
        return clazz.equals("BigDecimal");
    }

    public static boolean isDate(String clazz) {
        return clazz.equals("Date");
    }

    public static boolean isBaseType(String clazz) {
        return ReflectionUtil.isFloat(clazz) || ReflectionUtil.isDouble(clazz) || ReflectionUtil.isLong(clazz) || ReflectionUtil.isInt(clazz) || ReflectionUtil.isShort(clazz) || ReflectionUtil.isByte(clazz) || ReflectionUtil.isBoolean(clazz) || ReflectionUtil.isCharacter(clazz) || ReflectionUtil.isString(clazz);
    }

    public static boolean isNumberType(String clazz) {
        return ReflectionUtil.isFloat(clazz) || ReflectionUtil.isDouble(clazz) || ReflectionUtil.isLong(clazz) || ReflectionUtil.isInt(clazz) || ReflectionUtil.isShort(clazz) || ReflectionUtil.isByte(clazz) || ReflectionUtil.isBigDecimal(clazz);
    }

    public static boolean isPlanType(String clazz) {
        return ReflectionUtil.isBaseType(clazz) || ReflectionUtil.isDate(clazz) || ReflectionUtil.isBigDecimal(clazz);
    }

    public static boolean isObjectType(String clazz) {
        return clazz.equals("Object");
    }

    public static boolean isListType(String clazz) {
        return clazz.startsWith("List") || clazz.startsWith("Set");
    }

    private static Field getDeclaredField(Object object, String fieldName) {
        Assert.notNull((Object)object, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)fieldName, (String)"fieldName");
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    private static Method getDeclaredMethod(Object object, String methodName, Class<?>[] parameterTypes) {
        Assert.notNull((Object)object, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)methodName, (String)"methodName");
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = ReflectionUtil.getDeclaredField(object, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + object + "]");
        }
        ReflectionUtil.makeAccessible(field);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Object)e.getMessage());
        }
        return result;
    }

    public static void setFieldValue(Object object, String fieldName, Object fieldValue) {
        Field field = ReflectionUtil.getDeclaredField(object, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + object + "]");
        }
        ReflectionUtil.makeAccessible(field);
        try {
            field.set(object, fieldValue);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameterValues) {
        Method method = ReflectionUtil.getDeclaredMethod(object, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + object + "]");
        }
        method.setAccessible(true);
        try {
            return method.invoke(object, parameterValues);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Object invokeStaticMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object[] parameterValues) {
        Method method = ReflectionUtil.getClazzMethod(clazz, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find static method [" + methodName + "] on target clazz [" + clazz + "]");
        }
        method.setAccessible(true);
        try {
            return method.invoke(null, parameterValues);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    private static Method getClazzMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object invokeGetterMethod(Object object, String fieldName) {
        String getterMethodName = "get" + StringUtils.capitalize((String)fieldName);
        return ReflectionUtil.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
    }

    public static void invokeSetterMethod(Object target, String fieldName, Class<?> parameterType, Object parameterValue) {
        String setterMethodName = "set" + StringUtils.capitalize((String)fieldName);
        Class<?> type = parameterType != null ? parameterType : parameterValue.getClass();
        ReflectionUtil.invokeMethod(target, setterMethodName, new Class[]{type}, new Object[]{parameterValue});
    }

    public static void invokeSetterMethod(Object target, String propertyName, Object parameterValue) {
        ReflectionUtil.invokeSetterMethod(target, propertyName, null, parameterValue);
    }

    private static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static <T> Class<T> getSuperClassGenricType(Class<T> clazz) {
        return ReflectionUtil.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException("Reflection Exception.", e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException("Reflection Exception.", ((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }

    public static Object invokeMethod(ProceedingJoinPoint jpt, String methodName) {
        Method method = ((MethodSignature)jpt.getSignature()).getMethod();
        Class<?>[] argTypes = method.getParameterTypes();
        return ReflectionUtil.invokeMethod(jpt.getTarget(), methodName, argTypes, jpt.getArgs());
    }
}

