/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.utils.FileUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class PropUtil {
    private static Logger logger = StatusLogger.getLogger();

    public static String get(String key, String propFile) {
        Properties prop = PropUtil.getProperties(propFile);
        return prop.getProperty(key);
    }

    public static Integer getAsInteger(String key, String propFile) {
        try {
            String val = PropUtil.get(key, propFile);
            if (!StringUtil.isEmpty(val)) {
                return Integer.valueOf(val);
            }
            logger.error("key is empty, key {} in propFile {}", (Object)key, (Object)propFile);
            return null;
        }
        catch (Exception e) {
            logger.error("getAsInteger error! key {} in propFile {}", (Object)key, (Object)propFile);
            return null;
        }
    }

    public static Long getAsLong(String key, String propFile) {
        try {
            String val = PropUtil.get(key, propFile);
            if (!StringUtil.isEmpty(val)) {
                return Long.valueOf(val);
            }
            logger.error("key is empty, key {} in propFile {}", (Object)key, (Object)propFile);
            return null;
        }
        catch (Exception e) {
            logger.error("getAsLong error! key {} in propFile {}", (Object)key, (Object)propFile);
            return null;
        }
    }

    public static Boolean getAsBoolean(String key, String propFile) {
        try {
            String val = PropUtil.get(key, propFile);
            if (!StringUtil.isEmpty(val)) {
                return Boolean.valueOf(val);
            }
            logger.error("key is empty, key {} in propFile {}", (Object)key, (Object)propFile);
            return null;
        }
        catch (Exception e) {
            logger.error("getAsBoolean error! key {} in propFile {}", (Object)key, (Object)propFile);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String propFile) {
        Properties prop = new Properties();
        InputStream is = null;
        try {
            is = FileUtil.getResourceStream(propFile);
            prop.load(is);
            is.close();
        }
        catch (Exception e) {
            logger.error("load properties error! file {}", (Object)propFile);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("close properties file error! file {}", (Object)propFile);
                }
            }
        }
        return prop;
    }
}

