/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.utils.LogUtil;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;

public class PdfUtil {
    private static Logger logger = LogUtil.log(PdfUtil.class);

    public static boolean formatPdf(String templatePath, String outputPath, Map<String, Object> data) {
        BaseFont font = null;
        try {
            font = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            logger.error("createFont STSong-Light,UniGB-UCS2-H error", (Throwable)e);
        }
        return PdfUtil.formatPdf(templatePath, outputPath, data, font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean formatPdf(String templatePath, String outputPath, Map<String, Object> data, BaseFont font) {
        PdfReader reader = null;
        PdfStamper ps = null;
        FileOutputStream fos = null;
        try {
            reader = new PdfReader(templatePath);
            fos = new FileOutputStream(outputPath);
            ps = new PdfStamper(reader, (OutputStream)fos);
            AcroFields fields = ps.getAcroFields();
            ps.setFormFlattening(true);
            for (String key : data.keySet()) {
                String value = String.valueOf(data.get(key));
                if (font != null) {
                    fields.setFieldProperty(key, "textfont", (Object)font, null);
                }
                fields.setField(key, value);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("formatPdf error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (fos != null) {
                    fos.flush();
                    fos.close();
                }
            }
            catch (Exception e) {
                logger.error("formatPdf close error", (Throwable)e);
            }
        }
    }
}

