/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class JsonUtil {
    private static Logger logger = StatusLogger.getLogger();
    private static final String SNAKE_CASE = "snakeCase";
    private static final String LOWER_CAMEL_CASE = "lowerCamelCase";
    private static final String UPPER_CAMEL_CASE = "upperCamelCase";
    private static final String LOWER_CASE = "lowerCase";
    private static final String KEBAB_CASE = "kebabCase";

    public static String toJsonString(Object data) {
        try {
            return JsonUtil.getObjectMapper().writeValueAsString(data);
        }
        catch (Exception e) {
            logger.error("toJson error!", (Throwable)e);
            return null;
        }
    }

    public static ObjectMapper getObjectMapper() {
        try {
            return SpringContext.getBean(ObjectMapper.class);
        }
        catch (Exception e) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new JsmStrategy());
            objectMapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

                public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeNull();
                }
            });
            return objectMapper;
        }
    }

    public static JsonNode readTree(String jsonStr) {
        try {
            return JsonUtil.getObjectMapper().readTree(jsonStr);
        }
        catch (IOException e) {
            logger.error("readTree error!", (Throwable)e);
            return null;
        }
    }

    public static String getStrategyName(String name) {
        String namingStrategy = AppContext.get("jsm.web.json.namingStrategy");
        if (StringUtil.isEmpty(namingStrategy)) {
            return name;
        }
        if (SNAKE_CASE.equalsIgnoreCase(namingStrategy)) {
            return JsonUtil.getStrategyName(name, PropertyNamingStrategy.SNAKE_CASE);
        }
        if (LOWER_CAMEL_CASE.equalsIgnoreCase(namingStrategy)) {
            return StringUtil.lowerCaseFirst(JsonUtil.getStrategyName(name, PropertyNamingStrategy.UPPER_CAMEL_CASE));
        }
        if (UPPER_CAMEL_CASE.equalsIgnoreCase(namingStrategy)) {
            return JsonUtil.getStrategyName(name, PropertyNamingStrategy.UPPER_CAMEL_CASE);
        }
        if (KEBAB_CASE.equalsIgnoreCase(namingStrategy)) {
            return JsonUtil.getStrategyName(name, PropertyNamingStrategy.KEBAB_CASE);
        }
        if (LOWER_CASE.equalsIgnoreCase(namingStrategy)) {
            return JsonUtil.getStrategyName(name, PropertyNamingStrategy.LOWER_CASE);
        }
        return name;
    }

    public static String getStrategyName(String name, PropertyNamingStrategy namingStrategy) {
        if (namingStrategy instanceof PropertyNamingStrategy.SnakeCaseStrategy) {
            return ((PropertyNamingStrategy.SnakeCaseStrategy)namingStrategy).translate(name);
        }
        if (namingStrategy instanceof PropertyNamingStrategy.UpperCamelCaseStrategy) {
            return ((PropertyNamingStrategy.UpperCamelCaseStrategy)namingStrategy).translate(name);
        }
        if (namingStrategy instanceof PropertyNamingStrategy.KebabCaseStrategy) {
            return ((PropertyNamingStrategy.KebabCaseStrategy)namingStrategy).translate(name);
        }
        if (namingStrategy instanceof PropertyNamingStrategy.LowerCaseStrategy) {
            return ((PropertyNamingStrategy.LowerCaseStrategy)namingStrategy).translate(name);
        }
        return name;
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        try {
            return (T)JsonUtil.getObjectMapper().readValue(text, clazz);
        }
        catch (Exception e) {
            logger.error("parseObject error!" + text, (Throwable)e);
            return null;
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> type) {
        try {
            return (T)JsonUtil.getObjectMapper().readValue(text, type);
        }
        catch (Exception e) {
            logger.error("parseObject error!" + text, (Throwable)e);
            return null;
        }
    }

    public static <T> T parseObject(String text, JavaType type) {
        try {
            return (T)JsonUtil.getObjectMapper().readValue(text, type);
        }
        catch (Exception e) {
            logger.error("parseObject error!" + text, (Throwable)e);
            return null;
        }
    }

    public static <T> T parseObject(String text, Type type) {
        try {
            return (T)JsonUtil.getObjectMapper().readValue(text, JsonUtil.getJavaType(type));
        }
        catch (Exception e) {
            logger.error("parseObject error!", (Throwable)e);
            return null;
        }
    }

    public static JavaType getJavaType(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Class rowClass = (Class)((ParameterizedType)type).getRawType();
            JavaType[] javaTypes = new JavaType[actualTypeArguments.length];
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                javaTypes[i] = JsonUtil.getJavaType(actualTypeArguments[i]);
            }
            return TypeFactory.defaultInstance().constructParametricType(rowClass, javaTypes);
        }
        Class cla = (Class)type;
        return TypeFactory.defaultInstance().constructParametricType(cla, new JavaType[0]);
    }

    public static class JsmStrategy
    extends PropertyNamingStrategy.PropertyNamingStrategyBase {
        public String translate(String input) {
            return JsonUtil.getStrategyName(input);
        }
    }
}

