/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.annotation.FieldAnn;
import cn.ibaijia.jsm.consts.BasePairConstants;
import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.context.dao.model.FieldInfo;
import cn.ibaijia.jsm.context.rest.resp.RestResp;
import cn.ibaijia.jsm.context.rest.validate.ValidateModel;
import cn.ibaijia.jsm.exception.AuthFailException;
import cn.ibaijia.jsm.exception.BaseException;
import cn.ibaijia.jsm.exception.NoLoginException;
import cn.ibaijia.jsm.exception.NoPermissionException;
import cn.ibaijia.jsm.exception.NotFoundException;
import cn.ibaijia.jsm.utils.FileUtil;
import cn.ibaijia.jsm.utils.JsonUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.ReflectionUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;

public class JsmFrameUtil {
    private static Logger logger = LogUtil.log(JsmFrameUtil.class);
    private static ScriptEngineManager sem;
    private static ScriptEngine se;

    public static String genMockResult(Method method) {
        String mockJsPath = "META-INF/js/mock.js";
        try {
            InputStream inputStream = JsmFrameUtil.class.getClassLoader().getResourceAsStream(mockJsPath);
            String mockJs = FileUtil.readFileAsText(inputStream);
            if (sem == null) {
                sem = new ScriptEngineManager();
                se = sem.getEngineByName("javascript");
                se.eval(mockJs);
            }
            String jsonStr = JsmFrameUtil.getMockJsonStr(method);
            logger.debug("mockJsStr:{}", (Object)jsonStr);
            jsonStr = jsonStr.replaceAll("\\\"@(.*?)\\\"", "Mock.Random.$1");
            se.eval("var res = Mock.mock(" + jsonStr + ");");
            se.eval("res = JSON.stringify(res);");
            String res = (String)se.get("res");
            return res;
        }
        catch (Exception e) {
            logger.error("genMockResult error.", (Throwable)e);
            return null;
        }
    }

    public static RestResp dealException(Exception e) {
        RestResp baseResp = new RestResp();
        if (e instanceof BaseException) {
            baseResp.setPair(((BaseException)e).getErrorPair());
            baseResp.message = ((BaseException)e).getMsg();
            if (e instanceof NotFoundException) {
                WebContext.getResponse().setStatus(404);
            } else if (e instanceof NoLoginException || e instanceof AuthFailException) {
                WebContext.getResponse().setStatus(401);
            } else if (e instanceof NoPermissionException) {
                WebContext.getResponse().setStatus(403);
            } else {
                WebContext.getResponse().setStatus(400);
            }
        } else {
            WebContext.getResponse().setStatus(500);
            logger.error("other exception", (Throwable)e);
            baseResp.setPair(BasePairConstants.ERROR);
            if (AppContext.isDevModel()) {
                baseResp.message = baseResp.message + "[" + e.getMessage() + "]";
            }
        }
        logger.info("resp:" + StringUtil.toJson(baseResp));
        return baseResp;
    }

    public static String getMockJsonStr(Method method) {
        TreeMap<String, Object> mapObject = new TreeMap<String, Object>();
        List<FieldInfo> fieldInfoList = JsmFrameUtil.getFieldInfoList(method.getReturnType(), JsmFrameUtil.getGenericNames(method.getGenericReturnType()), null, 0, true);
        for (FieldInfo fieldInfo : fieldInfoList) {
            Object value;
            String key = fieldInfo.fieldName;
            key = JsonUtil.getStrategyName(key);
            if (!StringUtil.isEmpty(fieldInfo.fieldAnn.mockRule())) {
                key = key + "|" + fieldInfo.fieldAnn.mockRule();
            }
            if (StringUtil.isEmpty(value = fieldInfo.fieldAnn.mockValue())) {
                value = JsmFrameUtil.getMockJson(fieldInfo);
            }
            mapObject.put(key, value);
        }
        return StringUtil.toJson(mapObject);
    }

    private static Object getMockJson(FieldInfo fieldInfo) {
        Object value = fieldInfo.fieldAnn.mockValue();
        if (StringUtil.isEmpty(value)) {
            int maxLength;
            int minLength = fieldInfo.fieldAnn.minLen() == -1 ? 0 : fieldInfo.fieldAnn.minLen();
            int n = maxLength = fieldInfo.fieldAnn.maxLen() == -1 ? 250 : fieldInfo.fieldAnn.maxLen();
            if (ReflectionUtil.isPlanType(fieldInfo.fieldType)) {
                value = JsmFrameUtil.getPlanTypeVal(fieldInfo.fieldType, minLength, maxLength);
            } else {
                if (fieldInfo.fieldInfoList == null) {
                    logger.error("field name:{} field type:{} maybe not implement ValidateModel.", (Object)fieldInfo.fieldName, (Object)fieldInfo.fieldType);
                    return value;
                }
                TreeMap<String, Object> mapObject = new TreeMap<String, Object>();
                for (FieldInfo fieldInfo1 : fieldInfo.fieldInfoList) {
                    String key = fieldInfo1.fieldName;
                    key = JsonUtil.getStrategyName(key);
                    if (!StringUtil.isEmpty(fieldInfo1.fieldAnn.mockRule())) {
                        key = key + "|" + fieldInfo1.fieldAnn.mockRule();
                    }
                    mapObject.put(key, JsmFrameUtil.getMockJson(fieldInfo1));
                }
                if (ReflectionUtil.isListType(fieldInfo.fieldType)) {
                    int len = fieldInfo.fieldType.split("\\|").length;
                    ArrayList<TreeMap<String, Object>> lastList = null;
                    for (int i = 0; i < len - 1; ++i) {
                        ArrayList<TreeMap<String, Object>> list;
                        lastList = list = new ArrayList<TreeMap<String, Object>>();
                        if (i == 0) {
                            value = list;
                            continue;
                        }
                        ((List)value).add(list);
                    }
                    lastList.add(mapObject);
                } else {
                    value = mapObject;
                }
            }
        }
        return value;
    }

    private static Class createClazz(String typeName) {
        try {
            return Class.forName(typeName.split("<")[0]);
        }
        catch (ClassNotFoundException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static Object getPlanTypeVal(String fieldType, int minLength, int maxLength) {
        String value = null;
        if (ReflectionUtil.isString(fieldType)) {
            value = String.format("@string(%s, %s)", minLength, maxLength);
        } else if (ReflectionUtil.isNumberType(fieldType)) {
            value = String.format("@integer(0,7)", new Object[0]);
        } else if (ReflectionUtil.isDate(fieldType)) {
            value = String.format("@datetime()", new Object[0]);
        } else if (ReflectionUtil.isBoolean(fieldType)) {
            value = String.format("@boolean", new Object[0]);
        }
        return value;
    }

    public static Type[] getGenericTypes(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return null;
    }

    public static String getGenericNames(Type type) {
        Type[] genericTypes = JsmFrameUtil.getGenericTypes(type);
        if (genericTypes != null && genericTypes.length > 0) {
            return genericTypes[0].getTypeName();
        }
        return null;
    }

    public static List<FieldInfo> getFieldInfoList(Class<?> clazz, String genericTypeName, List<String> parentClazzList, int level, boolean withFieldAnn) {
        Field[] fields;
        if (clazz == null) {
            return null;
        }
        ArrayList<FieldInfo> list = new ArrayList<FieldInfo>();
        if (parentClazzList == null) {
            parentClazzList = new ArrayList<String>();
        }
        if (parentClazzList.contains(clazz.getName())) {
            logger.warn("cycle class:{}", (Object)clazz.getName());
            return null;
        }
        parentClazzList.add(clazz.getName());
        for (Field field : fields = clazz.getFields()) {
            Type[] genericTypes;
            FieldAnn fieldAnn = field.getAnnotation(FieldAnn.class);
            if (fieldAnn == null) continue;
            FieldInfo fieldInfo = new FieldInfo();
            if (withFieldAnn) {
                fieldInfo.fieldAnn = fieldAnn;
            }
            fieldInfo.fieldType = field.getType().getSimpleName();
            fieldInfo.fieldName = field.getName();
            fieldInfo.required = fieldAnn.required();
            fieldInfo.comments = fieldAnn.comments();
            fieldInfo.level = level;
            if (!ReflectionUtil.isPlanType(field.getType())) {
                Type type;
                if (Collection.class.isAssignableFrom(field.getType())) {
                    Class clazz1;
                    Type[] genericClazzList1;
                    type = field.getGenericType();
                    int levelList = level + 1;
                    while (type != null && (genericClazzList1 = JsmFrameUtil.getGenericTypes(type)) != null) {
                        type = genericClazzList1[0];
                        if (type instanceof TypeVariable && genericTypeName != null) {
                            type = JsmFrameUtil.createClazz(genericTypeName);
                            break;
                        }
                        if (!(type instanceof ParameterizedType)) break;
                        String typeName = ((ParameterizedType)type).getRawType().getTypeName();
                        fieldInfo.fieldType = fieldInfo.fieldType + "|" + typeName.substring(typeName.lastIndexOf(".") + 1);
                        ++levelList;
                    }
                    if (type != null && (clazz1 = JsmFrameUtil.createClazz(type.getTypeName())) != null) {
                        fieldInfo.fieldType = fieldInfo.fieldType + "|" + clazz1.getSimpleName();
                        fieldInfo.fieldInfoList = JsmFrameUtil.getFieldInfoList(clazz1, parentClazzList, levelList, withFieldAnn);
                    }
                } else if (ValidateModel.class.isAssignableFrom(field.getType())) {
                    fieldInfo.fieldInfoList = JsmFrameUtil.getFieldInfoList(field.getGenericType(), parentClazzList, level + 1, withFieldAnn);
                } else {
                    type = field.getGenericType();
                    if (type instanceof TypeVariable) {
                        if (genericTypeName != null) {
                            Class clazz1 = JsmFrameUtil.createClazz(genericTypeName);
                            fieldInfo.fieldType = clazz1.getSimpleName();
                            fieldInfo.fieldInfoList = JsmFrameUtil.getFieldInfoList(clazz1, JsmFrameUtil.createRemainGeneric(genericTypeName), parentClazzList, level + 1, withFieldAnn);
                            genericTypeName = null;
                        }
                    } else {
                        logger.warn("ignore field info:{}", (Object)StringUtil.toJson(fieldInfo.fieldName));
                    }
                }
            }
            if (genericTypeName == null && (genericTypes = JsmFrameUtil.getGenericTypes(field.getDeclaringClass().getGenericSuperclass())) != null && genericTypes.length > 0) {
                genericTypeName = genericTypes[0].getTypeName();
            }
            list.add(fieldInfo);
        }
        logger.debug("remove:{}", (Object)clazz.getName());
        parentClazzList.remove(clazz.getName());
        return list;
    }

    private static String createRemainGeneric(String typeName) {
        int beginIdx = typeName.indexOf("<");
        int endIdx = typeName.indexOf(">");
        if (beginIdx == -1) {
            return null;
        }
        return typeName.substring(beginIdx + 1, endIdx);
    }

    public static List<FieldInfo> getFieldInfoList(Type type, List<String> parentClazzList, int level, boolean withFieldAnn) {
        if (parentClazzList == null) {
            parentClazzList = new ArrayList<String>();
        }
        if (type instanceof ParameterizedType) {
            Class clazz = JsmFrameUtil.createClazz(((ParameterizedType)type).getRawType().getTypeName());
            String genericName = null;
            Type[] genericTypes = ((ParameterizedType)type).getActualTypeArguments();
            if (genericTypes != null && genericTypes.length > 0) {
                genericName = genericTypes[0].getTypeName();
            }
            return JsmFrameUtil.getFieldInfoList(clazz, genericName, parentClazzList, level, withFieldAnn);
        }
        Class clazz = JsmFrameUtil.createClazz(type.getTypeName());
        return JsmFrameUtil.getFieldInfoList(clazz, null, parentClazzList, level, withFieldAnn);
    }

    public static String getKey(ProceedingJoinPoint jpt) {
        StringBuilder sb = new StringBuilder();
        sb.append("jsm:cache:");
        sb.append(jpt.toString());
        for (Object o : jpt.getArgs()) {
            if (o == null) {
                o = "";
            }
            sb.append(":").append(o.hashCode());
        }
        return sb.toString();
    }

    public static String getLockKey(ProceedingJoinPoint jpt) {
        StringBuilder sb = new StringBuilder();
        sb.append("jsm:lock:");
        sb.append(jpt.toString());
        for (Object o : jpt.getArgs()) {
            if (o == null) {
                o = "";
            }
            sb.append(":").append(o.hashCode());
        }
        return sb.toString();
    }
}

