/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.ShellUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.SystemUtil;
import java.net.InetAddress;
import org.slf4j.Logger;

public class IpUtil {
    private static Logger logger = LogUtil.log(IpUtil.class);
    private String ENABLE_CMD = "iptables -D INPUT -s %s -j DROP";
    private String DISABLE_CMD = "iptables -I INPUT -s %s -j DROP";
    private static String hostIp;
    private static String hostName;

    public static String getHostIp() {
        if (hostIp == null) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                hostIp = addr.getHostAddress();
            }
            catch (Exception e) {
                return null;
            }
        }
        return hostIp;
    }

    public static String getHostName() {
        if (hostName == null) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                hostName = addr.getHostName();
            }
            catch (Exception e) {
                return null;
            }
        }
        return hostName;
    }

    public static boolean checkRemoteIp(String remoteIp, String contextKey) {
        String ips = AppContext.get(contextKey);
        if (StringUtil.isEmpty(ips)) {
            return false;
        }
        return ips.contains(remoteIp);
    }

    public boolean disableIp(String ip) {
        return this.checkAndExec(ip, this.DISABLE_CMD);
    }

    public boolean enableIp(String ip) {
        return this.checkAndExec(ip, this.ENABLE_CMD);
    }

    private boolean checkAndExec(String ip, String disable_cmd) {
        if (!SystemUtil.IS_OS_UNIX) {
            logger.error("not unix ,can't run shell.");
            return false;
        }
        if (!StringUtil.isIpv4(ip)) {
            logger.error("is not a ip:{}", (Object)ip);
            return false;
        }
        String cmd = String.format(disable_cmd, ip);
        ShellUtil.exec(cmd);
        return true;
    }

    public static boolean isInternalIp(String ip) {
        byte[] addr = IpUtil.textToNumericFormatV4(ip);
        return IpUtil.isInternalIp(addr);
    }

    public static byte[] textToNumericFormatV4(String ipStr) {
        byte[] var1 = new byte[4];
        long var2 = 0L;
        int var4 = 0;
        int var5 = ipStr.length();
        if (var5 != 0 && var5 <= 15) {
            for (int var6 = 0; var6 < var5; ++var6) {
                char var7 = ipStr.charAt(var6);
                if (var7 == '.') {
                    if (var2 < 0L || var2 > 255L || var4 == 3) {
                        return null;
                    }
                    var1[var4++] = (byte)(var2 & 0xFFL);
                    var2 = 0L;
                    continue;
                }
                int var8 = Character.digit(var7, 10);
                if (var8 < 0) {
                    return null;
                }
                var2 *= 10L;
                var2 += (long)var8;
            }
            if (var2 >= 0L && var2 < 1L << (4 - var4) * 8) {
                switch (var4) {
                    case 0: {
                        var1[0] = (byte)(var2 >> 24 & 0xFFL);
                    }
                    case 1: {
                        var1[1] = (byte)(var2 >> 16 & 0xFFL);
                    }
                    case 2: {
                        var1[2] = (byte)(var2 >> 8 & 0xFFL);
                    }
                    case 3: {
                        var1[3] = (byte)(var2 >> 0 & 0xFFL);
                    }
                }
                return var1;
            }
            return null;
        }
        return null;
    }

    public static boolean isInternalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Integer ipToInt(String ipStr) {
        String[] ip = ipStr.split("\\.");
        return (Integer.parseInt(ip[0]) << 24) + (Integer.parseInt(ip[1]) << 16) + (Integer.parseInt(ip[2]) << 8) + Integer.parseInt(ip[3]);
    }

    public static String intToIp(int intIp) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf(intIp >> 24) + ".");
        builder.append(String.valueOf((intIp & 0xFFFFFF) >> 16) + ".");
        builder.append(String.valueOf((intIp & 0xFFFF) >> 8) + ".");
        builder.append(String.valueOf(intIp & 0xFF));
        return builder.toString();
    }

    public static String ipToHex(String ipStr) {
        if (StringUtil.isEmpty(ipStr)) {
            return ipStr;
        }
        String[] ip = ipStr.split("\\.");
        if (ip.length != 4) {
            return ipStr;
        }
        StringBuilder sb = new StringBuilder();
        String res1 = Integer.toHexString(Integer.parseInt(ip[0]));
        String res2 = Integer.toHexString(Integer.parseInt(ip[1]));
        String res3 = Integer.toHexString(Integer.parseInt(ip[2]));
        String res4 = Integer.toHexString(Integer.parseInt(ip[3]));
        sb.append(res1.length() < 2 ? "0" + res1 : res1);
        sb.append(res2.length() < 2 ? "0" + res2 : res2);
        sb.append(res3.length() < 2 ? "0" + res3 : res3);
        sb.append(res4.length() < 2 ? "0" + res4 : res4);
        return sb.toString();
    }

    public static String hexToIp(String hexStr) {
        if (hexStr.length() != 8) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.parseInt(hexStr.substring(0, 2), 16)).append(".");
        sb.append(Integer.parseInt(hexStr.substring(2, 4), 16)).append(".");
        sb.append(Integer.parseInt(hexStr.substring(4, 6), 16)).append(".");
        sb.append(Integer.parseInt(hexStr.substring(6, 8), 16));
        return sb.toString();
    }
}

