/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.utils.EncryptUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;

public class ImageUtil {
    private static Logger logger = LogUtil.log(ImageUtil.class);
    public static final String IMAGE_JPEG = "jpg";
    public static final String IMAGE_PNG = "png";
    public static final String IMAGE_GIF = "gif";
    private static final String JPG_HEX = "ff";
    private static final String PNG_HEX = "89";

    public static BufferedImage resizeImage(String imgName, String ext, int maxWidth, int maxHeight) throws IOException {
        return ImageUtil.resizeImage(ImageIO.read(new File(imgName)), ext, maxWidth, maxHeight);
    }

    public static BufferedImage resizeImage(BufferedImage image, String ext, int maxWidth, int maxHeight) {
        Dimension largestDimension = new Dimension(maxWidth, maxHeight);
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        float aspectRation = (float)imageWidth / (float)imageHeight;
        if (imageWidth > maxWidth || imageHeight > maxHeight) {
            if ((float)largestDimension.width / (float)largestDimension.height > aspectRation) {
                largestDimension.width = (int)Math.ceil((float)largestDimension.height * aspectRation);
            } else {
                largestDimension.height = (int)Math.ceil((float)largestDimension.width / aspectRation);
            }
            imageWidth = largestDimension.width;
            imageHeight = largestDimension.height;
        }
        return ImageUtil.createHeadlessSmoothBufferedImage(image, ext, imageWidth, imageHeight);
    }

    public static boolean saveImage(BufferedImage image, String toFileName, String ext) throws IOException {
        return ImageIO.write((RenderedImage)image, IMAGE_JPEG.equals(ext) ? IMAGE_JPEG : IMAGE_PNG, new File(toFileName));
    }

    public static void saveCompressedImage(BufferedImage image, String toFileName, String ext) throws IOException {
        if (IMAGE_PNG.equalsIgnoreCase(ext)) {
            throw new UnsupportedOperationException("PNG compression not implemented");
        }
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(IMAGE_JPEG);
        ImageWriter writer = iter.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(new File(toFileName));
        writer.setOutput(ios);
        JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
        iwparam.setCompressionMode(2);
        iwparam.setCompressionQuality(0.7f);
        writer.write(null, new IIOImage(image, null, null), iwparam);
        ios.flush();
        writer.dispose();
        ios.close();
    }

    public static void compressImage(String imagePath, float quality) throws IOException {
        File file = new File(imagePath);
        BufferedImage srcImage = ImageIO.read(new File(imagePath));
        file.delete();
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(IMAGE_JPEG);
        ImageWriter writer = iter.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(new File(imagePath));
        writer.setOutput(ios);
        JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
        iwparam.setCompressionMode(2);
        iwparam.setCompressionQuality(quality);
        writer.write(null, new IIOImage(srcImage, null, null), iwparam);
        ios.flush();
        writer.dispose();
        ios.close();
    }

    public static String getSuffix(String fileName, String defaultExt) {
        if (fileName.contains(".")) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return defaultExt;
    }

    public static BufferedImage createHeadlessBufferedImage(BufferedImage image, String ext, int width, int height) {
        int type = 0;
        type = IMAGE_PNG.equalsIgnoreCase(ext) && ImageUtil.hasAlpha(image) ? 2 : 1;
        BufferedImage bi = new BufferedImage(width, height, type);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                bi.setRGB(x, y, image.getRGB(x * image.getWidth() / width, y * image.getHeight() / height));
            }
        }
        return bi;
    }

    public static BufferedImage createHeadlessSmoothBufferedImage(BufferedImage source, String ext, int width, int height) {
        int type = 0;
        type = IMAGE_PNG.equalsIgnoreCase(ext) && ImageUtil.hasAlpha(source) ? 2 : 1;
        BufferedImage dest = new BufferedImage(width, height, type);
        double scalex = (double)width / (double)source.getWidth();
        double scaley = (double)height / (double)source.getHeight();
        for (int y = 0; y < height; ++y) {
            int sourcey = y * source.getHeight() / dest.getHeight();
            double ydiff = ImageUtil.scale(y, scaley) - (double)sourcey;
            for (int x = 0; x < width; ++x) {
                int sourcex = x * source.getWidth() / dest.getWidth();
                double xdiff = ImageUtil.scale(x, scalex) - (double)sourcex;
                int x1 = Math.min(source.getWidth() - 1, sourcex + 1);
                int y1 = Math.min(source.getHeight() - 1, sourcey + 1);
                int rgb1 = ImageUtil.getRGBInterpolation(source.getRGB(sourcex, sourcey), source.getRGB(x1, sourcey), xdiff);
                int rgb2 = ImageUtil.getRGBInterpolation(source.getRGB(sourcex, y1), source.getRGB(x1, y1), xdiff);
                int rgb = ImageUtil.getRGBInterpolation(rgb1, rgb2, ydiff);
                dest.setRGB(x, y, rgb);
            }
        }
        return dest;
    }

    private static double scale(int point, double scale) {
        return (double)point / scale;
    }

    private static int getRGBInterpolation(int value1, int value2, double distance) {
        int alpha1 = (value1 & 0xFF000000) >>> 24;
        int red1 = (value1 & 0xFF0000) >> 16;
        int green1 = (value1 & 0xFF00) >> 8;
        int blue1 = value1 & 0xFF;
        int alpha2 = (value2 & 0xFF000000) >>> 24;
        int red2 = (value2 & 0xFF0000) >> 16;
        int green2 = (value2 & 0xFF00) >> 8;
        int blue2 = value2 & 0xFF;
        int rgb = (int)((double)alpha1 * (1.0 - distance) + (double)alpha2 * distance) << 24 | (int)((double)red1 * (1.0 - distance) + (double)red2 * distance) << 16 | (int)((double)green1 * (1.0 - distance) + (double)green2 * distance) << 8 | (int)((double)blue1 * (1.0 - distance) + (double)blue2 * distance);
        return rgb;
    }

    public static boolean hasAlpha(Image image) {
        try {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
            pg.grabPixels();
            return pg.getColorModel().hasAlpha();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static final void pressImage(String targetImg, String waterImg, int x, int y, float alpha) {
        try {
            String ext = ImageUtil.getSuffix(targetImg, IMAGE_JPEG);
            File file = new File(targetImg);
            BufferedImage image = ImageIO.read(file);
            int width = ((Image)image).getWidth(null);
            int height = ((Image)image).getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image, 0, 0, width, height, null);
            BufferedImage waterImage = ImageIO.read(new File(waterImg));
            int width_1 = ((Image)waterImage).getWidth(null);
            int height_1 = ((Image)waterImage).getHeight(null);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            int widthDiff = width - width_1;
            int heightDiff = height - height_1;
            if (x < 0) {
                x = widthDiff / 2;
            } else if (x > widthDiff) {
                x = widthDiff;
            }
            if (y < 0) {
                y = heightDiff / 2;
            } else if (y > heightDiff) {
                y = heightDiff;
            }
            g.drawImage(waterImage, x, y, width_1, height_1, null);
            g.dispose();
            ImageIO.write((RenderedImage)bufferedImage, ext, file);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    public static void pressText(String targetImg, String pressText, String fontName, int fontStyle, int fontSize, Color color, int x, int y, float alpha) {
        try {
            String ext = ImageUtil.getSuffix(targetImg, IMAGE_JPEG);
            File file = new File(targetImg);
            BufferedImage image = ImageIO.read(file);
            int width = ((Image)image).getWidth(null);
            int height = ((Image)image).getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(width - 500, height - 400, 1);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image, -250, -200, width, height, null);
            g.setFont(new Font(fontName, fontStyle, fontSize));
            g.setColor(color);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            int width_1 = fontSize * ImageUtil.getLength(pressText);
            int height_1 = fontSize;
            int widthDiff = width - width_1;
            int heightDiff = height - height_1;
            if (x < 0) {
                x = widthDiff / 2;
            } else if (x > widthDiff) {
                x = widthDiff;
            }
            if (y < 0) {
                y = heightDiff / 2;
            } else if (y > heightDiff) {
                y = heightDiff;
            }
            g.drawString(pressText, x, y + height_1);
            g.dispose();
            ImageIO.write((RenderedImage)bufferedImage, ext, file);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public static int getLength(String text) {
        int textLength;
        int length = textLength = text.length();
        for (int i = 0; i < textLength; ++i) {
            if (String.valueOf(text.charAt(i)).getBytes().length <= 1) continue;
            ++length;
        }
        return length % 2 == 0 ? length / 2 : length / 2 + 1;
    }

    public static void resize(String filePath, int height, int width, boolean bb) {
        try {
            double ratio = 0.0;
            File f = new File(filePath);
            BufferedImage bi = ImageIO.read(f);
            Image itemp = bi.getScaledInstance(width, height, 4);
            if (bi.getHeight() > height || bi.getWidth() > width) {
                ratio = bi.getHeight() > bi.getWidth() ? new Integer(height).doubleValue() / (double)bi.getHeight() : new Integer(width).doubleValue() / (double)bi.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                itemp = op.filter(bi, null);
            }
            if (bb) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, width, height);
                if (width == itemp.getWidth(null)) {
                    g.drawImage(itemp, 0, (height - itemp.getHeight(null)) / 2, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                } else {
                    g.drawImage(itemp, (width - itemp.getWidth(null)) / 2, 0, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                }
                g.dispose();
                itemp = image;
            }
            ImageIO.write((RenderedImage)((BufferedImage)itemp), IMAGE_JPEG, f);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    public static void scaleByWidth(String filePath, int newWidth) {
        try {
            double ratio = 0.0;
            File f = new File(filePath);
            BufferedImage bi = ImageIO.read(f);
            int width = bi.getWidth(null);
            int height = bi.getHeight(null);
            Image itemp = bi.getScaledInstance(width, height, 4);
            if (bi.getWidth() > newWidth) {
                ratio = new Integer(newWidth).doubleValue() / (double)width;
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                itemp = op.filter(bi, null);
            }
            ImageIO.write((RenderedImage)((BufferedImage)itemp), IMAGE_JPEG, f);
        }
        catch (IOException e) {
            logger.error("scaleByWidth error!", (Throwable)e);
        }
    }

    public static BufferedImage rotate(BufferedImage image, int degree, Color bgcolor) throws IOException {
        int iw = image.getWidth();
        int ih = image.getHeight();
        int w = 0;
        int h = 0;
        int x = 0;
        int y = 0;
        if ((degree %= 360) < 0) {
            degree = 360 + degree;
        }
        double ang = Math.toRadians(degree);
        if (degree == 180 || degree == 0 || degree == 360) {
            w = iw;
            h = ih;
        } else if (degree == 90 || degree == 270) {
            w = ih;
            h = iw;
        } else {
            int d = iw + ih;
            w = (int)((double)d * Math.abs(Math.cos(ang)));
            h = (int)((double)d * Math.abs(Math.sin(ang)));
        }
        x = w / 2 - iw / 2;
        y = h / 2 - ih / 2;
        BufferedImage rotatedImage = new BufferedImage(w, h, 1);
        Graphics2D gs = (Graphics2D)rotatedImage.getGraphics();
        if (bgcolor == null) {
            rotatedImage = gs.getDeviceConfiguration().createCompatibleImage(w, h, 1);
        } else {
            gs.setColor(bgcolor);
            gs.fillRect(0, 0, w, h);
        }
        AffineTransform at = new AffineTransform();
        at.rotate(ang, w / 2, h / 2);
        at.translate(x, y);
        AffineTransformOp op = new AffineTransformOp(at, 3);
        op.filter(image, rotatedImage);
        image = rotatedImage;
        return image;
    }

    public static InputStream rotateImg(BufferedImage image, int degree, Color bgcolor) throws IOException {
        int iw = image.getWidth();
        int ih = image.getHeight();
        int w = 0;
        int h = 0;
        int x = 0;
        int y = 0;
        if ((degree %= 360) < 0) {
            degree = 360 + degree;
        }
        double ang = Math.toRadians(degree);
        if (degree == 180 || degree == 0 || degree == 360) {
            w = iw;
            h = ih;
        } else if (degree == 90 || degree == 270) {
            w = ih;
            h = iw;
        } else {
            int d = iw + ih;
            w = (int)((double)d * Math.abs(Math.cos(ang)));
            h = (int)((double)d * Math.abs(Math.sin(ang)));
        }
        x = w / 2 - iw / 2;
        y = h / 2 - ih / 2;
        BufferedImage rotatedImage = new BufferedImage(w, h, image.getType());
        Graphics2D gs = (Graphics2D)rotatedImage.getGraphics();
        if (bgcolor == null) {
            rotatedImage = gs.getDeviceConfiguration().createCompatibleImage(w, h, 3);
        } else {
            gs.setColor(bgcolor);
            gs.fillRect(0, 0, w, h);
        }
        AffineTransform at = new AffineTransform();
        at.rotate(ang, w / 2, h / 2);
        at.translate(x, y);
        AffineTransformOp op = new AffineTransformOp(at, 3);
        op.filter(image, rotatedImage);
        image = rotatedImage;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ImageOutputStream iamgeOut = ImageIO.createImageOutputStream(byteOut);
        ImageIO.write((RenderedImage)image, IMAGE_PNG, iamgeOut);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteOut.toByteArray());
        return inputStream;
    }

    public static Graphics2D drawAL(int sx, int sy, int ex, int ey, Graphics2D g2) {
        logger.info("drawAL sx:" + sx + "  sy:" + sy + "  ex:" + ex + "  ey:" + ey);
        double H = 10.0;
        double L = 4.0;
        int x3 = 0;
        int y3 = 0;
        int x4 = 0;
        int y4 = 0;
        double awrad = Math.atan(L / H);
        double arraow_len = Math.sqrt(L * L + H * H);
        double[] arrXY_1 = ImageUtil.rotateVec(ex - sx, ey - sy, awrad, true, arraow_len);
        double[] arrXY_2 = ImageUtil.rotateVec(ex - sx, ey - sy, -awrad, true, arraow_len);
        double x_3 = (double)ex - arrXY_1[0];
        double y_3 = (double)ey - arrXY_1[1];
        double x_4 = (double)ex - arrXY_2[0];
        double y_4 = (double)ey - arrXY_2[1];
        Double X3 = new Double(x_3);
        x3 = X3.intValue();
        Double Y3 = new Double(y_3);
        y3 = Y3.intValue();
        Double X4 = new Double(x_4);
        x4 = X4.intValue();
        Double Y4 = new Double(y_4);
        y4 = Y4.intValue();
        g2.drawLine(sx, sy, ex, ey);
        GeneralPath triangle = new GeneralPath();
        triangle.moveTo(ex, ey);
        triangle.lineTo(x3, y3);
        triangle.lineTo(x4, y4);
        triangle.closePath();
        g2.fill(triangle);
        return g2;
    }

    private static double[] rotateVec(int px, int py, double ang, boolean isChLen, double newLen) {
        double[] mathstr = new double[2];
        double vx = (double)px * Math.cos(ang) - (double)py * Math.sin(ang);
        double vy = (double)px * Math.sin(ang) + (double)py * Math.cos(ang);
        if (isChLen) {
            double d = Math.sqrt(vx * vx + vy * vy);
            vx = vx / d * newLen;
            vy = vy / d * newLen;
            mathstr[0] = vx;
            mathstr[1] = vy;
        }
        return mathstr;
    }

    public static void addText(String destImage, String text) throws IOException {
        File file = new File(destImage);
        BufferedImage image = ImageIO.read(file);
        int width = ((Image)image).getWidth(null);
        int height = ((Image)image).getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height + 20, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, width, height, null);
        g.setColor(Color.white);
        g.fillRect(0, height, width, 20);
        g.setColor(Color.red);
        g.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16));
        g.drawString(text, 0, height + 16);
        g.dispose();
        ImageIO.write((RenderedImage)bufferedImage, IMAGE_JPEG, new File(destImage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toBase64(String imgFilePath) {
        byte[] data = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(imgFilePath);
            data = new byte[((InputStream)is).available()];
            ((InputStream)is).read(data);
            ((InputStream)is).close();
            String string = EncryptUtil.base64Encode(data);
            return string;
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fromBase64(String imgStr, String imgFilePath) {
        if (imgStr == null) {
            return false;
        }
        int headerIdx = imgStr.indexOf("base64,");
        if (headerIdx != -1) {
            imgStr = imgStr.substring(headerIdx + 7);
        }
        OutputStream out = null;
        try {
            byte[] bytes = EncryptUtil.base64Decode(imgStr, "UTF-8");
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] >= 0) continue;
                int n = i;
                bytes[n] = (byte)(bytes[n] + 256);
            }
            out = new FileOutputStream(imgFilePath);
            out.flush();
            out.write(bytes);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutJPG(InputStream input, OutputStream out, int x, int y, int width, int height) {
        ImageInputStream imageStream = null;
        try {
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(IMAGE_JPEG);
            ImageReader reader = readers.next();
            imageStream = ImageIO.createImageInputStream(input);
            reader.setInput(imageStream, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle rect = new Rectangle(x, y, width, height);
            param.setSourceRegion(rect);
            BufferedImage bi = reader.read(0, param);
            ImageIO.write((RenderedImage)bi, IMAGE_JPEG, out);
        }
        catch (IOException e) {
            logger.error("cutJPG error!", (Throwable)e);
        }
        finally {
            try {
                imageStream.close();
            }
            catch (IOException e) {
                logger.error("cutJPG error!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutPNG(InputStream input, OutputStream out, int x, int y, int width, int height) {
        ImageInputStream imageStream = null;
        try {
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(IMAGE_PNG);
            ImageReader reader = readers.next();
            imageStream = ImageIO.createImageInputStream(input);
            reader.setInput(imageStream, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle rect = new Rectangle(x, y, width, height);
            param.setSourceRegion(rect);
            BufferedImage bi = reader.read(0, param);
            ImageIO.write((RenderedImage)bi, IMAGE_PNG, out);
        }
        catch (IOException e) {
            logger.error("cutPNG error!", (Throwable)e);
        }
        finally {
            try {
                imageStream.close();
            }
            catch (IOException e) {
                logger.error("cutPNG error!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutImage(InputStream input, OutputStream out, int x, int y, int width, int height, String imageType) {
        ImageInputStream imageStream = null;
        try {
            logger.debug("imageType:" + imageType);
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(imageType);
            if (!readers.hasNext()) {
                return;
            }
            ImageReader reader = readers.next();
            imageStream = ImageIO.createImageInputStream(input);
            reader.setInput(imageStream, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle rect = new Rectangle(x, y, width, height);
            param.setSourceRegion(rect);
            BufferedImage bi = reader.read(0, param);
            ImageIO.write((RenderedImage)bi, imageType, out);
        }
        catch (IOException e) {
            logger.error("cutImage error!", (Throwable)e);
        }
        finally {
            try {
                imageStream.close();
            }
            catch (IOException e) {
                logger.error("cutImage error!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageExtension(String imagePath) {
        FileInputStream fis = null;
        String extension = imagePath.substring(imagePath.lastIndexOf(46) + 1);
        try {
            fis = new FileInputStream(new File(imagePath));
            byte[] bs = new byte[1];
            fis.read(bs);
            String type = Integer.toHexString(bs[0] & 0xFF);
            if (JPG_HEX.equals(type)) {
                extension = IMAGE_JPEG;
            }
            if (PNG_HEX.equals(type)) {
                extension = IMAGE_PNG;
            }
        }
        catch (Exception e) {
            logger.error("getImageExtension error!", (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                logger.error("getImageExtension error!", (Throwable)e);
            }
        }
        return extension;
    }
}

