/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.utils.LogUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;

public class HtmlUtil {
    private static Logger logger = LogUtil.log(HtmlUtil.class);
    private static String regEx_script = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
    private static String regEx_css = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>";
    private static String regEx_html = "<[^>]+>";
    private static String regEx_el = "[${]";

    public static String filter(String str) {
        if (str == null) {
            return "";
        }
        str = HtmlUtil.jsFilter(str);
        str = HtmlUtil.cssFilter(str);
        str = HtmlUtil.htmlFilter(str);
        str = HtmlUtil.elFilter(str);
        return str;
    }

    public static String elFilter(String str) {
        if (str == null) {
            return "";
        }
        Pattern p_script = Pattern.compile(regEx_el, 2);
        Matcher m_script = p_script.matcher(str);
        str = m_script.replaceAll("");
        return str;
    }

    public static String jsFilter(String str) {
        if (str == null) {
            return "";
        }
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(str);
        str = m_script.replaceAll("");
        return str;
    }

    public static String htmlFilter(String str) {
        if (str == null) {
            return "";
        }
        Pattern p_script = Pattern.compile(regEx_html, 2);
        Matcher m_script = p_script.matcher(str);
        str = m_script.replaceAll("");
        return str;
    }

    public static String cssFilter(String str) {
        if (str == null) {
            return "";
        }
        Pattern p_script = Pattern.compile(regEx_css, 2);
        Matcher m_script = p_script.matcher(str);
        str = m_script.replaceAll("");
        return str;
    }

    public static Document getDocument(String url) {
        Document document = null;
        try {
            document = Jsoup.connect((String)url).get();
        }
        catch (IOException e) {
            logger.error("getDocument error url:" + url, (Throwable)e);
        }
        return document;
    }

    public static Document parse(String html) {
        Document document = null;
        try {
            document = Jsoup.parse((String)html);
        }
        catch (Exception e) {
            logger.error("parse error html:" + html, (Throwable)e);
        }
        return document;
    }
}

