/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.PropUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;

public class EncryptUtil {
    private static Logger logger = LogUtil.log(PropUtil.class);

    public static String md5(String str) {
        return EncryptUtil.encode(str, "MD5").toUpperCase();
    }

    public static String sha(String str) {
        return EncryptUtil.encode(str, "SHA");
    }

    public static String sha1(String str) {
        return EncryptUtil.encode(str, "SHA-1");
    }

    public static String base64Encode(String str) {
        String charset = "UTF-8";
        return EncryptUtil.base64Encode(str.getBytes(), charset);
    }

    public static String base64Encode(byte[] bytes) {
        String charset = "UTF-8";
        return EncryptUtil.base64Encode(bytes, charset);
    }

    public static String base64Encode(byte[] bytes, String charset) {
        try {
            Base64 base64 = new Base64();
            return new String(base64.encode(bytes), charset);
        }
        catch (Exception e) {
            logger.error("base64Encode error!", (Throwable)e);
            return null;
        }
    }

    public static String base64Decode(String str) {
        String charset = "UTF-8";
        return new String(EncryptUtil.base64Decode(str, charset));
    }

    public static byte[] base64Decode(String str, String charset) {
        try {
            Base64 base64 = new Base64();
            return base64.decode(str);
        }
        catch (Exception e) {
            logger.error("base64Decode error!", (Throwable)e);
            return null;
        }
    }

    private static String encode(String str, String method) {
        MessageDigest md = null;
        StringBuilder dstr = new StringBuilder(32);
        try {
            md = MessageDigest.getInstance(method);
            byte[] bytes = md.digest(str.getBytes());
            for (int i = 0; i < bytes.length; ++i) {
                String astr = Integer.toHexString(bytes[i] & 0xFF);
                if (astr.length() == 1) {
                    dstr.append("0");
                }
                dstr.append(astr);
            }
            return dstr.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("encode error!", (Throwable)e);
            return dstr.toString();
        }
    }

    public static String byteToHex(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) throws IOException {
        System.out.println("lappmd5\u52a0\u5bc6:" + EncryptUtil.md5("hc123").toLowerCase());
    }

    public static String soeEncode(String str) {
        byte[] arr = str.getBytes();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)(arr[i] - 10 ^ 0xA);
        }
        Base64 base64 = new Base64();
        ArrayUtils.reverse((byte[])arr);
        return new String(base64.encode(arr));
    }

    public static String soeDecode(String str) {
        Base64 base64 = new Base64();
        byte[] arr = base64.decode(str.getBytes());
        ArrayUtils.reverse((byte[])arr);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)((arr[i] ^ 0xA) + 10);
        }
        return new String(arr);
    }

    public static String lappMd5(String str) {
        return EncryptUtil.md5(EncryptUtil.base64Encode(str + "@lapp") + str + EncryptUtil.base64Encode(str));
    }

    public static String lappSha(String str) {
        return EncryptUtil.sha(EncryptUtil.base64Encode(str + "@lapp") + str + EncryptUtil.base64Encode(str));
    }

    public static String urlDecode(String str) {
        return EncryptUtil.urlDecode(str, "UTF-8");
    }

    public static String urlEncode(String str) {
        return EncryptUtil.urlEncode(str, "UTF-8");
    }

    public static String urlDecode(String str, String enc) {
        try {
            return URLDecoder.decode(str, enc);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("urlDecode error!", (Throwable)e);
            return null;
        }
    }

    public static String urlEncode(String str, String enc) {
        try {
            return URLEncoder.encode(str, enc);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("urlEncode error!", (Throwable)e);
            return null;
        }
    }
}

