/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.utils.LogUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;

public class ClassUtil {
    private static Logger logger = LogUtil.log(ClassUtil.class);

    public static boolean hasClass(String clazzName) {
        try {
            return null != Class.forName(clazzName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isComplexClass(Class<?> clz) {
        try {
            if (clz.isPrimitive() || clz.equals(String.class)) {
                return false;
            }
            Field field = clz.getField("TYPE");
            if (field != null && (clz = (Class)field.get(null)) != null && clz.isPrimitive()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean isWrapClass(Class<?> clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Set<Class<?>> loadClass(String packagePath) {
        return ClassUtil.loadClass(packagePath, true);
    }

    public static Set<Class<?>> loadClass(String packagePath, boolean recursive) {
        HashSet classes = new HashSet();
        String packageDir = packagePath.replace('.', '/');
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(packageDir);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if ("file".equals(url.getProtocol())) {
                    String filePath = URLDecoder.decode(url.getFile(), "utf-8");
                    logger.info("find class in dir: {}", (Object)filePath);
                    ClassUtil.findClassesInFolder(filePath, packagePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(url.getProtocol())) continue;
                JarURLConnection jarUrl = (JarURLConnection)url.openConnection();
                JarFile jar = jarUrl.getJarFile();
                logger.info("find class in dir: {}", (Object)jar.getName());
                ClassUtil.findClassesInJar(jar, packageDir, recursive, classes);
            }
        }
        catch (IOException e) {
            logger.error("scan package: {} error!", (Object)packagePath, (Object)e);
        }
        return classes;
    }

    private static void findClassesInJar(JarFile jar, String packageDir, boolean recursive, Set<Class<?>> classes) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (!name.startsWith(packageDir) || !recursive && name.substring(packageDir.length() + 1).contains("/") || !name.endsWith(".class") || entry.isDirectory()) continue;
            String fullClassName = name.substring(0, name.length() - 6).replace('/', '.');
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(fullClassName));
            }
            catch (Exception e) {
                logger.error("class not found {}", (Object)fullClassName, (Object)e);
            }
        }
    }

    private static void findClassesInFolder(String packageDir, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packageDir);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassUtil.findClassesInFolder(packageDir + "/" + file.getName(), packagePath + '.' + file.getName(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            String fullClassName = packagePath + '.' + className;
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(fullClassName));
            }
            catch (ClassNotFoundException e) {
                logger.error("class not found {}", (Object)fullClassName, (Object)e);
            }
        }
    }

    public static void main(String[] args) {
        String pakg = "org.apache.commons.beanutils";
        for (Class<?> clazz : ClassUtil.loadClass(pakg, false)) {
            System.out.println(clazz.getName());
        }
    }
}

