/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.utils;

import cn.ibaijia.jsm.utils.DateUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import java.lang.reflect.Field;
import java.util.Date;
import org.slf4j.Logger;

public class BeanUtil {
    private static Logger logger = LogUtil.log(BeanUtil.class);

    public static void copy(Object org, Object dest, String ... ignoreProperties) {
        Field[] orgFields;
        for (Field field : orgFields = org.getClass().getFields()) {
            Field destField;
            String name = field.getName();
            if (BeanUtil.ignore(name, ignoreProperties) || (destField = BeanUtil.getField(dest, name)) == null) continue;
            BeanUtil.copyField(org, dest, field, destField);
        }
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        if (value == null) {
            return;
        }
        try {
            Class<?> fieldType = field.getType();
            if (fieldType.isAssignableFrom(value.getClass())) {
                field.set(obj, value);
            } else {
                String valueStr = value.toString();
                logger.debug("field type:" + fieldType);
                logger.debug("valueStr:" + valueStr);
                if (fieldType.isAssignableFrom(Integer.class) || fieldType.isAssignableFrom(Integer.TYPE)) {
                    value = Float.valueOf(valueStr).intValue();
                } else if (fieldType.isAssignableFrom(Date.class)) {
                    if (value instanceof Long) {
                        value = DateUtil.parse((Long)value);
                    } else if (value instanceof String) {
                        value = DateUtil.parse(valueStr);
                    }
                } else if (fieldType.isAssignableFrom(Long.class) || fieldType.isAssignableFrom(Long.TYPE)) {
                    value = Long.valueOf(valueStr);
                } else if (fieldType.isAssignableFrom(Float.class) || fieldType.isAssignableFrom(Float.TYPE)) {
                    value = Float.valueOf(valueStr);
                } else if (fieldType.isAssignableFrom(Double.class) || fieldType.isAssignableFrom(Double.TYPE)) {
                    value = Double.valueOf(valueStr);
                } else if (fieldType.isAssignableFrom(Short.class) || fieldType.isAssignableFrom(Short.TYPE)) {
                    value = Short.valueOf(valueStr);
                } else if (fieldType.isAssignableFrom(Byte.class) || fieldType.isAssignableFrom(Byte.TYPE)) {
                    value = Byte.valueOf(valueStr);
                } else if (fieldType.isAssignableFrom(Boolean.class) || fieldType.isAssignableFrom(Boolean.TYPE)) {
                    value = Boolean.valueOf(valueStr);
                } else if (fieldType.isAssignableFrom(String.class)) {
                    value = valueStr;
                }
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            logger.error("setFieldValue error!", (Throwable)e);
        }
    }

    private static void copyField(Object org, Object dest, Field field, Field destField) {
        try {
            Class<?> destType = destField.getType();
            Class<?> orgType = field.getType();
            Object orgValue = BeanUtil.getFieldValue(field, org);
            if (orgValue == null) {
                destField.set(dest, orgValue);
                return;
            }
            if (destType.isAssignableFrom(orgType)) {
                destField.set(dest, orgValue);
            } else {
                String orgValueStr = orgValue.toString();
                logger.debug("dest type:" + destType);
                logger.debug("orgValueStr:" + orgValueStr);
                if (destType.isAssignableFrom(Integer.class) || destType.isAssignableFrom(Integer.TYPE)) {
                    orgValue = Float.valueOf(orgValueStr).intValue();
                } else if (destType.isAssignableFrom(Date.class)) {
                    if (orgValue instanceof Long) {
                        orgValue = DateUtil.parse((Long)orgValue);
                    } else if (orgValue instanceof String) {
                        orgValue = DateUtil.parse(orgValueStr);
                    }
                } else if (destType.isAssignableFrom(Long.class) || destType.isAssignableFrom(Long.TYPE)) {
                    orgValue = Long.valueOf(orgValueStr);
                } else if (destType.isAssignableFrom(Float.class) || destType.isAssignableFrom(Float.TYPE)) {
                    orgValue = Float.valueOf(orgValueStr);
                } else if (destType.isAssignableFrom(Double.class) || destType.isAssignableFrom(Double.TYPE)) {
                    orgValue = Double.valueOf(orgValueStr);
                } else if (destType.isAssignableFrom(Short.class) || destType.isAssignableFrom(Short.TYPE)) {
                    orgValue = Short.valueOf(orgValueStr);
                } else if (destType.isAssignableFrom(Byte.class) || destType.isAssignableFrom(Byte.TYPE)) {
                    orgValue = Byte.valueOf(orgValueStr);
                } else if (destType.isAssignableFrom(Boolean.class) || destType.isAssignableFrom(Boolean.TYPE)) {
                    orgValue = Boolean.valueOf(orgValueStr);
                } else if (destType.isAssignableFrom(String.class)) {
                    orgValue = orgValueStr;
                }
                destField.set(dest, orgValue);
            }
        }
        catch (Exception e) {
            logger.error("copyField error:" + field.getName(), (Throwable)e);
        }
    }

    private static Field getField(Object dest, String name) {
        try {
            return dest.getClass().getField(name);
        }
        catch (Exception e) {
            logger.debug("getField {} error!", (Object)name);
            return null;
        }
    }

    private static boolean ignore(String name, String[] ignoreProperties) {
        if (ignoreProperties == null) {
            return false;
        }
        for (String prop : ignoreProperties) {
            if (!prop.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Object getFieldValue(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (Exception e) {
            logger.error("getFieldValue error!", (Throwable)e);
            return null;
        }
    }

    public static Object getFieldValue(String fieldName, Object obj) {
        try {
            if (!fieldName.contains(".")) {
                Field field = BeanUtil.getDeclaredField(obj, fieldName);
                return field.get(obj);
            }
            int firstIdx = fieldName.indexOf(".");
            String firstField = fieldName.substring(0, firstIdx);
            Field field = BeanUtil.getDeclaredField(obj, firstField);
            return BeanUtil.getFieldValue(fieldName.substring(firstIdx + 1), field.get(obj));
        }
        catch (Exception e) {
            logger.error("getFieldValue error!", (Throwable)e);
            return null;
        }
    }

    private static Field getDeclaredField(Object object, String fieldName) {
        if (object == null) {
            logger.error("object is null ,can't get fieldName.{}", (Object)fieldName);
            return null;
        }
        if (StringUtil.isEmpty(fieldName)) {
            logger.error("fieldName is empty ,can't get fieldName.");
            return null;
        }
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }
}

