/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.stat.strategy;

import cn.ibaijia.jsm.disruptor.JsmDisruptor;
import cn.ibaijia.jsm.elastic.BatchObject;
import cn.ibaijia.jsm.elastic.ElasticClient;
import cn.ibaijia.jsm.log4j2.LogStrategy;
import cn.ibaijia.jsm.stat.model.Alarm;
import cn.ibaijia.jsm.utils.DateUtil;
import cn.ibaijia.jsm.utils.JsonUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.SystemUtil;
import com.lmax.disruptor.EventHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public abstract class ElasticStrategy
implements LogStrategy {
    private ElasticClient elasticClient;
    private AtomicLong idAi = new AtomicLong(0L);
    private List<BatchObject> cacheMessage = new ArrayList<BatchObject>();
    private static final int BATCH_SIZE = 500;
    private JsmDisruptor<String> stringDisruptor = new JsmDisruptor<String>(new EventHandler<JsmDisruptor.MessageEvent<String>>(){

        public void onEvent(JsmDisruptor.MessageEvent<String> stringMessageEvent, long sequence, boolean endOfBatch) {
            try {
                ElasticStrategy.this.cacheMessage.add(new BatchObject(ElasticStrategy.this.getId(), (String)stringMessageEvent.message));
                if (endOfBatch || (sequence + 1L) % 500L == 0L) {
                    ElasticStrategy.this.elasticClient.postBatch(ElasticStrategy.this.cacheMessage);
                    ElasticStrategy.this.cacheMessage.clear();
                }
            }
            catch (Exception e) {
                SystemUtil.addAlarm(new Alarm("ElasticAppender", "onEvent error."));
            }
        }
    }, 4096);

    @Override
    public void write(Serializable object) {
        String text = null;
        text = object instanceof String ? (String)((Object)object) : JsonUtil.toJsonString(object);
        if (this.elasticClient == null) {
            this.elasticClient = this.createElasticClient();
            if (this.elasticClient == null) {
                return;
            }
        }
        this.stringDisruptor.pushMessage(text);
    }

    private String getId() {
        try {
            long intCount = 0L;
            intCount = this.idAi.getAndIncrement();
            if (intCount > 9223372036854774807L) {
                this.idAi.set(0L);
            }
            return String.format("%s-%s", DateUtil.format(DateUtil.currentDate(), "yyyyMMdd"), intCount);
        }
        catch (Exception e) {
            return StringUtil.uuid();
        }
    }

    protected abstract ElasticClient createElasticClient();
}

