/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.stat.strategy;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.elastic.ElasticClient;
import cn.ibaijia.jsm.stat.strategy.ElasticStrategy;
import cn.ibaijia.jsm.utils.StringUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="elasticLogStrategy")
public class ElasticLogStrategy
extends ElasticStrategy {
    private String jsonOption = "{\"mappings\":{\"properties\":{\"time\":{\"type\":\"date\",\"format\":\"yyyyMMdd HH:mm:ss.SSS||epoch_millis\"},\"logName\":{\"type\":\"keyword\"},\"methodName\":{\"type\":\"keyword\"},\"traceId\":{\"type\":\"keyword\"},\"level\":{\"type\":\"keyword\"},\"thread\":{\"type\":\"keyword\"}}}}";
    @Value(value="${jsm.log.idx:jsm_log_idx}")
    private String idx;

    @Override
    protected ElasticClient createElasticClient() {
        String address = AppContext.get("jsm.elastic.address");
        if (StringUtil.isEmpty(address)) {
            System.out.println("jsm.elastic.address ,not found.");
            return null;
        }
        System.out.println("elastic.address:" + address);
        ElasticClient elasticClient = new ElasticClient(String.format("%s/%s", address, this.idx));
        elasticClient.createIndexIfNotExists(this.jsonOption);
        return elasticClient;
    }
}

