/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.stat.strategy;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.elastic.ElasticClient;
import cn.ibaijia.jsm.stat.strategy.ElasticStrategy;
import cn.ibaijia.jsm.utils.StringUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="elasticAlarmStrategy")
public class ElasticAlarmStrategy
extends ElasticStrategy {
    private static String jsonOption = "{\"mappings\":{\"properties\":{\"time\":{\"type\":\"date\",\"format\":\"yyyyMMdd HH:mm:ss.SSS||epoch_millis\"},\"level\":{\"type\":\"keyword\"},\"name\":{\"type\":\"keyword\"},\"traceId\":{\"type\":\"keyword\"},\"comments\":{\"type\":\"keyword\"},\"clusterId\":{\"type\":\"keyword\"},\"ip\":{\"type\":\"keyword\"}}}}";
    @Value(value="${jsm.alarm.idx:jsm_alarm_idx}")
    private String idx;

    @Override
    protected ElasticClient createElasticClient() {
        String address = AppContext.get("jsm.elastic.address");
        if (StringUtil.isEmpty(address)) {
            System.out.println("jsm.elastic.address ,not found.");
            return null;
        }
        System.out.println("elastic.address:" + address);
        ElasticClient elasticClient = new ElasticClient(String.format("%s/%s", address, this.idx));
        elasticClient.createIndexIfNotExists(jsonOption);
        return elasticClient;
    }
}

