/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.stat;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.context.service.BaseService;
import cn.ibaijia.jsm.log4j2.LogStrategy;
import cn.ibaijia.jsm.stat.JsmSysStatService;
import cn.ibaijia.jsm.stat.model.SystemStat;
import cn.ibaijia.jsm.utils.JsonUtil;
import cn.ibaijia.jsm.utils.SystemUtil;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DefaultSysStatService
extends BaseService
implements JsmSysStatService {
    private LogStrategy logStrategy;
    @Value(value="${jsm.sysStat.interval:600}")
    private Integer interval;

    private void loadLogStrategy() {
        if (this.logStrategy == null) {
            String logType = AppContext.get("jsm.sysStat.type", "none");
            if ("none".equals(logType)) {
                return;
            }
            this.logStrategy = "console".equals(logType) ? (LogStrategy)SpringContext.getBean("consoleStrategy") : (LogStrategy)SpringContext.getBean(logType + "SysStatStrategy");
        }
    }

    @Override
    public void add(SystemStat sysStat) {
        this.loadLogStrategy();
        if (this.logStrategy != null) {
            this.logStrategy.write(sysStat);
        } else {
            this.logger.trace(JsonUtil.toJsonString(sysStat));
        }
    }

    @Override
    public void writeNow() {
        this.add(SystemUtil.getSystemStat());
    }

    @Override
    public void start() {
        try {
            this.logger.info("start JsmSysStatService delay:60 interval:{}", (Object)this.interval);
            ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
            scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    DefaultSysStatService.this.writeNow();
                }
            }, 60L, this.interval.intValue(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.error("start JsmSysStatService error.", (Throwable)e);
        }
    }
}

