/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.stat;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.context.dao.model.OptLog;
import cn.ibaijia.jsm.context.service.BaseService;
import cn.ibaijia.jsm.log4j2.LogStrategy;
import cn.ibaijia.jsm.stat.JsmOptLogService;
import cn.ibaijia.jsm.utils.JsonUtil;
import org.springframework.stereotype.Service;

@Service
public class DefaultOptLogService
extends BaseService
implements JsmOptLogService {
    private LogStrategy logStrategy;

    private void loadLogStrategy() {
        if (this.logStrategy == null) {
            String logType = AppContext.get("jsm.optLog.type", "none");
            if ("none".equals(logType)) {
                return;
            }
            this.logStrategy = "console".equals(logType) ? (LogStrategy)SpringContext.getBean("consoleStrategy") : (LogStrategy)SpringContext.getBean(logType + "OptLogStrategy");
        }
    }

    @Override
    public void add(OptLog optLog) {
        this.loadLogStrategy();
        if (this.logStrategy != null) {
            this.logStrategy.write(optLog);
        } else {
            this.logger.trace(JsonUtil.toJsonString(optLog));
        }
    }
}

