/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.stat;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.context.service.BaseService;
import cn.ibaijia.jsm.log4j2.LogStrategy;
import cn.ibaijia.jsm.stat.JsmApiStatService;
import cn.ibaijia.jsm.stat.model.Alarm;
import cn.ibaijia.jsm.stat.model.ApiStat;
import cn.ibaijia.jsm.utils.JsonUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.SystemUtil;
import org.springframework.stereotype.Service;

@Service
public class DefaultApiStatService
extends BaseService
implements JsmApiStatService {
    private int slowApiLimit;
    private LogStrategy logStrategy;

    private void loadLogStrategy() {
        if (this.logStrategy == null) {
            this.slowApiLimit = AppContext.getAsInteger("jsm.slow.apiLimit", 3000);
            String logType = AppContext.get("jsm.apiStat.type", "none");
            if ("none".equals(logType)) {
                return;
            }
            this.logStrategy = "console".equals(logType) ? (LogStrategy)SpringContext.getBean("consoleStrategy") : (LogStrategy)SpringContext.getBean(logType + "ApiStatStrategy");
        }
    }

    @Override
    public void add(ApiStat apiStat) {
        this.loadLogStrategy();
        if (apiStat.spendTime > (long)this.slowApiLimit) {
            SystemUtil.addAlarm(new Alarm("SlowApi", StringUtil.toJson(apiStat)));
        }
        if (this.logStrategy != null) {
            this.logStrategy.write(apiStat);
        } else {
            this.logger.trace(JsonUtil.toJsonString(apiStat));
        }
    }
}

