/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.stat;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.context.service.BaseService;
import cn.ibaijia.jsm.log4j2.LogStrategy;
import cn.ibaijia.jsm.stat.JsmAlarmService;
import cn.ibaijia.jsm.stat.model.Alarm;
import cn.ibaijia.jsm.utils.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.springframework.stereotype.Service;

@Service
public class DefaultAlarmService
extends BaseService
implements JsmAlarmService {
    private Queue<Alarm> alarmQueue = new ConcurrentLinkedDeque<Alarm>();
    private Integer maxCount;
    private LogStrategy logStrategy;

    private void loadLogStrategy() {
        if (this.logStrategy == null) {
            String logType = AppContext.get("jsm.alarm.type", "none");
            this.maxCount = AppContext.getAsInteger("jsm.alarm.max", 100);
            if ("none".equals(logType)) {
                return;
            }
            this.logStrategy = "console".equals(logType) ? (LogStrategy)SpringContext.getBean("consoleStrategy") : (LogStrategy)SpringContext.getBean(logType + "AlarmStrategy");
        }
    }

    @Override
    public void add(Alarm alarm) {
        this.loadLogStrategy();
        if (this.logStrategy != null) {
            this.logStrategy.write(alarm);
        } else {
            this.logger.trace(JsonUtil.toJsonString(alarm));
            if (this.alarmQueue.size() < this.maxCount) {
                this.alarmQueue.add(alarm);
            }
        }
    }

    @Override
    public void clear() {
        this.alarmQueue.clear();
    }

    @Override
    public List<Alarm> pull() {
        ArrayList<Alarm> alarms = new ArrayList<Alarm>();
        int len = this.alarmQueue.size();
        for (int i = 0; i < len; ++i) {
            alarms.add(this.alarmQueue.poll());
        }
        return alarms;
    }
}

