/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.spring.boot.autoconfigure;

import cn.ibaijia.jsm.utils.LogUtil;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisMapperConfig
implements InitializingBean {
    private static Logger logger = LogUtil.log(MybatisMapperConfig.class);

    @Bean
    @ConditionalOnMissingBean(value={MapperScannerConfigurer.class})
    @ConditionalOnProperty(prefix="jsm.mybatis", name={"basePackage"}, matchIfMissing=true)
    public MapperScannerConfigurer createMapperScannerConfigurer() {
        logger.debug("createMapperScannerConfigurer");
        MapperScannerConfigurer mapperScannerConfigurer = new MapperScannerConfigurer();
        mapperScannerConfigurer.setBasePackage("cn.ibaijia.jsm.context.dao.mapper");
        mapperScannerConfigurer.setSqlSessionFactoryBeanName("sqlSessionFactory");
        return mapperScannerConfigurer;
    }

    public void afterPropertiesSet() throws Exception {
        logger.debug("MybatisMapperConfig afterPropertiesSet");
    }
}

