/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.spring.boot.autoconfigure;

import cn.ibaijia.jsm.mybatis.PageInterceptor;
import cn.ibaijia.jsm.mybatis.datasource.DynamicDataSource;
import cn.ibaijia.jsm.spring.boot.autoconfigure.SpringBootVfs;
import cn.ibaijia.jsm.spring.boot.autoconfigure.properties.DbMasterProperties;
import cn.ibaijia.jsm.spring.boot.autoconfigure.properties.DbProperties;
import cn.ibaijia.jsm.spring.boot.autoconfigure.properties.DbSlaveProperties;
import cn.ibaijia.jsm.spring.boot.autoconfigure.properties.MybatisConfigProperties;
import cn.ibaijia.jsm.utils.BlowFishUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import com.alibaba.druid.pool.DruidDataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@EnableConfigurationProperties(value={MybatisConfigProperties.class, DbMasterProperties.class, DbSlaveProperties.class})
public class MybatisConfig
implements InitializingBean {
    private static Logger logger = LogUtil.log(MybatisConfig.class);
    @Autowired
    private MybatisConfigProperties mybatisConfigProperties;
    @Autowired
    private DbMasterProperties dbMasterProperties;
    @Autowired
    private DbSlaveProperties dbSlaveProperties;

    @Bean(name={"transactionManager"})
    @ConditionalOnMissingBean(value={DataSourceTransactionManager.class})
    public DataSourceTransactionManager createDataSourceTransactionManager() {
        logger.debug("createDataSourceTransactionManager");
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource((DataSource)((Object)this.createDynamicDataSource()));
        return dataSourceTransactionManager;
    }

    @Bean(name={"sqlSessionFactory"})
    @ConditionalOnMissingBean(value={SqlSessionFactoryBean.class})
    public SqlSessionFactoryBean createSqlSessionFactoryBean() {
        logger.debug("createSqlSessionFactoryBean");
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setVfs(SpringBootVfs.class);
        if (!StringUtil.isEmpty(this.mybatisConfigProperties.typeAliasesPackage)) {
            this.mybatisConfigProperties.typeAliasesPackage = "cn.ibaijia.jsm.context.dao.model," + this.mybatisConfigProperties.typeAliasesPackage;
        }
        sqlSessionFactoryBean.setTypeAliasesPackage(this.mybatisConfigProperties.typeAliasesPackage);
        sqlSessionFactoryBean.setDataSource((DataSource)((Object)this.createDynamicDataSource()));
        sqlSessionFactoryBean.setMapperLocations(this.resolveMapperLocations());
        sqlSessionFactoryBean.setPlugins(this.resolvePlugins());
        return sqlSessionFactoryBean;
    }

    @Bean(name={"dynamicDataSource"})
    @ConditionalOnMissingBean(value={DynamicDataSource.class})
    public DynamicDataSource createDynamicDataSource() {
        logger.info("createDynamicDataSource");
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        HashMap<String, DruidDataSource> targetDataSources = new HashMap<String, DruidDataSource>();
        DruidDataSource master = this.createMasterBasicDataSource();
        DruidDataSource slave = this.createSlaveBasicDataSource();
        targetDataSources.put("master", master);
        targetDataSources.put("slave", slave);
        dynamicDataSource.setTargetDataSources(targetDataSources);
        dynamicDataSource.setDefaultTargetDataSource(master);
        return dynamicDataSource;
    }

    private DruidDataSource createMasterBasicDataSource() {
        if (this.dbSlaveProperties == null || this.dbMasterProperties.getUrl() == null) {
            logger.warn("db.master not config.");
            return null;
        }
        logger.debug("createMasterBasicDataSource masterUrl:{}", (Object)this.dbMasterProperties.getUrl());
        return this.createBasicDataSource(this.dbMasterProperties);
    }

    private DruidDataSource createBasicDataSource(DbProperties dbProperties) {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDriverClassName(dbProperties.getDriverClassName());
        dataSource.setUrl(this.dbMasterProperties.getUrl());
        dataSource.setUsername(dbProperties.getUsername());
        if (StringUtil.isEmpty(dbProperties.getEncPassword())) {
            dataSource.setPassword(dbProperties.getPassword());
        } else {
            dataSource.setPassword(BlowFishUtil.dec(dbProperties.getEncPassword()));
        }
        dataSource.setMaxActive(dbProperties.getMaxActive().intValue());
        dataSource.setMinIdle(dbProperties.getMinIdle().intValue());
        dataSource.setValidationQuery(dbProperties.getValidationQuery());
        dataSource.setTestOnBorrow(dbProperties.getTestOnBorrow().booleanValue());
        return dataSource;
    }

    public DruidDataSource createSlaveBasicDataSource() {
        if (this.dbSlaveProperties == null || this.dbSlaveProperties.getUrl() == null) {
            logger.warn("db.slave not config.");
            return null;
        }
        logger.debug("createSlaveBasicDataSource slaveUrl:{}", (Object)this.dbSlaveProperties.getUrl());
        return this.createBasicDataSource(this.dbSlaveProperties);
    }

    public Resource[] resolveMapperLocations() {
        logger.info("resolveMapperLocations :{}", (Object[])this.mybatisConfigProperties.mapperLocations);
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        ArrayList<String> mapperLocations = new ArrayList<String>();
        mapperLocations.addAll(Arrays.asList(this.mybatisConfigProperties.mapperLocations));
        mapperLocations.add("classpath*:/META-INF/mappers/DbMapper.xml");
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String mapperLocation : mapperLocations) {
            try {
                Resource[] mappers = resourceResolver.getResources(mapperLocation);
                resources.addAll(Arrays.asList(mappers));
            }
            catch (IOException e) {
                logger.error("resolveMapperLocations error." + mapperLocation, (Throwable)e);
            }
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public Interceptor[] resolvePlugins() {
        logger.info("resolvePlugins dbDialect:{}", (Object)this.mybatisConfigProperties.pageDbDialect);
        ArrayList<PageInterceptor> list = new ArrayList<PageInterceptor>();
        PageInterceptor pageInterceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.put("dbDialect", this.mybatisConfigProperties.pageDbDialect);
        pageInterceptor.setProperties(properties);
        list.add(pageInterceptor);
        return list.toArray(new Interceptor[list.size()]);
    }

    public void afterPropertiesSet() throws Exception {
        logger.debug("MybatisConfig afterPropertiesSet");
    }
}

