/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.spring.boot.autoconfigure;

import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class JsmSwaggerConfig
implements InitializingBean {
    private static Logger logger = LogUtil.log(JsmSwaggerConfig.class);
    @Value(value="${jsm.swagger.enable}")
    public Boolean enable;
    @Value(value="${jsm.swagger.restPackage}")
    public String restPackage;
    @Value(value="${jsm.swagger.title}")
    public String title;
    @Value(value="${jsm.swagger.description}")
    public String description;
    @Value(value="${jsm.swagger.version}")
    public String version;
    @Value(value="${jsm.swagger.headers}")
    public String headers;

    @Bean
    public Docket createRestApi() {
        logger.debug("createRestApi");
        logger.info("swaggerEnable:{} ", (Object)this.enable);
        logger.info("swaggerPackage:{} ", (Object)this.restPackage);
        logger.info("swaggerTitle:{} ", (Object)this.title);
        logger.info("swaggerVersion:{} ", (Object)this.version);
        logger.info("swaggerDescription:{} ", (Object)this.description);
        logger.info("swaggerHeaders:{} ", (Object)this.headers);
        ApiInfo apiInfo = this.apiInfo();
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(new Parameter("jsm-mock", "", "", false, false, (ModelReference)new ModelRef("String"), null, null, "query", null, false, null));
        if (!StringUtil.isEmpty(this.headers)) {
            String[] headersArr = this.headers.split(";");
            WebContext.JSM_AUTHORIZATION = headersArr[0].split("\\|")[0];
            for (String header : headersArr) {
                String[] headeArr = header.split("\\|");
                params.add(new Parameter(headeArr[0], "", "", false, false, (ModelReference)new ModelRef("String"), null, null, "header", null, false, null));
            }
        }
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo).enable(this.enable.booleanValue()).globalOperationParameters(params).select().apis(RequestHandlerSelectors.basePackage((String)this.restPackage)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.title).version(this.version).description(this.description).build();
    }

    public void afterPropertiesSet() throws Exception {
        logger.debug("JsmSwaggerConfig afterPropertiesSet");
    }
}

