/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.spring.boot.autoconfigure;

import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.QuartzUtil;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
public class JsmScheduleConfig
implements SchedulingConfigurer {
    protected Logger logger = LogUtil.log(this.getClass());
    @Value(value="${jsm.schedule.poolSize:5}")
    private Integer poolSize;
    @Value(value="${jsm.schedule.quartzEnable:false}")
    private Boolean quartzEnable;
    @Value(value="${jsm.schedule.quartzPoolSize:5}")
    private Integer quartzPoolSize;

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        scheduledTaskRegistrar.setScheduler((Object)this.setTaskExecutors());
    }

    @Bean(destroyMethod="shutdown")
    public Executor setTaskExecutors() {
        this.logger.debug("setTaskExecutors!");
        if (this.quartzEnable.booleanValue()) {
            try {
                Properties properties = new Properties();
                properties.put("org.quartz.threadPool.threadCount", this.quartzPoolSize);
                StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(properties);
                QuartzUtil.setSchedulerFactory((SchedulerFactory)schedulerFactory);
            }
            catch (SchedulerException e) {
                this.logger.error("init quartz error!", (Throwable)e);
            }
        }
        return new ScheduledThreadPoolExecutor((int)this.quartzPoolSize, new ThreadFactory(){
            byte index = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                this.index = (byte)(this.index + 1);
                return new Thread(runnable, "jsm-job" + this.index);
            }
        });
    }
}

