/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.spring.boot.autoconfigure;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.interceptor.JsmFilter;
import cn.ibaijia.jsm.context.interceptor.JsmRestInterceptor;
import cn.ibaijia.jsm.context.listener.JsmHttpSessionListener;
import cn.ibaijia.jsm.context.listener.JsmServletContextListener;
import cn.ibaijia.jsm.utils.JsonUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.EventListener;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.env.Environment;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

@Configuration
@ComponentScan(basePackages={"cn.ibaijia.jsm.auth", "cn.ibaijia.jsm.license", "cn.ibaijia.jsm.cache", "cn.ibaijia.jsm.aop", "cn.ibaijia.jsm.context", "cn.ibaijia.jsm.stat", "cn.ibaijia.jsm.stat.strategy", "cn.ibaijia.jsm.gen"})
@AutoConfigureAfter(value={AopAutoConfiguration.class})
public class JsmMvcConfig
implements WebMvcConfigurer {
    protected Logger logger = LogUtil.log(this.getClass());
    @Value(value="${jsm.web.maxUploadSize:1024000}")
    private Integer maxUploadSize;
    @Value(value="${jsm.web.encoding:UTF-8}")
    private String encoding;
    @Value(value="${jsm.web.staticDir:/static/}")
    private String staticDir;
    @Value(value="${jsm.web.staticPath:/static/}")
    private String staticPath;
    @Value(value="${spring.messages.basename:messages/message}")
    private String messagesBaseName;
    @Value(value="${jsm.web.json.namingStrategy:CamelCase}")
    private String namingStrategy;
    @Resource
    private Environment environment;

    @Bean
    public ServletListenerRegistrationBean<JsmServletContextListener> createJsmServletContextListenerBean() {
        this.logger.debug("createJsmServletContextListenerBean");
        AppContext.setEnvironment(this.environment);
        return new ServletListenerRegistrationBean((EventListener)((Object)new JsmServletContextListener()));
    }

    @Bean
    public ServletListenerRegistrationBean<JsmHttpSessionListener> createJsmHttpSessionListenerBean() {
        this.logger.debug("createJsmHttpSessionListenerBean");
        AppContext.setEnvironment(this.environment);
        return new ServletListenerRegistrationBean((EventListener)((Object)new JsmHttpSessionListener()));
    }

    @Bean
    public FilterRegistrationBean<JsmFilter> createJsmFilterBean() {
        this.logger.debug("createJsmFilterBean");
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new JsmFilter());
        bean.addUrlPatterns(new String[]{"*"});
        bean.addInitParameter("encoding", "UTF-8");
        bean.setName("jsmFilter");
        bean.setOrder(1);
        bean.addInitParameter("exclude", this.staticPath);
        return bean;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        this.logger.debug("addResourceHandlers");
        registry.addResourceHandler(new String[]{this.staticPath + "swagger/**"}).addResourceLocations(new String[]{"classpath:/META-INF/swagger/"});
        registry.addResourceHandler(new String[]{this.staticPath + "/**"}).addResourceLocations(new String[]{"classpath:" + this.staticDir});
    }

    public void addInterceptors(InterceptorRegistry registry) {
        this.logger.debug("addInterceptors");
        registry.addInterceptor((HandlerInterceptor)new JsmRestInterceptor()).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{this.staticPath + "**"});
        registry.addInterceptor((HandlerInterceptor)new LocaleChangeInterceptor()).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{this.staticPath + "**"});
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        this.logger.debug("configureMessageConverters");
        for (HttpMessageConverter<?> converter : converters) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            ((MappingJackson2HttpMessageConverter)converter).setObjectMapper(this.createObjectMapper());
        }
    }

    @Bean
    public ObjectMapper createObjectMapper() {
        this.logger.debug("createObjectMapper");
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new JsonUtil.JsmStrategy());
        objectMapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeNull();
            }
        });
        return objectMapper;
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource getMessageResource() {
        this.logger.debug("getMessageResource");
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename(this.messagesBaseName);
        return messageSource;
    }

    @Bean(name={"multipartResolver"})
    public CommonsMultipartResolver createDynamicDataSource() {
        this.logger.debug("createDynamicDataSource");
        CommonsMultipartResolver commonsMultipartResolver = new CommonsMultipartResolver();
        commonsMultipartResolver.setMaxUploadSize((long)this.maxUploadSize.intValue());
        return commonsMultipartResolver;
    }
}

