/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.spring.boot.autoconfigure;

import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import java.util.ArrayList;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedisPool;

@Configuration
public class JsmCacheConfig
implements DisposableBean {
    private Logger logger = LogUtil.log(this.getClass());
    @Value(value="${jsm.redis.uri}")
    private String uri;
    @Value(value="${jsm.redis.pool.maxTotal}")
    private Integer maxTotal;
    @Value(value="${jsm.redis.pool.maxIdle}")
    private Integer maxIdle;
    @Value(value="${jsm.redis.pool.minIdle}")
    private Integer minIdle;
    @Value(value="${jsm.redis.pool.maxWaitMillis}")
    private Integer maxWaitMillis;
    @Value(value="${jsm.redis.pool.testOnBorrow}")
    private Boolean testOnBorrow;
    @Value(value="${jsm.redis.pool.testOnReturn}")
    private Boolean testOnReturn;
    private ShardedJedisPool shardedJedisPool;
    private JedisPool jedisPool;

    @Bean
    @ConditionalOnMissingBean(value={ShardedJedisPool.class})
    public ShardedJedisPool createShardedJedisPool() {
        this.logger.debug("createShardedJedisPool");
        JedisPoolConfig jedisPoolConfig = this.createJedisPoolConfig();
        ArrayList<JedisShardInfo> list = new ArrayList<JedisShardInfo>();
        list.add(this.createJedisShardInfo());
        this.shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)jedisPoolConfig, list);
        return this.shardedJedisPool;
    }

    @Bean
    @ConditionalOnMissingBean(value={JedisPool.class})
    public JedisPool createJedisPool() {
        this.logger.debug("createJedisPool redis.uri:{} ", (Object)this.uri);
        JedisPoolConfig jedisPoolConfig = this.createJedisPoolConfig();
        String host = StringUtil.extract("@(\\S*?)[:/?]", this.uri, 1);
        String port = StringUtil.extract("@\\S*?:(\\d+)", this.uri, 1);
        int timeout = 2000;
        String dbIdx = StringUtil.extract("@\\S*?[:\\d+?]/(\\d+)", this.uri, 1);
        String password = StringUtil.extract("://:(\\S*?)@", this.uri, 1);
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, StringUtil.toInteger(port, 6379).intValue(), timeout, password, StringUtil.toInteger(dbIdx).intValue());
        return this.jedisPool;
    }

    private JedisPoolConfig createJedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(this.maxTotal.intValue());
        jedisPoolConfig.setMaxIdle(this.maxIdle.intValue());
        jedisPoolConfig.setMinIdle(this.minIdle.intValue());
        jedisPoolConfig.setTestOnBorrow(this.testOnBorrow.booleanValue());
        jedisPoolConfig.setTestOnReturn(this.testOnReturn.booleanValue());
        jedisPoolConfig.setMaxWaitMillis((long)this.maxWaitMillis.intValue());
        return jedisPoolConfig;
    }

    private JedisShardInfo createJedisShardInfo() {
        JedisShardInfo jedisShardInfo = new JedisShardInfo(this.uri);
        return jedisShardInfo;
    }

    public void destroy() {
        this.logger.debug("createJedisPool destroy!");
        if (this.shardedJedisPool != null) {
            this.shardedJedisPool.close();
        }
        if (this.jedisPool != null) {
            this.jedisPool.close();
        }
    }
}

