/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.mybatis;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.dao.BaseModel;
import cn.ibaijia.jsm.context.dao.model.Page;
import cn.ibaijia.jsm.mybatis.Db2Dialect;
import cn.ibaijia.jsm.mybatis.Dialect;
import cn.ibaijia.jsm.mybatis.MssqlDialect;
import cn.ibaijia.jsm.mybatis.MysqlDialect;
import cn.ibaijia.jsm.mybatis.OracleDialect;
import cn.ibaijia.jsm.stat.model.Alarm;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.SystemUtil;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PageInterceptor
implements Interceptor {
    private static Logger logger = LogUtil.log(PageInterceptor.class);
    private Dialect dialect = new MysqlDialect();
    private static final String MYSQL = "mysql";
    private static final String ORACLE = "oracle";
    private static final String DB2 = "db2";
    private static final String MSSQL = "mssql";
    private static final String FOR_UPDATE_SUFFIX = ".findByIdForUpdate";
    private String countSuffix = "_COUNT";
    private long slowSqlLimit = AppContext.getAsLong("jsm.slow.sqlLimit", 5000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        logger.trace("query args:{}", (Object)args.length);
        MappedStatement ms = (MappedStatement)args[0];
        logger.trace("id:{}", (Object)ms.getId());
        Object parameterObject = args[1];
        BoundSql boundSql = null;
        boundSql = args.length == 4 ? ms.getBoundSql(parameterObject) : (BoundSql)args[5];
        String sql = boundSql.getSql();
        if (boundSql.getParameterObject() instanceof Page) {
            Page page = (Page)boundSql.getParameterObject();
            String pageSql = null;
            Statement countStmt = null;
            Connection connection = null;
            ResultSet rs = null;
            String countSql = null;
            int totalCount = 0;
            try {
                countSql = this.findManualCountSql(ms.getConfiguration(), ms.getId() + this.countSuffix, parameterObject);
                sql = StringUtil.normalizeSQL(sql);
                if (countSql == null) {
                    countSql = this.dialect.concatCountSql(sql);
                    logger.debug("use concatCountSql:{}", (Object)ms.getId());
                }
                logger.info("countSql: {}", (Object)countSql);
                pageSql = this.dialect.concatPageSql(sql, page.getBeginIndex(), page.getPageSize());
                connection = ms.getConfiguration().getEnvironment().getDataSource().getConnection();
                countStmt = connection.prepareStatement(countSql);
                BoundSql countBoundSql = this.dialect.createNewBoundSql(ms, boundSql, countSql);
                DefaultParameterHandler parameterHandler = new DefaultParameterHandler(ms, parameterObject, countBoundSql);
                parameterHandler.setParameters((PreparedStatement)countStmt);
                rs = countStmt.executeQuery();
                if (rs.next()) {
                    totalCount = rs.getInt(1);
                }
            }
            catch (Exception e) {
                logger.error("count records for page error!sql:" + sql, (Throwable)e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (countStmt != null) {
                        countStmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    logger.error("count records for page close conn error!sql:" + sql, (Throwable)e);
                }
            }
            page.setTotalCount(totalCount);
            MappedStatement newMs = this.dialect.createNewMappedStatement(ms, boundSql, pageSql);
            invocation.getArgs()[0] = newMs;
            Object list = this.getProceedResult(invocation, sql);
            page.setList((List)list);
            return list;
        }
        Object object = this.getProceedResult(invocation, sql);
        if (ms != null && ms.getId() != null && ms.getId().endsWith(FOR_UPDATE_SUFFIX) && object != null) {
            if (object instanceof List) {
                List list = (List)object;
                if (list.isEmpty() || list.get(0) instanceof BaseModel) {
                    // empty if block
                }
                for (Object o : list) {
                    ((BaseModel)o).createSnapshot();
                }
            } else if (object instanceof BaseModel) {
                ((BaseModel)object).createSnapshot();
            }
        }
        return object;
    }

    private Object getProceedResult(Invocation invocation, String sql) throws InvocationTargetException, IllegalAccessException {
        long begin = System.currentTimeMillis();
        Object object = invocation.proceed();
        long spend = System.currentTimeMillis() - begin;
        if (spend > this.slowSqlLimit) {
            SystemUtil.addAlarm(new Alarm("SlowSql", String.format("spend:%s sql:%s", spend, sql)));
        }
        return object;
    }

    private String findManualCountSql(Configuration configuration, String msId, Object parameterObject) {
        try {
            if (configuration.hasStatement(msId, false)) {
                MappedStatement mappedStatement = configuration.getMappedStatement(msId, false);
                logger.debug("use findManualCountSql:{}", (Object)msId);
                return mappedStatement.getBoundSql(parameterObject).getSql();
            }
        }
        catch (Exception e) {
            logger.error("findManualCountSql error." + msId);
        }
        return null;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        logger.debug("properties:{}", (Object)StringUtil.toJson(properties));
        String dbDialect = properties.getProperty("dbDialect");
        if (MYSQL.equalsIgnoreCase(dbDialect)) {
            this.dialect = new MysqlDialect();
        } else if (ORACLE.equalsIgnoreCase(dbDialect)) {
            this.dialect = new OracleDialect();
        } else if (DB2.equalsIgnoreCase(dbDialect)) {
            this.dialect = new Db2Dialect();
        } else if (MSSQL.equalsIgnoreCase(dbDialect)) {
            this.dialect = new MssqlDialect();
        } else {
            logger.warn("dbDialect not specify, use default:mysql");
        }
    }
}

