/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.mybatis;

import cn.ibaijia.jsm.mybatis.Dialect;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;

public abstract class AbstractDialect
implements Dialect {
    protected static Pattern fromPattern = Pattern.compile("\\s+from\\s+", 2);
    protected static Pattern orderByPattern = Pattern.compile("\\s+order\\s+by\\s+", 2);
    protected static int ORDER_BY_START_IDX = 16;
    protected Properties properties;

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public BoundSql createNewBoundSql(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return newBoundSql;
    }

    @Override
    public MappedStatement createNewMappedStatement(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = this.createNewBoundSql(ms, boundSql, sql);
        return this.createNewMappedStatement(ms, this.getSqlSource(newBoundSql));
    }

    @Override
    public MappedStatement createNewMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    @Override
    public String concatCountSql(String sql) {
        int lastIndex;
        StringBuilder sb = new StringBuilder("select count(*) from ");
        int beginIndex = this.findBeginIdx(sql);
        Matcher orderByMatcher = orderByPattern.matcher(sql);
        if (orderByMatcher.find((lastIndex = sql.lastIndexOf(")")) > 0 ? lastIndex : ORDER_BY_START_IDX)) {
            sb.append(sql, beginIndex, orderByMatcher.start());
        } else {
            sb.append(sql.substring(beginIndex));
        }
        return sb.toString();
    }

    @Override
    public String getSqlBody(String sql) {
        Matcher fromMatcher = fromPattern.matcher(sql);
        int beginIndex = 0;
        if (fromMatcher.find()) {
            beginIndex = fromMatcher.end();
        }
        return sql.substring(beginIndex);
    }

    @Override
    public SqlSource getSqlSource(final BoundSql boundSql) {
        return new SqlSource(){

            public BoundSql getBoundSql(Object parameterObject) {
                return boundSql;
            }
        };
    }

    protected int findBeginIdx(String sql) {
        int beginIdx;
        int idxFrom = beginIdx = 7;
        sql = sql.toLowerCase();
        sql = sql.replace("(", " ").replace(")", " ");
        StringBuilder sb = new StringBuilder(sql);
        while (beginIdx < sql.length()) {
            int idxSelect = sb.indexOf(" select ", beginIdx);
            idxFrom = sb.indexOf(" from ", beginIdx);
            if (idxSelect == -1 || idxSelect > idxFrom) break;
            beginIdx = idxFrom + 6;
        }
        return idxFrom + 6;
    }
}

