/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.log4j2;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.WebContext;
import java.util.Arrays;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;

public class LogContent {
    public String appName = AppContext.get("jsm.appName", "");
    public String env = AppContext.get("jsm.env", "");
    public String gitHash = AppContext.get("jsm.gitHash", "");
    public String uid;
    public long time;
    public String traceId;
    public String level;
    public String thread;
    public String logName;
    public String methodName;
    public String logMsg;
    public String exMsg;
    public String exName;
    public String exTrace;

    public LogContent(LogEvent event, String traceId) {
        ThrowableProxy thrownProxy;
        this.time = event.getTimeMillis();
        this.logName = event.getLoggerName();
        this.traceId = traceId;
        this.level = event.getLevel().name();
        this.thread = event.getThreadName();
        this.uid = WebContext.currentUserId();
        if (event.getSource() != null) {
            this.methodName = event.getSource().getMethodName();
        }
        if (event.getMessage() != null) {
            this.logMsg = event.getMessage().getFormattedMessage();
        }
        if ((thrownProxy = event.getThrownProxy()) != null) {
            this.exMsg = thrownProxy.getMessage();
            this.exName = thrownProxy.getName();
            this.exTrace = this.parseException(thrownProxy.getStackTrace());
        }
    }

    private String parseException(StackTraceElement[] stackTrace) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        Arrays.stream(stackTrace).forEach(e -> sb.append(e.getClassName()).append(".").append(e.getMethodName()).append("(").append(e.getFileName()).append(":").append(e.getLineNumber()).append(")").append("\n"));
        return sb.toString();
    }
}

