/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.log4j2;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.log4j2.LogContent;
import cn.ibaijia.jsm.log4j2.LogStrategy;
import cn.ibaijia.jsm.utils.JsonUtil;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="JsmAppender", category="Core", elementType="appender", printObject=true)
public class JsmAppender
extends AbstractAppender {
    private static AtomicLong idAi = new AtomicLong(0L);
    private static String clusterId;
    private static final int BATCH_SIZE = 500;
    private static LogStrategy logStrategy;

    protected JsmAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    public void append(LogEvent event) {
        String traceId = WebContext.getTraceId(event.getThreadName());
        if (traceId == null) {
            return;
        }
        if (logStrategy == null) {
            String logType = AppContext.get("jsm.log.type");
            if ("none".equals(logType)) {
                return;
            }
            logStrategy = this.getStrategyByType(logType);
            if (logStrategy == null) {
                System.out.println("logStrategy not found:" + AppContext.get("jsm.log.type"));
                return;
            }
        }
        LogContent logContent = new LogContent(event, traceId);
        logStrategy.write((Serializable)((Object)JsonUtil.toJsonString(logContent)));
    }

    private LogStrategy getStrategyByType(String type) {
        if ("console".equals(type)) {
            return (LogStrategy)SpringContext.getBean("consoleStrategy");
        }
        return (LogStrategy)SpringContext.getBean(type + "LogStrategy");
    }

    @PluginFactory
    public static JsmAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginAttribute(value="address") String address) {
        if (name == null) {
            name = "JsmAppender";
            LOGGER.warn("JsmAppender no name attribute,use default:" + name);
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new JsmAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions);
    }
}

