/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.http;

import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.http.MyConnectionSocketFactory;
import cn.ibaijia.jsm.http.MySSLConnectionSocketFactory;
import cn.ibaijia.jsm.stat.model.Alarm;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class HttpAsyncClient {
    private Logger logger = StatusLogger.getLogger();
    private Charset DEFAULT_CHARSET = Consts.UTF_8;
    private HttpHost proxyHost;
    private HttpClientContext httpClientContext = HttpClientContext.create();
    private PoolingHttpClientConnectionManager connManager;
    private RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").build();
    private CookieStore cookieStore = new BasicCookieStore();
    private boolean withExtra = true;
    private boolean useCookie = true;
    private CloseableHttpAsyncClient closeableHttpAsyncClient = null;

    public HttpAsyncClient() {
        if (this.useCookie) {
            this.httpClientContext.setCookieStore(this.cookieStore);
            this.httpClientContext.setRequestConfig(this.requestConfig);
        }
        this.getClient();
    }

    public HttpAsyncClient(boolean useCookie) {
        this.useCookie = useCookie;
        if (useCookie) {
            this.httpClientContext.setCookieStore(this.cookieStore);
            this.httpClientContext.setRequestConfig(this.requestConfig);
        }
        this.getClient();
    }

    private void addAlarm(String method, String url, String errorMessage) {
        SystemUtil.addAlarm(new Alarm("HttpAsyncClient", "" + method + "," + url + "," + errorMessage));
    }

    public boolean isWithExtra() {
        return this.withExtra;
    }

    public void setWithExtra(boolean withExtra) {
        this.withExtra = withExtra;
    }

    public void setSocksProxy(String ip, int port) {
        Registry reg = RegistryBuilder.create().register("http", (Object)new MyConnectionSocketFactory()).register("https", (Object)new MySSLConnectionSocketFactory(SSLContexts.createSystemDefault())).build();
        this.connManager = new PoolingHttpClientConnectionManager(reg);
        this.httpClientContext.setAttribute("socks.address", (Object)new InetSocketAddress(ip, port));
    }

    public HttpHost getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(HttpHost proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void get(String url, FutureCallback futureCallback) {
        this.get(null, url, futureCallback);
    }

    public void get(List<Header> headers, String url, FutureCallback futureCallback) {
        this.logger.debug("get url:" + url);
        CloseableHttpAsyncClient httpclient = this.getClient();
        try {
            HttpGet httpGet = new HttpGet(url);
            if (headers != null) {
                httpGet.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpGet);
            httpclient.execute((HttpUriRequest)httpGet, futureCallback);
        }
        catch (Exception e) {
            this.logger.error("http get error:" + url, (Throwable)e);
            this.addAlarm("get", url, e.getMessage());
        }
    }

    public void post(String url, List<NameValuePair> nvps, FutureCallback futureCallback) {
        this.post(null, url, nvps, futureCallback);
    }

    public void post(List<Header> headers, String url, List<NameValuePair> nvps, FutureCallback futureCallback) {
        this.logger.debug("post url:" + url);
        this.logger.debug("request nvps:{}", (Object)StringUtil.toJson(nvps));
        CloseableHttpAsyncClient httpclient = this.getClient();
        try {
            HttpPost httpPost = new HttpPost(url);
            if (headers != null) {
                httpPost.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpPost);
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(nvps, this.DEFAULT_CHARSET);
            this.logger.debug(EntityUtils.toString((HttpEntity)httpEntity));
            httpPost.setEntity((HttpEntity)httpEntity);
            httpclient.execute((HttpUriRequest)httpPost, futureCallback);
        }
        catch (Exception e) {
            this.logger.error("http post error:" + url, (Throwable)e);
            this.addAlarm("post", url, e.getMessage());
        }
    }

    public void post(String url, Object data, FutureCallback futureCallback) {
        if (data instanceof String) {
            this.post(null, url, (String)data, futureCallback);
        } else {
            this.post(null, url, StringUtil.toJson(data), futureCallback);
        }
    }

    public void post(String url, String strEntity, FutureCallback futureCallback) {
        this.post(null, url, strEntity, futureCallback);
    }

    public void post(List<Header> headers, String url, Object data, FutureCallback futureCallback) {
        if (data instanceof String) {
            this.post(headers, url, (String)data, futureCallback);
        } else {
            this.post(headers, url, StringUtil.toJson(data), futureCallback);
        }
    }

    public void post(List<Header> headers, String url, String strEntity, FutureCallback futureCallback) {
        this.logger.debug("post url:" + url);
        this.logger.debug("requestBody:{}", (Object)strEntity);
        CloseableHttpAsyncClient httpclient = this.getClient();
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(strEntity, this.DEFAULT_CHARSET);
            if (headers != null) {
                httpPost.setHeaders(headers.toArray(new Header[headers.size()]));
            } else {
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json; charset=UTF-8");
            }
            this.setExtraHeaders((HttpRequestBase)httpPost);
            httpPost.setEntity((HttpEntity)entity);
            httpclient.execute((HttpUriRequest)httpPost, futureCallback);
        }
        catch (Exception e) {
            this.logger.error("http post error:" + url, (Throwable)e);
            this.addAlarm("post", url, e.getMessage());
        }
    }

    public void put(String url, Object data, FutureCallback futureCallback) {
        if (data instanceof String) {
            this.put(null, url, (String)data, futureCallback);
        } else {
            this.put(null, url, StringUtil.toJson(data), futureCallback);
        }
    }

    public void put(List<Header> headers, String url, String strEntity, FutureCallback futureCallback) {
        this.logger.debug("put url:" + url);
        this.logger.debug("requestBody:{}", (Object)strEntity);
        CloseableHttpAsyncClient httpclient = this.getClient();
        try {
            HttpPut httpPut = new HttpPut(url);
            StringEntity entity = new StringEntity(strEntity, this.DEFAULT_CHARSET);
            if (headers != null) {
                httpPut.setHeaders(headers.toArray(new Header[headers.size()]));
            } else {
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json; charset=UTF-8");
            }
            this.setExtraHeaders((HttpRequestBase)httpPut);
            httpPut.setEntity((HttpEntity)entity);
            httpclient.execute((HttpUriRequest)httpPut, futureCallback);
        }
        catch (Exception e) {
            this.logger.error("http put error:" + url, (Throwable)e);
            this.addAlarm("put", url, e.getMessage());
        }
    }

    public void delete(String url, FutureCallback futureCallback) {
        this.delete(null, url, futureCallback);
    }

    public void delete(List<Header> headers, String url, FutureCallback futureCallback) {
        this.logger.debug("delete url:" + url);
        Object res = null;
        CloseableHttpAsyncClient httpclient = this.getClient();
        try {
            HttpDelete httpDelete = new HttpDelete(url);
            if (headers != null) {
                httpDelete.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpDelete);
            httpclient.execute((HttpUriRequest)httpDelete, futureCallback);
        }
        catch (Exception e) {
            this.logger.error("http delete error:" + url, (Throwable)e);
            this.addAlarm("delete", url, e.getMessage());
        }
    }

    public void postFile(String url, String filePath, FutureCallback futureCallback) {
        HashMap<String, Object> fileMap = new HashMap<String, Object>();
        fileMap.put("file", filePath);
        this.postFile(null, url, fileMap, null, futureCallback);
    }

    public void postFile(String url, String name, String filePath, FutureCallback futureCallback) {
        HashMap<String, Object> fileMap = new HashMap<String, Object>();
        fileMap.put(name, filePath);
        this.postFile(null, url, fileMap, null, futureCallback);
    }

    public void postFile(String url, Map<String, Object> fileMap, List<NameValuePair> nvps, FutureCallback futureCallback) {
        this.postFile(null, url, fileMap, nvps, futureCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFile(List<Header> headers, String url, Map<String, Object> fileMap, List<NameValuePair> nvps, FutureCallback futureCallback) {
        this.logger.debug("postFile url:{},fileMap Size:{}\uff0cnvps:{}", (Object)url, (Object)fileMap.size(), (Object)StringUtil.toJson(nvps));
        CloseableHttpAsyncClient httpclient = this.getClient();
        try {
            Object value;
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(1000).setSocketTimeout(600000).build();
            HttpPost httpPost = new HttpPost(url);
            if (headers != null) {
                httpPost.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpPost);
            httpPost.setConfig(requestConfig);
            MultipartEntityBuilder requestBuilder = MultipartEntityBuilder.create().setCharset(this.DEFAULT_CHARSET).setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            if (fileMap != null) {
                for (Map.Entry<String, Object> entry : fileMap.entrySet()) {
                    value = entry.getValue();
                    if (value instanceof File) {
                        this.logger.debug("addBinaryBody file, {}:{}", (Object)entry.getKey(), (Object)((File)entry.getValue()).getAbsolutePath());
                        requestBuilder.addBinaryBody(entry.getKey(), (File)entry.getValue());
                        continue;
                    }
                    if (value instanceof InputStream) {
                        this.logger.debug("addBinaryBody InputStream, {}", (Object)entry.getKey());
                        requestBuilder.addBinaryBody(entry.getKey(), (InputStream)entry.getValue());
                        continue;
                    }
                    if (value instanceof byte[]) {
                        this.logger.debug("addBinaryBody byte[], {}", (Object)entry.getKey());
                        requestBuilder.addBinaryBody(entry.getKey(), (byte[])entry.getValue());
                        continue;
                    }
                    if (!(value instanceof String)) continue;
                    this.logger.debug("addBinaryBody filePath, {}:{}", (Object)entry.getKey(), (Object)((String)entry.getValue()));
                    requestBuilder.addBinaryBody(entry.getKey(), new File((String)entry.getValue()));
                }
            }
            if (nvps != null) {
                for (NameValuePair nvp : nvps) {
                    this.logger.debug("form addPart, {}:{}", (Object)nvp.getName(), (Object)nvp.getValue());
                    value = new StringBody(nvp.getValue(), ContentType.create((String)"text/plain", (Charset)this.DEFAULT_CHARSET));
                    requestBuilder.addPart(nvp.getName(), (ContentBody)value);
                }
            }
            HttpEntity reqEntity = requestBuilder.build();
            httpPost.setEntity(reqEntity);
            httpclient.execute((HttpUriRequest)httpPost, futureCallback);
        }
        catch (Exception e) {
            this.logger.error("http postFile error:" + url, (Throwable)e);
            this.addAlarm("post file", url, e.getMessage());
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                this.logger.error("httpclient close error!", (Throwable)e);
            }
        }
    }

    private void setExtraHeaders(HttpRequestBase httpEntity) {
        if (!this.withExtra) {
            return;
        }
        String requestId = WebContext.getTraceId();
        String at = WebContext.getRequestAt();
        String ht = WebContext.getRequestHt();
        String token = WebContext.getRequestToken();
        String authorization = WebContext.getRequestAuthorization();
        if (!StringUtil.isEmpty(requestId)) {
            httpEntity.setHeader("jsm-trace-id", requestId);
        }
        if (!StringUtil.isEmpty(at)) {
            httpEntity.setHeader("at", at);
        }
        if (!StringUtil.isEmpty(ht)) {
            httpEntity.setHeader("ht", ht);
        }
        if (!StringUtil.isEmpty(token)) {
            httpEntity.setHeader("jsm-token", token);
        }
        if (!StringUtil.isEmpty(authorization)) {
            httpEntity.setHeader(WebContext.JSM_AUTHORIZATION, authorization);
        }
    }

    private CloseableHttpAsyncClient getClient() {
        if (this.closeableHttpAsyncClient == null) {
            this.closeableHttpAsyncClient = this.createClient();
            this.closeableHttpAsyncClient.start();
        }
        if (!this.closeableHttpAsyncClient.isRunning()) {
            try {
                this.closeableHttpAsyncClient.close();
            }
            catch (IOException e) {
                this.logger.error("", (Throwable)e);
            }
            this.closeableHttpAsyncClient = this.createClient();
            this.closeableHttpAsyncClient.start();
        }
        return this.closeableHttpAsyncClient;
    }

    private CloseableHttpAsyncClient createClient() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial((org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            HttpAsyncClientBuilder hcb = HttpAsyncClientBuilder.create();
            if (this.proxyHost != null) {
                hcb.setProxy(this.proxyHost);
            }
            hcb.setSSLContext(sslContext);
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor();
            PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
            cm.setMaxTotal(100);
            hcb.setConnectionManager((NHttpClientConnectionManager)cm);
            return hcb.build();
        }
        catch (Exception e) {
            this.logger.error("create ssl socket factory error!", (Throwable)e);
            return null;
        }
    }
}

