/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.gen;

import cn.ibaijia.jsm.annotation.FieldAnn;
import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.JsmConfigurer;
import cn.ibaijia.jsm.context.dao.model.ApiInfo;
import cn.ibaijia.jsm.context.dao.model.ControllerInfo;
import cn.ibaijia.jsm.context.dao.model.FieldInfo;
import cn.ibaijia.jsm.context.dao.model.Page;
import cn.ibaijia.jsm.context.rest.validate.ValidateModel;
import cn.ibaijia.jsm.context.service.BaseService;
import cn.ibaijia.jsm.utils.ClassUtil;
import cn.ibaijia.jsm.utils.FileUtil;
import cn.ibaijia.jsm.utils.FtlUtil;
import cn.ibaijia.jsm.utils.JsmFrameUtil;
import cn.ibaijia.jsm.utils.JsonUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.XmlUtil;
import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Service
public class GenService
extends BaseService {
    private String modelPackageName;
    private String mapperPackageName;
    private String servicePackageName;
    private String restPackageName;
    private String frontApiDir;

    private void check() {
        if (this.modelPackageName == null) {
            this.modelPackageName = AppContext.get("jsm.gen.package.model");
            this.mapperPackageName = AppContext.get("jsm.gen.package.mapper");
            this.servicePackageName = AppContext.get("jsm.gen.package.service");
            this.restPackageName = AppContext.get("jsm.gen.package.rest");
            this.frontApiDir = AppContext.get("jsm.gen.dir.api");
        }
    }

    public void genAll() {
        List<String> tableNameList = JsmConfigurer.getDbGenerationStrategy().getTables();
        for (String tableName : tableNameList) {
            if ("opt_log_t".equals(tableName)) {
                this.logger.debug("ignore jsm frame table. opt_log_t");
                continue;
            }
            this.gen(tableName, false, true);
        }
    }

    public void gen(String tableName) {
        this.gen(tableName, false, true);
    }

    public void gen(String tableName, boolean override) {
        this.gen(tableName, override, false);
    }

    public void gen(String tableName, boolean override, boolean genApi) {
        this.gen(tableName, override, true, genApi);
    }

    public void gen(String tableName, boolean override, boolean update, boolean genApi) {
        this.check();
        String baseJavaDir = null;
        String mapperXmlDirPath = null;
        try {
            baseJavaDir = new File("").getCanonicalPath() + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
            mapperXmlDirPath = new File("").getCanonicalPath() + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "mappers" + File.separator;
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
        String className = JsmConfigurer.getDbGenerationStrategy().tableNameToModelName(tableName);
        String categoryName = StringUtil.lowerCaseFirst(className);
        String restReqPackageName = this.restPackageName + ".req." + categoryName;
        String restVoPackageName = this.restPackageName + ".vo." + categoryName;
        this.logger.info("baseJavaDir:{}", (Object)baseJavaDir);
        this.logger.info("modelPackageName:{}", (Object)this.modelPackageName);
        this.logger.info("mapperPackageName:{}", (Object)this.mapperPackageName);
        this.logger.info("mapperXmlDirPath:{}", (Object)mapperXmlDirPath);
        this.logger.info("servicePackageName:{}", (Object)this.servicePackageName);
        this.logger.info("restReqPackageName:{}", (Object)restReqPackageName);
        this.logger.info("restVoPackageName:{}", (Object)restVoPackageName);
        String mapperFtl = "mapper.ftl";
        String mapperXmlFtl = "mapperXml.ftl";
        String modelFtl = "model.ftl";
        String serviceFtl = "service.ftl";
        String addReqFtl = "addReq.ftl";
        String updateReqFtl = "updateReq.ftl";
        String pageReqFtl = "pageReq.ftl";
        String voFtl = "vo.ftl";
        String apiFtl = "api.ftl";
        this.logger.info("mapperFtl:{}", (Object)mapperFtl);
        this.logger.info("mapperXmlFtl:{}", (Object)mapperXmlFtl);
        this.logger.info("modelFtl:{}", (Object)modelFtl);
        this.logger.info("serviceFtl:{}", (Object)serviceFtl);
        this.logger.info("addReqFtl:{}", (Object)addReqFtl);
        this.logger.info("updateReqFtl:{}", (Object)updateReqFtl);
        this.logger.info("pageReqFtl:{}", (Object)pageReqFtl);
        this.logger.info("voFtl:{}", (Object)voFtl);
        this.logger.info("apiFtl:{}", (Object)apiFtl);
        String modelDirPath = baseJavaDir + this.modelPackageName.replace(".", File.separator);
        String mapperDirPath = baseJavaDir + this.mapperPackageName.replace(".", File.separator);
        String serviceDirPath = baseJavaDir + this.servicePackageName.replace(".", File.separator);
        String restReqDirPath = baseJavaDir + restReqPackageName.replace(".", File.separator);
        String restVoDirPath = baseJavaDir + restVoPackageName.replace(".", File.separator);
        String restApiDirPath = baseJavaDir + this.restPackageName.replace(".", File.separator);
        this.makDirs(modelDirPath);
        this.makDirs(mapperDirPath);
        this.makDirs(mapperXmlDirPath);
        this.makDirs(serviceDirPath);
        this.makDirs(restReqDirPath);
        this.makDirs(restVoDirPath);
        this.makDirs(restApiDirPath);
        String modelFileName = modelDirPath + File.separator + className + ".java";
        String mapperFileName = mapperDirPath + File.separator + className + "Mapper.java";
        String mapperXmlFileName = mapperXmlDirPath + File.separator + className + "Mapper.xml";
        String serviceFileName = serviceDirPath + File.separator + className + "Service.java";
        String restAddReqFileName = restReqDirPath + File.separator + className + "AddReq.java";
        String restUpdateReqFileName = restReqDirPath + File.separator + className + "UpdateReq.java";
        String restPageReqFileName = restReqDirPath + File.separator + className + "PageReq.java";
        String restVoFileName = restVoDirPath + File.separator + className + "Vo.java";
        String restApiFileName = restApiDirPath + File.separator + className + "Api.java";
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put("modelPackageName", this.modelPackageName);
        datas.put("mapperPackageName", this.mapperPackageName);
        datas.put("servicePackageName", this.servicePackageName);
        datas.put("restReqPackageName", restReqPackageName);
        datas.put("restVoPackageName", restVoPackageName);
        datas.put("restPackageName", this.restPackageName);
        datas.put("tableName", tableName);
        datas.put("className", className);
        datas.put("apiName", StringUtil.camelToKebab(categoryName));
        datas.put("genApi", genApi);
        List<FieldInfo> fieldList = JsmConfigurer.getDbGenerationStrategy().getTableFieldInfo(tableName, datas);
        datas.put("fieldList", fieldList);
        String modelStr = FtlUtil.build(this.getClass(), "/META-INF/ftl/", datas, modelFtl);
        boolean modelRes = this.writeFile(modelStr, modelFileName, override);
        if (!modelRes && update) {
            this.updateModel(modelStr, modelFileName);
        }
        this.logger.info("createModel:{} res:{}", (Object)modelFileName, (Object)modelRes);
        String mapperStr = FtlUtil.build(this.getClass(), "/META-INF/ftl/", datas, mapperFtl);
        boolean mapperRes = this.writeFile(mapperStr, mapperFileName, override);
        this.logger.info("createMapper:{} res:{}", (Object)mapperFileName, (Object)mapperRes);
        if (!modelRes && update) {
            this.updateMapper(mapperStr, mapperFileName);
        }
        this.buildFtlFile(datas, mapperXmlFtl, mapperXmlFileName, override);
        this.buildFtlFile(datas, serviceFtl, serviceFileName, override);
        if (genApi) {
            this.buildFtlFile(datas, addReqFtl, restAddReqFileName, override);
            this.buildFtlFile(datas, updateReqFtl, restUpdateReqFileName, override);
            this.buildFtlFile(datas, pageReqFtl, restPageReqFileName, override);
            this.buildFtlFile(datas, voFtl, restVoFileName, override);
            this.buildFtlFile(datas, apiFtl, restApiFileName, override);
        }
    }

    private boolean buildFtlFile(Map<String, Object> datas, String ftlName, String fileName, boolean override) {
        String str = FtlUtil.build(this.getClass(), "/META-INF/ftl/", datas, ftlName);
        boolean res = this.writeFile(str, fileName, override);
        this.logger.info("create:{} res:{}", (Object)fileName, (Object)res);
        return res;
    }

    private void makDirs(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            this.logger.info("mkdir:{}", (Object)path);
            dir.mkdirs();
        }
    }

    private void updateMapperXml(String mapperXmlFileName) {
        String oldStr = FileUtil.readFileAsText(mapperXmlFileName);
        String addRegex = "(<insert id=\"add\"[\\s\\S]*?</insert>)";
        String addBatchRegex = "(<insert id=\"addBatch\"[\\s\\S]*?</insert>)";
        String updateRegex = "(<update id=\"update\"[\\s\\S]*?</update>)";
        String findByIdRegex = "(<select id=\"findById\"[\\s\\S]*?</select>)";
        String findByIdForUpdateRegex = "(<select id=\"findByIdForUpdate\"[\\s\\S]*?</select>)";
        String deleteByIdRegex = "(<delete id=\"deleteById\"[\\s\\S]*?</delete>)";
        String listAllRegex = "(<select id=\"listAll\"[\\s\\S]*?</select>)";
        oldStr = this.clearOldCode(oldStr, addRegex);
        oldStr = this.clearOldCode(oldStr, addBatchRegex);
        oldStr = this.clearOldCode(oldStr, updateRegex);
        oldStr = this.clearOldCode(oldStr, findByIdRegex);
        oldStr = this.clearOldCode(oldStr, findByIdForUpdateRegex);
        oldStr = this.clearOldCode(oldStr, deleteByIdRegex);
        oldStr = this.clearOldCode(oldStr, listAllRegex);
        boolean res = this.writeFile(oldStr, mapperXmlFileName, true);
        this.logger.info("updateMapperXml:{} res:{}", (Object)mapperXmlFileName, (Object)res);
    }

    private String clearOldCode(String oldStr, String addRegex) {
        String oldAdd = this.findElement(oldStr, addRegex);
        if (oldAdd != null) {
            oldStr = oldStr.replace(oldAdd, "");
        }
        return oldStr;
    }

    private void updateMapper(String mapperStr, String mapperFileName) {
        String oldStr = FileUtil.readFileAsText(mapperFileName);
        String addReplace = "((\\s.*?)@Insert[^;]*?add\\([\\s\\S]*?\\);)";
        String addUpdate = "((\\s.*?)(int.*?)(add\\()(.*?)\\);)";
        String addBatchReplace = "((\\s.*?)@Insert[^;]*?addBatch\\([\\s\\S]*?\\);)";
        String addBatchUpdate = "((\\s.*?)(int.*?)(addBatch\\()(.*?)\\);)";
        String updateReplace = "((\\s.*?)@Update([^;]*?update\\()[\\s\\S]*?\\);)";
        String updateUpdate = "((\\s.*?)(int.*?)(update\\()(.*?)\\);)";
        String findByIdReplace = "((\\s.*?)@Select([^;]*?findById\\()[\\s\\S]*?\\);)";
        String findByIdUpdate = "((\\s.*?)(findById\\()(.*?)\\);)";
        String findByIdForUpdateReplace = "((\\s.*?)@Select([^;]*?findByIdForUpdate\\()[\\s\\S]*?\\);)";
        String findByIdForUpdateUpdate = "((\\s.*?)(findByIdForUpdate\\()(.*?)\\);)";
        String deleteByIdReplace = "((\\s.*?)@Delete([^;]*?deleteById\\()[\\s\\S]*?\\);)";
        String deleteByIdUpdate = "((\\s.*?)(deleteById\\()(.*?)\\);)";
        String listAllReplace = "((\\s.*?)@Select[^;]*?listAll\\([\\s\\S]*?\\);)";
        String listAllUpdate = "((\\s.*?)(listAll\\()(.*?)\\);)";
        String oldPackageName = "org.apache.ibatis.annotations.Param;";
        String newPackageName = "org.apache.ibatis.annotations.*;";
        StringBuilder newSb = new StringBuilder();
        oldStr = this.replaceByRegex(mapperStr, oldStr, addReplace, addUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, addBatchReplace, addBatchUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, updateReplace, updateUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, findByIdReplace, findByIdUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, findByIdForUpdateReplace, findByIdForUpdateUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, deleteByIdReplace, deleteByIdUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, listAllReplace, listAllUpdate, newSb);
        oldStr = oldStr.replace(oldPackageName, newPackageName);
        if (newSb.length() > 0) {
            int idx = oldStr.indexOf("{");
            StringBuilder fileSb = new StringBuilder();
            fileSb.append(oldStr.substring(0, idx + 2));
            fileSb.append("\n\n\t").append((CharSequence)newSb);
            fileSb.append(oldStr.substring(idx + 2));
            oldStr = fileSb.toString();
        }
        boolean res = this.writeFile(oldStr, mapperFileName, true);
        this.logger.info("updateMapper:{} res:{}", (Object)mapperFileName, (Object)res);
    }

    private String replaceByRegex(String mapperStr, String oldStr, String addReplace, String addUpdate, StringBuilder newSb) {
        String addReplaceStrOld = this.findElement(oldStr, addReplace);
        String addReplaceStrNew = this.findElement(mapperStr, addReplace);
        if (addReplaceStrOld == null) {
            String addUpdateStrOld = this.findElement(oldStr, addUpdate);
            if (addUpdateStrOld == null) {
                newSb.append(addReplaceStrNew).append("\n");
            } else {
                oldStr = oldStr.replace(addUpdateStrOld, addReplaceStrNew);
            }
        } else {
            oldStr = oldStr.replace(addReplaceStrOld, addReplaceStrNew);
        }
        return oldStr;
    }

    private String findElement(String content, String regex) {
        return this.findElement(content, regex, 1);
    }

    private String findElement(String content, String regex, int idx) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        while (m.find()) {
            if (idx <= m.groupCount()) {
                return m.group(idx);
            }
            this.logger.error("idx:{} > groupCount:{}", (Object)idx, (Object)m.groupCount());
        }
        return null;
    }

    private List<String> findElements(String content, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        ArrayList<String> list = new ArrayList<String>();
        while (m.find()) {
            list.add(m.group());
        }
        return list;
    }

    private void updateModel(String modelStr, String modelFileName) {
        String oldStr = FileUtil.readFileAsText(modelFileName);
        String newStr = modelStr.substring(modelStr.indexOf("serialVersionUID"));
        String[] fieldArr = newStr.split(";");
        if (fieldArr.length < 1) {
            return;
        }
        StringBuilder newSb = new StringBuilder();
        for (int i = 1; i < fieldArr.length; ++i) {
            String filedDesc;
            String fieldStr = fieldArr[i];
            String[] arr = fieldStr.split("public ");
            if (arr.length != 2 || oldStr.contains(filedDesc = "public " + arr[1])) continue;
            newSb.append(fieldStr).append(";");
        }
        if (newSb.length() > 0) {
            oldStr = oldStr.substring(0, oldStr.lastIndexOf(125));
            oldStr = oldStr + newSb.toString() + "\n}";
            boolean res = this.writeFile(oldStr, modelFileName, true);
            this.logger.info("updateModel:{} res:{}", (Object)modelFileName, (Object)res);
        }
    }

    private boolean writeXmlFile(Document doc, String mapperXmlFileName) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            FileOutputStream output = new FileOutputStream(new File(mapperXmlFileName));
            XMLWriter writer = new XMLWriter((OutputStream)output, format);
            writer.write(doc);
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e) {
            this.logger.error("writeXmlFile error.", (Throwable)e);
            return false;
        }
    }

    private void updateOneElement(Element newRoot, Element oldRoot, String elementName, String attrName, String attrVal) {
        Element newAddElement = XmlUtil.find(newRoot, elementName, attrName, attrVal);
        Element oldAddElement = XmlUtil.find(oldRoot, elementName, attrName, attrVal);
        if (oldAddElement != null) {
            oldRoot.remove(oldAddElement);
            oldRoot.add(newAddElement.createCopy());
        } else {
            oldRoot.add(newAddElement.createCopy());
        }
    }

    public void genApiHtml(Class clazz) {
        this.check();
        ArrayList<ControllerInfo> controllerInfoList = new ArrayList<ControllerInfo>();
        ControllerInfo controllerInfo = new ControllerInfo();
        String name = StringUtil.camelToKebab(clazz.getSimpleName());
        if (name.startsWith("-")) {
            name = name.substring(1);
        }
        controllerInfo.name = name = "/" + name + "/";
        controllerInfo.apiInfos = this.getApiInfoList(clazz);
        controllerInfoList.add(controllerInfo);
        this.genApiHtml(controllerInfoList);
    }

    public void genApiHtml() {
        this.check();
        Set<Class<?>> classSet = ClassUtil.loadClass(this.restPackageName, true);
        ArrayList<ControllerInfo> controllerInfoList = new ArrayList<ControllerInfo>();
        for (Class<?> clazz : classSet) {
            RestController restController = clazz.getAnnotation(RestController.class);
            if (restController == null) continue;
            ControllerInfo controllerInfo = new ControllerInfo();
            String name = StringUtil.camelToKebab(clazz.getSimpleName());
            if (name.startsWith("-")) {
                name = name.substring(1);
            }
            controllerInfo.name = name = "/" + name + "/";
            controllerInfo.apiInfos = this.getApiInfoList(clazz);
            controllerInfoList.add(controllerInfo);
        }
        this.genApiHtml(controllerInfoList);
    }

    private void genApiHtml(List<ControllerInfo> controllerInfoList) {
        String apiHtml = "apiHtml.ftl";
        String apiHtmlPath = "";
        boolean isInSpringBoot = this.checkIsInSpringBoot();
        if (StringUtil.isEmpty(apiHtmlPath)) {
            StringBuilder sb = new StringBuilder();
            try {
                sb.append(new File("").getCanonicalPath()).append(File.separator);
            }
            catch (IOException e) {
                this.logger.error("", (Throwable)e);
            }
            sb.append("src").append(File.separator);
            sb.append("main").append(File.separator);
            if (isInSpringBoot) {
                sb.append("resources").append(File.separator);
            } else {
                sb.append("webapp").append(File.separator);
            }
            sb.append("static").append(File.separator);
            sb.append("api.html");
            apiHtmlPath = sb.toString();
        }
        this.makeDirs(apiHtmlPath.substring(0, apiHtmlPath.lastIndexOf(File.separator)));
        this.logger.info("apiHtmlPath:{}", (Object)apiHtmlPath);
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put("controllerInfoList", controllerInfoList);
        datas.put("controllerInfoJson", JsonUtil.toJsonString(controllerInfoList));
        String modelStr = FtlUtil.build(this.getClass(), "/META-INF/ftl/", datas, apiHtml);
        HtmlCompressor compressor = new HtmlCompressor();
        compressor.setCompressCss(true);
        compressor.setEnabled(true);
        compressor.setCompressCss(true);
        compressor.setYuiJsPreserveAllSemiColons(true);
        compressor.setYuiJsLineBreak(1);
        compressor.setPreserveLineBreaks(false);
        compressor.setRemoveIntertagSpaces(true);
        compressor.setRemoveComments(true);
        compressor.setRemoveMultiSpaces(true);
        modelStr = compressor.compress(modelStr);
        boolean modelRes = this.writeFile(modelStr, apiHtmlPath, true);
        this.logger.info("createApiHtml:{} res:{}", (Object)apiHtmlPath, (Object)modelRes);
    }

    private boolean checkIsInSpringBoot() {
        String className = "cn.ibaijia.jsm.spring.boot.autoconfigure.SpringBootVFS";
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void makeDirs(String dirPath) {
        File file = new File(dirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private String getClazzUri(Class clazz) {
        RequestMapping baseRequestMapping = clazz.getAnnotation(RequestMapping.class);
        if (baseRequestMapping != null && baseRequestMapping.value().length > 0) {
            return baseRequestMapping.value()[0];
        }
        PostMapping postMapping = clazz.getAnnotation(PostMapping.class);
        if (postMapping != null && postMapping.value().length > 0) {
            return postMapping.value()[0];
        }
        PutMapping putMapping = clazz.getAnnotation(PutMapping.class);
        if (putMapping != null && putMapping.value().length > 0) {
            return putMapping.value()[0];
        }
        GetMapping getMapping = clazz.getAnnotation(GetMapping.class);
        if (getMapping != null && getMapping.value().length > 0) {
            return getMapping.value()[0];
        }
        DeleteMapping deleteMapping = clazz.getAnnotation(DeleteMapping.class);
        if (deleteMapping != null && deleteMapping.value().length > 0) {
            return deleteMapping.value()[0];
        }
        return "";
    }

    private String getMethodUri(Method method) {
        RequestMapping baseRequestMapping = method.getAnnotation(RequestMapping.class);
        if (baseRequestMapping != null && baseRequestMapping.value().length > 0) {
            return baseRequestMapping.value()[0];
        }
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        if (postMapping != null && postMapping.value().length > 0) {
            return postMapping.value()[0];
        }
        PutMapping putMapping = method.getAnnotation(PutMapping.class);
        if (putMapping != null && putMapping.value().length > 0) {
            return putMapping.value()[0];
        }
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        if (getMapping != null && getMapping.value().length > 0) {
            return getMapping.value()[0];
        }
        DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
        if (deleteMapping != null && deleteMapping.value().length > 0) {
            return deleteMapping.value()[0];
        }
        return "";
    }

    private String getHttpMethodName(Method method) {
        RequestMapping baseRequestMapping = method.getAnnotation(RequestMapping.class);
        if (baseRequestMapping != null) {
            return baseRequestMapping.method()[0].name().toLowerCase();
        }
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        if (postMapping != null) {
            return "post";
        }
        PutMapping putMapping = method.getAnnotation(PutMapping.class);
        if (putMapping != null) {
            return "put";
        }
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        if (getMapping != null) {
            return "get";
        }
        DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
        if (deleteMapping != null) {
            return "delete";
        }
        return "";
    }

    private List<ApiInfo> getApiInfoList(Class clazz) {
        String basePath = "";
        RestController restController = clazz.getAnnotation(RestController.class);
        if (restController == null) {
            return null;
        }
        basePath = basePath + this.getClazzUri(clazz);
        ArrayList<ApiInfo> apiInfoList = new ArrayList<ApiInfo>();
        Method[] methods = clazz.getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Method method : methods) {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping == null || requestMapping.method().length == 0 || requestMapping.value().length == 0) continue;
            ApiInfo apiInfo = new ApiInfo();
            apiInfo.name = method.getName();
            apiInfo.comments = "";
            apiInfo.httpMethod = this.getHttpMethodName(method);
            apiInfo.url = basePath + this.getMethodUri(method);
            this.logger.info("getApiInfoList clazz:{}, methodName:{},url:{}", new Object[]{clazz.getSimpleName(), apiInfo.name, apiInfo.url});
            ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
            if (apiOperation != null) {
                apiInfo.comments = apiOperation.value() + " notes:" + apiOperation.notes();
            }
            block1: for (Parameter parameter : method.getParameters()) {
                PathVariable pathVariable = parameter.getAnnotation(PathVariable.class);
                if (pathVariable != null) {
                    apiInfo.pathVarList = this.getSingleReqParamFields(parameter, pathVariable.value());
                    continue;
                }
                RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
                if (requestParam != null) {
                    apiInfo.reqParamList = this.getSingleReqParamFields(parameter, requestParam.value());
                    continue;
                }
                RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
                if (requestBody != null) {
                    apiInfo.bodyParamList = JsmFrameUtil.getFieldInfoList(parameter.getType(), null, null, 0, false);
                    continue;
                }
                if (!ValidateModel.class.isAssignableFrom(parameter.getType())) continue;
                apiInfo.reqParamList = JsmFrameUtil.getFieldInfoList(parameter.getType(), JsmFrameUtil.getGenericNames(parameter.getParameterizedType()), null, 0, false);
                if (!Page.class.isAssignableFrom(parameter.getType())) continue;
                for (FieldInfo fieldInfo : apiInfo.reqParamList) {
                    if (!"list".equals(fieldInfo.fieldName)) continue;
                    apiInfo.reqParamList.remove(fieldInfo);
                    continue block1;
                }
            }
            if (!"void".equals(method.getReturnType().getName())) {
                apiInfo.respParamList = JsmFrameUtil.getFieldInfoList(method.getReturnType(), JsmFrameUtil.getGenericNames(method.getGenericReturnType()), null, 0, false);
            }
            apiInfoList.add(apiInfo);
        }
        return apiInfoList;
    }

    private List<FieldInfo> getSingleReqParamFields(Parameter parameter, String annFieldName) {
        ArrayList<FieldInfo> reqParamList = new ArrayList<FieldInfo>();
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.fieldName = parameter.getName();
        fieldInfo.fieldType = parameter.getType().getSimpleName();
        fieldInfo.required = false;
        FieldAnn fieldAnn = parameter.getAnnotation(FieldAnn.class);
        if (fieldAnn != null) {
            if (fieldAnn.maxLen() != -1) {
                fieldInfo.maxLength = fieldAnn.maxLen();
            }
            fieldInfo.required = fieldAnn.required();
            fieldInfo.comments = fieldAnn.comments();
        }
        if (!StringUtil.isEmpty(annFieldName)) {
            fieldInfo.fieldName = annFieldName;
        }
        reqParamList.add(fieldInfo);
        return reqParamList;
    }

    public void genFrontJsApi() {
        this.check();
        Set<Class<?>> classSet = ClassUtil.loadClass(this.restPackageName, false);
        ArrayList<ControllerInfo> controllerInfoList = new ArrayList<ControllerInfo>();
        for (Class<?> clazz : classSet) {
            String name;
            ControllerInfo controllerInfo = new ControllerInfo();
            controllerInfo.name = name = clazz.getSimpleName();
            controllerInfo.apiInfos = this.getApiInfoList(clazz);
            controllerInfoList.add(controllerInfo);
        }
        for (ControllerInfo controllerInfo : controllerInfoList) {
            this.genFrontJsApi(controllerInfo, true);
        }
    }

    public void genFrontJsApi(Class clazz, boolean override) {
        String name;
        this.check();
        ControllerInfo controllerInfo = new ControllerInfo();
        controllerInfo.name = name = clazz.getSimpleName();
        controllerInfo.apiInfos = this.getApiInfoList(clazz);
        this.genFrontJsApi(controllerInfo, true);
    }

    private void genFrontJsApi(ControllerInfo controllerInfo, boolean override) {
        String frontApi = "frontApi.ftl";
        String apiFileName = controllerInfo.name;
        String apiFilePath = this.frontApiDir + File.separator + apiFileName + ".js";
        HashMap<String, List<ApiInfo>> datas = new HashMap<String, List<ApiInfo>>();
        datas.put("methodInfoList", controllerInfo.apiInfos);
        String modelStr = FtlUtil.build(this.getClass(), "/META-INF/ftl/", datas, frontApi);
        boolean modelRes = this.writeFile(modelStr, apiFilePath, override);
        this.logger.info("createModel:{} res:{}", (Object)apiFilePath, (Object)modelRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(String text, String filePath, boolean override) {
        File modelFile = new File(filePath);
        if (!override && modelFile.exists()) {
            this.logger.warn("file:{} exists, ignore! override:{}", (Object)filePath, (Object)override);
            return false;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            fos.write(text.getBytes());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                this.logger.error("", (Throwable)e);
            }
        }
    }
}

