/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.gen;

import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.context.dao.mapper.DbMapper;
import cn.ibaijia.jsm.context.dao.model.CreateTableInfo;
import cn.ibaijia.jsm.context.dao.model.FieldInfo;
import cn.ibaijia.jsm.gen.DbGenerationStrategy;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class DefaultMySqlGenerationStrategy
implements DbGenerationStrategy {
    private static Logger logger = LogUtil.log(DefaultMySqlGenerationStrategy.class);

    @Override
    public List<String> getTables() {
        DbMapper dbMapper = SpringContext.getBean(DbMapper.class);
        return dbMapper.showTables();
    }

    @Override
    public List<FieldInfo> getTableFieldInfo(String tableName, Map<String, Object> contextData) {
        logger.info("getTableFieldInfo:{}", (Object)tableName);
        ArrayList<FieldInfo> list = new ArrayList<FieldInfo>();
        DbMapper dbMapper = SpringContext.getBean(DbMapper.class);
        List<CreateTableInfo> res = dbMapper.showCreateTable(tableName);
        if (res.size() > 0) {
            String createInfo = res.get((int)0).CreateTable;
            logger.info(createInfo);
            createInfo = createInfo.substring(createInfo.indexOf("(") + 2, createInfo.lastIndexOf(")") - 1);
            logger.info(createInfo);
            String[] lineArr = createInfo.split("\\n");
            for (int i = 1; i < lineArr.length; ++i) {
                String[] arr = lineArr[i].trim().replaceAll("\\s+", " ").replace("NOT NULL", "NOT_NULL").split(" ");
                if (!arr[0].startsWith("`")) {
                    logger.warn("ignore line:{}", (Object)lineArr[i]);
                    continue;
                }
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.fieldName = arr[0].replace("`", "");
                fieldInfo.fieldName = this.columnNameToFieldName(fieldInfo.fieldName);
                if (fieldInfo.fieldName.equals("`id`")) {
                    logger.warn("id line ignore:{}", (Object)lineArr[i]);
                    continue;
                }
                fieldInfo.fieldType = this.dbTypeToJavaType(arr[1]);
                if (lineArr[i].contains(" DEFAULT ") && arr.length >= 4) {
                    fieldInfo.defaultVal = arr[3];
                }
                if (lineArr[i].contains(" COMMENT ")) {
                    fieldInfo.comments = lineArr[i].substring(lineArr[i].indexOf("'") + 1);
                    fieldInfo.comments = fieldInfo.comments.substring(0, fieldInfo.comments.length() - 2);
                }
                if (lineArr[i].contains("NOT NULL")) {
                    fieldInfo.required = true;
                }
                if (arr[1].startsWith("varchar(")) {
                    fieldInfo.maxLength = StringUtil.extractInteger(arr[1]);
                }
                if (fieldInfo.fieldType.equals("Date")) {
                    contextData.put("hasDate", true);
                }
                list.add(fieldInfo);
            }
        }
        return list;
    }
}

