/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.gen;

import cn.ibaijia.jsm.context.dao.model.FieldInfo;
import java.util.List;
import java.util.Map;

public interface DbGenerationStrategy {
    public List<String> getTables();

    public List<FieldInfo> getTableFieldInfo(String var1, Map<String, Object> var2);

    default public String dbTypeToJavaType(String dbType) {
        if (dbType.startsWith("bigint")) {
            return "Long";
        }
        if (dbType.startsWith("tinyint")) {
            return "Byte";
        }
        if (dbType.startsWith("smallint")) {
            return "Short";
        }
        if (dbType.startsWith("int") || dbType.startsWith("integer")) {
            return "Integer";
        }
        if (dbType.startsWith("varchar") || dbType.contains("text")) {
            return "String";
        }
        if (dbType.startsWith("bit")) {
            return "Boolean";
        }
        if (dbType.startsWith("float")) {
            return "Float";
        }
        if (dbType.startsWith("double")) {
            return "Double";
        }
        if (dbType.startsWith("date") || dbType.startsWith("timestamp")) {
            return "Date";
        }
        return "byte[]";
    }

    default public String tableNameToModelName(String tableName) {
        String clazzName = tableName.replace("-", "_");
        if (clazzName.endsWith("_t")) {
            clazzName = clazzName.substring(0, clazzName.length() - 2);
        }
        StringBuilder sb = new StringBuilder();
        boolean toUpper = true;
        for (int i = 0; i < clazzName.length(); ++i) {
            char c = clazzName.charAt(i);
            if (c == '_') {
                toUpper = true;
                continue;
            }
            sb.append(toUpper ? Character.toUpperCase(c) : c);
            if (!toUpper) continue;
            toUpper = false;
        }
        return sb.toString();
    }

    default public String columnNameToFieldName(String columnName) {
        return columnName;
    }
}

