/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.excel;

import cn.ibaijia.jsm.context.dao.model.Page;
import cn.ibaijia.jsm.excel.ExcelField;
import cn.ibaijia.jsm.excel.TrimType;
import cn.ibaijia.jsm.utils.BeanUtil;
import cn.ibaijia.jsm.utils.DateUtil;
import cn.ibaijia.jsm.utils.ExceptionUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.NumberUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.ValidateUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static Logger logger = LogUtil.log(ExcelUtil.class);
    public static final String OFFICE_EXCEL_XLS = ".xls";
    public static final String OFFICE_EXCEL_XLSX = ".xlsx";
    public static final String DEFAULT_KEY = "default";
    private static String errorMessage = "\u7b2c%s\u884c\uff0c\u7b2c%s\u5217[%s]";

    public static Workbook getWorkbook(String templatePath) {
        try {
            return ExcelUtil.getWorkbook(new FileInputStream(templatePath));
        }
        catch (FileNotFoundException e) {
            logger.error("getWorkbook error.templatePath:" + templatePath, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveWorkbook(Workbook workbook, String path) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(path);
            workbook.write((OutputStream)outputStream);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error("saveWorkbook error.path:" + path, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (workbook != null) {
                try {
                    try {
                        workbook.close();
                        workbook = null;
                    }
                    catch (IOException e) {
                        logger.error("close workbook error.", (Throwable)e);
                        workbook = null;
                    }
                }
                catch (Throwable throwable) {
                    workbook = null;
                    throw throwable;
                }
            }
            if (outputStream != null) {
                try {
                    try {
                        ((OutputStream)outputStream).close();
                        outputStream = null;
                    }
                    catch (IOException e) {
                        logger.error("close outputStream error.", (Throwable)e);
                        outputStream = null;
                    }
                }
                catch (Throwable throwable) {
                    outputStream = null;
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workbook getWorkbook(InputStream templateIs) {
        XSSFWorkbook workBook = null;
        try {
            XSSFWorkbook xSSFWorkbook = workBook = new XSSFWorkbook(templateIs);
            return xSSFWorkbook;
        }
        catch (Exception e) {
            logger.error("getWorkbook error!", (Throwable)e);
            Workbook workbook = null;
            return workbook;
        }
        finally {
            if (templateIs != null) {
                try {
                    templateIs.close();
                }
                catch (IOException e) {
                    logger.error("getWorkbook close templateIs error!", (Throwable)e);
                }
            }
        }
    }

    public static void setValue(Workbook workbook, String sheetName, int rowIdx, int cellIdx, String value) {
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            logger.error("setValue failed, sheetName {} not exists. ", (Object)sheetName);
        }
        ExcelUtil.setValue(sheet, rowIdx, cellIdx, value);
    }

    public static void setValue(Workbook workbook, int sheetIdx, int rowIdx, int cellIdx, String value) {
        Sheet sheet = workbook.getSheetAt(sheetIdx);
        if (sheet == null) {
            logger.error("setValue failed, sheetIdx {} not exists. ", (Object)sheetIdx);
        }
        ExcelUtil.setValue(sheet, rowIdx, cellIdx, value);
    }

    public static void setValue(Sheet sheet, int rowIdx, int cellIdx, String value) {
        Cell cell;
        Row row = sheet.getRow(rowIdx);
        if (row == null) {
            logger.error("setValue failed, rowIdx {} not exists. ", (Object)rowIdx);
        }
        if ((cell = row.getCell(cellIdx)) == null) {
            logger.error("setValue failed, cellIdx {} not exists. ", (Object)cellIdx);
        }
        CellStyle cellstyle = sheet.getWorkbook().createCellStyle();
        cellstyle.setWrapText(true);
        cell.setCellValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Workbook writeToTemplate(InputStream templateIs, int sheetIdx, int beginRow, List<T> dataList) {
        SXSSFWorkbook workBook = null;
        try {
            workBook = new SXSSFWorkbook(new XSSFWorkbook(templateIs));
            Workbook workbook = ExcelUtil.writeWorkbook((Workbook)workBook, sheetIdx, beginRow, dataList);
            return workbook;
        }
        catch (Exception e) {
            logger.error("writeToTemplate error!", (Throwable)e);
            Workbook workbook = null;
            return workbook;
        }
        finally {
            if (templateIs != null) {
                try {
                    templateIs.close();
                }
                catch (IOException e) {
                    logger.error("writeToTemplate close templateIs error!", (Throwable)e);
                }
            }
        }
    }

    public static <T> Workbook writeToNew(List<T> dataList) {
        SXSSFWorkbook workBook = null;
        try {
            workBook = new SXSSFWorkbook(new XSSFWorkbook());
            if (dataList == null || dataList.isEmpty()) {
                logger.warn("empty dataList!");
                return workBook;
            }
            Sheet sheet = workBook.createSheet();
            Row row = sheet.createRow(0);
            Field[] fieldList = dataList.get(0).getClass().getFields();
            int i = 0;
            Font font = workBook.createFont();
            font.setBold(true);
            CellStyle style = workBook.createCellStyle();
            style.setFont(font);
            for (Field field : fieldList) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(style);
                ExcelField excelField = field.getAnnotation(ExcelField.class);
                if (excelField != null && excelField.ignore()) continue;
                if (excelField == null || StringUtil.isEmpty(excelField.name())) {
                    cell.setCellValue(field.getName());
                } else {
                    cell.setCellValue(excelField.name());
                }
                if (excelField != null && excelField.width() > 0) {
                    sheet.setColumnWidth(i, excelField.width() * 256);
                }
                ++i;
            }
            return ExcelUtil.writeWorkbook((Workbook)workBook, 0, 1, dataList);
        }
        catch (Exception e) {
            logger.error("writeToNew error!", (Throwable)e);
            return null;
        }
    }

    private static <T> Workbook writeWorkbook(Workbook workBook, int sheetIdx, int beginRow, List<T> dataList) {
        Sheet sheet = workBook.getSheetAt(sheetIdx);
        HashMap<String, Integer> fieldMap = new HashMap<String, Integer>();
        HashMap<String, Map<String, String>> replaceMap = new HashMap<String, Map<String, String>>();
        if (beginRow == 1) {
            Row row = sheet.getRow(0);
            for (int i = 0; i < row.getLastCellNum(); ++i) {
                fieldMap.put(row.getCell(i).getStringCellValue(), i);
            }
        }
        CellStyle cellstyle = workBook.createCellStyle();
        cellstyle.setWrapText(true);
        CellStyle numericCellstyle = workBook.createCellStyle();
        for (T data : dataList) {
            Row row = sheet.createRow(beginRow++);
            Field[] fieldList = data.getClass().getFields();
            int j = 0;
            for (Field field : fieldList) {
                ExcelField excelField = field.getAnnotation(ExcelField.class);
                if (excelField == null) {
                    excelField = ExcelUtil.class.getAnnotation(ExcelField.class);
                }
                if (excelField != null && excelField.ignore()) continue;
                Integer idx = (Integer)fieldMap.get(field.getName());
                if (excelField != null && !StringUtil.isEmpty(excelField.name())) {
                    idx = (Integer)fieldMap.get(excelField.name());
                }
                if (idx == null) {
                    idx = j;
                }
                Cell cell = row.createCell(idx.intValue());
                Object val = BeanUtil.getFieldValue(field, data);
                if (val == null) continue;
                if (val instanceof Date) {
                    if (StringUtil.isEmpty(excelField.format())) {
                        cell.setCellValue(DateUtil.format((Date)val, "yyyy-MM-dd"));
                    } else {
                        cell.setCellValue(DateUtil.format((Date)val, excelField.format()));
                    }
                } else {
                    cell.setCellType(excelField.cellType());
                    logger.debug("excelField.name:{} excelField:cellType:{},excelField.format:{}", new Object[]{excelField.name(), excelField.cellType(), excelField.format()});
                    if (excelField.cellType().equals((Object)CellType.NUMERIC)) {
                        logger.debug("numeric val:{}", val);
                        if (val instanceof Float) {
                            Float fVal = (Float)val;
                            if (!StringUtil.isEmpty(excelField.format())) {
                                numericCellstyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)excelField.format()));
                            }
                            cell.setCellValue(StringUtil.toDouble(StringUtil.toString(fVal)).doubleValue());
                            cell.setCellStyle(numericCellstyle);
                        } else if (val instanceof Double) {
                            Double dVal = (Double)val;
                            if (!StringUtil.isEmpty(excelField.format())) {
                                numericCellstyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)excelField.format()));
                            }
                            cell.setCellValue(dVal.doubleValue());
                            cell.setCellStyle(numericCellstyle);
                        } else if (val instanceof Integer) {
                            cell.setCellValue((double)((Integer)val).intValue());
                        } else if (val instanceof Long) {
                            cell.setCellValue((double)((Long)val).longValue());
                        } else if (val instanceof Short) {
                            cell.setCellValue((double)((Short)val).shortValue());
                        } else if (val instanceof Byte) {
                            cell.setCellValue((double)((Byte)val).byteValue());
                        } else {
                            logger.error("unknown numeric type:{}", (Object)val.getClass().getName());
                        }
                    } else {
                        String valStr = val.toString();
                        if (excelField.trimType().equals((Object)TrimType.SPACE)) {
                            valStr = StringUtil.trim(valStr);
                        }
                        if (excelField.trimType().equals((Object)TrimType.CRLF)) {
                            valStr = StringUtil.trimCRLF(valStr);
                        }
                        if (excelField.trimType().equals((Object)TrimType.TAB)) {
                            valStr = StringUtil.trimTab(valStr);
                        }
                        if (excelField.trimType().equals((Object)TrimType.ALL)) {
                            valStr = StringUtil.trimAll(valStr);
                        }
                        if (!StringUtil.isEmpty(excelField.replaceRule()) && excelField.replaceRule().contains("|")) {
                            valStr = ExcelUtil.findReplaceValReverse(replaceMap, excelField.replaceRule(), field.getName(), valStr);
                        }
                        cell.setCellValue(valStr);
                        cell.setCellStyle(cellstyle);
                    }
                }
                if (excelField.height() > 0) {
                    row.setHeightInPoints((float)excelField.height());
                }
                ++j;
            }
        }
        return workBook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void readExcel(MultipartFile multipartFile, int sheetIdx, Class<T> clazz, int beginRow, Page<T> page) {
        if (multipartFile.isEmpty()) {
            return;
        }
        String excelFile = multipartFile.getOriginalFilename().toLowerCase();
        InputStream fis = null;
        HSSFWorkbook workBook = null;
        try {
            fis = multipartFile.getInputStream();
            if (excelFile.toLowerCase().endsWith(OFFICE_EXCEL_XLS)) {
                workBook = new HSSFWorkbook(fis);
            } else if (excelFile.toLowerCase().endsWith(OFFICE_EXCEL_XLSX)) {
                workBook = new XSSFWorkbook(fis);
            } else {
                logger.error("not excel file can't read.");
                return;
            }
            List<T> list = ExcelUtil.readWorkbook((Workbook)workBook, sheetIdx, clazz, beginRow, page);
            page.setList(list);
        }
        catch (Exception e) {
            logger.error("readExcel error! file:" + excelFile, (Throwable)e);
            ExceptionUtil.failed(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error("readXlsx close fis error!", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> readExcel(MultipartFile multipartFile, int sheetIdx, Class<T> clazz, int beginRow) {
        if (multipartFile.isEmpty()) {
            return null;
        }
        String excelFile = multipartFile.getOriginalFilename().toLowerCase();
        InputStream fis = null;
        HSSFWorkbook workBook = null;
        try {
            fis = multipartFile.getInputStream();
            if (excelFile.toLowerCase().endsWith(OFFICE_EXCEL_XLS)) {
                workBook = new HSSFWorkbook(fis);
            } else if (excelFile.toLowerCase().endsWith(OFFICE_EXCEL_XLSX)) {
                workBook = new XSSFWorkbook(fis);
            } else {
                logger.error("not excel file can't read.");
                List<T> list = null;
                return list;
            }
            List<T> list = ExcelUtil.readWorkbook((Workbook)workBook, sheetIdx, clazz, beginRow, null);
            return list;
        }
        catch (Exception e) {
            logger.error("readExcel error! file:" + excelFile, (Throwable)e);
            ExceptionUtil.failed(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error("readXlsx close fis error!", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> readExcel(String excelFile, int sheetIdx, Class<T> clazz, int beginRow) {
        File file = new File(excelFile);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        HSSFWorkbook workBook = null;
        try {
            fis = new FileInputStream(file);
            if (excelFile.toLowerCase().endsWith(OFFICE_EXCEL_XLS)) {
                workBook = new HSSFWorkbook((InputStream)fis);
            } else if (excelFile.toLowerCase().endsWith(OFFICE_EXCEL_XLSX)) {
                workBook = new XSSFWorkbook((InputStream)fis);
            } else {
                logger.error("not excel file can't read.");
                List<T> list = null;
                return list;
            }
            List<T> list = ExcelUtil.readWorkbook((Workbook)workBook, sheetIdx, clazz, beginRow, null);
            return list;
        }
        catch (Exception e) {
            logger.error("readExcel error! file:" + excelFile, (Throwable)e);
            ExceptionUtil.failed(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error("readExcel close fis error!", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Page<T> readExcel(String excelFile, int sheetIdx, Class<T> clazz, int beginRow, Page<T> page) {
        File file = new File(excelFile);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        HSSFWorkbook workBook = null;
        try {
            fis = new FileInputStream(file);
            if (excelFile.toLowerCase().endsWith(OFFICE_EXCEL_XLS)) {
                workBook = new HSSFWorkbook((InputStream)fis);
            } else if (excelFile.toLowerCase().endsWith(OFFICE_EXCEL_XLSX)) {
                workBook = new XSSFWorkbook((InputStream)fis);
            } else {
                logger.error("not excel file can't read.");
                Page<T> page2 = null;
                return page2;
            }
            List<T> list = ExcelUtil.readWorkbook((Workbook)workBook, sheetIdx, clazz, beginRow, page);
            page.setList(list);
            Page<T> page3 = page;
            return page3;
        }
        catch (Exception e) {
            logger.error("readExcel error! file:" + excelFile, (Throwable)e);
            ExceptionUtil.failed(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error("readExcel close fis error!", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> readWorkbook(Workbook workBook, int sheetIdx, Class<T> clazz, int beginRow, Page<T> page) {
        ArrayList<T> resultList = new ArrayList<T>();
        HashMap<String, Map<String, String>> replaceMap = new HashMap<String, Map<String, String>>();
        try {
            Sheet sheet = workBook.getSheetAt(sheetIdx);
            logger.info("read sheetIdx:{},row number:{}", (Object)sheetIdx, (Object)sheet.getLastRowNum());
            HashMap<String, Integer> fieldMap = new HashMap<String, Integer>();
            if (beginRow == 1) {
                Row row = sheet.getRow(0);
                for (int i = 0; i < row.getLastCellNum(); ++i) {
                    fieldMap.put(row.getCell(i).getStringCellValue(), i);
                }
            }
            int totalRow = sheet.getLastRowNum() + 1;
            int startIdx = beginRow;
            int endIdx = totalRow;
            if (page != null) {
                page.setTotalCount(totalRow - beginRow);
                startIdx = beginRow + page.getBeginIndex();
                endIdx = startIdx + page.getPageSize();
                if (endIdx > totalRow) {
                    endIdx = totalRow;
                }
                if (startIdx > totalRow) {
                    List<T> list = null;
                    return list;
                }
            }
            HashMap<Integer, String> formatMap = new HashMap<Integer, String>();
            for (int i = startIdx; i < endIdx; ++i) {
                List<String> strList;
                Integer valIdx;
                ExcelField excelField;
                String excelFieldName;
                T obj = clazz.newInstance();
                Field[] orgFields = obj.getClass().getFields();
                if (i == startIdx) {
                    int idx = 0;
                    for (Field field : orgFields) {
                        fieldMap.put(field.getName(), idx++);
                    }
                    for (Field field : orgFields) {
                        excelFieldName = null;
                        excelField = field.getAnnotation(ExcelField.class);
                        if (excelField != null) {
                            if (excelField.ignore()) continue;
                            excelFieldName = excelField.name();
                        }
                        if (StringUtil.isEmpty(excelFieldName)) {
                            excelFieldName = field.getName();
                        }
                        valIdx = (Integer)fieldMap.get(excelFieldName);
                        formatMap.put(valIdx, excelField.format());
                    }
                }
                if (ExcelUtil.isEmptyRow(strList = ExcelUtil.readRowAsList(sheet.getRow(i), 0, formatMap))) {
                    break;
                }
                for (Field field : orgFields) {
                    excelFieldName = null;
                    excelField = field.getAnnotation(ExcelField.class);
                    if (excelField != null) {
                        if (excelField.ignore()) continue;
                        excelFieldName = excelField.name();
                    }
                    if (StringUtil.isEmpty(excelFieldName)) {
                        excelFieldName = field.getName();
                    }
                    if ((valIdx = (Integer)fieldMap.get(excelFieldName)) == null || valIdx >= strList.size()) continue;
                    String val = strList.get(valIdx);
                    if (excelField != null && !StringUtil.isEmpty(excelField.replaceRule()) && excelField.replaceRule().contains("|")) {
                        val = ExcelUtil.findReplaceVal(replaceMap, excelField.replaceRule(), excelFieldName, val);
                    }
                    if (StringUtil.isEmpty(val)) continue;
                    BeanUtil.setFieldValue(obj, field, val);
                }
                String errorMsg = ValidateUtil.validate(obj);
                if (!StringUtil.isEmpty(errorMsg)) {
                    String[] errorArr = errorMsg.split(",");
                    int fieldIdx = (Integer)fieldMap.get(errorArr[0]);
                    String msg = String.format(errorMessage, i + 1, fieldIdx + 1, errorMsg);
                    ExceptionUtil.failed(msg);
                }
                resultList.add(obj);
            }
        }
        catch (Exception e) {
            logger.error("readWorkbook error!", (Throwable)e);
            ExceptionUtil.failed(e.getMessage());
        }
        finally {
            if (workBook != null) {
                try {
                    workBook.close();
                }
                catch (IOException e) {
                    logger.error("readWorkbook close workBook error!", (Throwable)e);
                }
            }
        }
        return resultList;
    }

    private static String findReplaceVal(Map<String, Map<String, String>> replaceMap, String replaceRule, String excelFieldName, String val) {
        String replaceVal;
        if (!replaceMap.containsKey(excelFieldName)) {
            String[] ruleArr;
            HashMap<String, String> map = new HashMap<String, String>();
            for (String rule : ruleArr = replaceRule.split(";")) {
                String[] arr = rule.split("\\|");
                if (arr.length > 1) {
                    map.put(arr[0], arr[1]);
                    continue;
                }
                map.put(arr[0], null);
            }
            replaceMap.put(excelFieldName, map);
        }
        if ((replaceVal = replaceMap.get(excelFieldName).get(val)) == null && replaceMap.get(excelFieldName).containsKey(DEFAULT_KEY)) {
            replaceVal = replaceMap.get(excelFieldName).get(DEFAULT_KEY);
        }
        return replaceVal == null ? val : replaceVal;
    }

    private static String findReplaceValReverse(Map<String, Map<String, String>> replaceMap, String replaceRule, String excelFieldName, String val) {
        String replaceVal;
        if (!replaceMap.containsKey(excelFieldName)) {
            String[] ruleArr;
            HashMap<String, String> map = new HashMap<String, String>();
            for (String rule : ruleArr = replaceRule.split(";")) {
                String[] arr = rule.split("\\|");
                if (arr.length <= 1) continue;
                map.put(arr[1], arr[0]);
            }
            replaceMap.put(excelFieldName, map);
        }
        return (replaceVal = replaceMap.get(excelFieldName).get(val)) == null ? val : replaceVal;
    }

    private static boolean isEmptyRow(List<String> strList) {
        if (strList == null) {
            return true;
        }
        for (String str : strList) {
            if (StringUtil.isEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static List<String> readRowAsList(Row row, int beginIdx, Map<Integer, String> formatMap) {
        if (row == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = beginIdx; i < row.getLastCellNum(); ++i) {
            list.add(ExcelUtil.getCellValue(row.getCell(i), formatMap.get(i)));
        }
        return list;
    }

    public static String getCellValue(Cell cell, String pattern) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == 1) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == 4) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == 0 || cell.getCellType() == 2) {
            if (StringUtil.isEmpty(pattern)) {
                pattern = "0";
            }
            Double value = null;
            try {
                value = cell.getNumericCellValue();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            return NumberUtil.formatString(value, pattern);
        }
        return cell.toString();
    }

    public static List<CellRangeAddress> getCombineCell(Sheet sheet) {
        ArrayList<CellRangeAddress> list = new ArrayList<CellRangeAddress>();
        int sheetmergerCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetmergerCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            list.add(ca);
        }
        return list;
    }

    public static String isCombineCell(List<CellRangeAddress> listCombineCell, Cell cell, Sheet sheet) {
        int firstC = 0;
        int lastC = 0;
        int firstR = 0;
        int lastR = 0;
        String cellValue = null;
        for (CellRangeAddress ca : listCombineCell) {
            firstC = ca.getFirstColumn();
            lastC = ca.getLastColumn();
            firstR = ca.getFirstRow();
            lastR = ca.getLastRow();
            if (cell.getRowIndex() >= firstR && cell.getRowIndex() <= lastR) {
                if (cell.getColumnIndex() < firstC || cell.getColumnIndex() > lastC) continue;
                Row fRow = sheet.getRow(firstR);
                Cell fCell = fRow.getCell(firstC);
                cellValue = ExcelUtil.getCellValue(fCell, null);
                break;
            }
            cellValue = "";
        }
        return cellValue;
    }

    public static String getMergedRegionValue(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return ExcelUtil.getCellValue(fCell, null);
        }
        return null;
    }

    public static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            return true;
        }
        return false;
    }
}

