/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.context.session;

import cn.ibaijia.jsm.cache.jedis.JedisService;
import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.context.session.SessionUser;
import cn.ibaijia.jsm.utils.JsonUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static Logger logger = LoggerFactory.getLogger(Session.class);
    private String token;
    private String sessionKey;
    private JedisService jedisService;
    private SessionUser sessionUser;
    private HttpSession session;
    private boolean invalid = false;
    public static final String SESSION_PREFIX = "jsm:session:";
    private static final String SESSION_USER_ATTR_KEY = "jsm:sessionUser";
    private static final String USER_TOKEN_PREFIX = "jsm:user:token:";
    private static Map<String, HttpSession> loginSession = new HashMap<String, HttpSession>();

    public static Session create(String token) {
        Session session = new Session(token);
        session.set(SESSION_PREFIX, token);
        session.live();
        return session;
    }

    public Session(String token) {
        this.token = token;
        this.sessionKey = SESSION_PREFIX + token;
        if (AppContext.isJedisSession()) {
            this.jedisService = SpringContext.getBean(JedisService.class);
        } else {
            this.session = WebContext.getRequest().getSession();
        }
    }

    public void set(String key, String value) {
        if (AppContext.isJedisSession()) {
            this.jedisService.hset(this.sessionKey, key, value);
        } else {
            this.session.setAttribute(key, (Object)value);
        }
    }

    public Object get(String key) {
        if (AppContext.isJedisSession()) {
            return this.jedisService.hget(this.sessionKey, key);
        }
        return this.session.getAttribute(key);
    }

    public void del(String key) {
        if (AppContext.isJedisSession()) {
            this.jedisService.hdel(this.sessionKey, key);
        } else {
            this.session.removeAttribute(key);
        }
    }

    public void live() {
        logger.debug("live check!");
        if (AppContext.isJedisSession() && !this.invalid) {
            logger.debug("live");
            int liveTime = AppContext.getSessionExpireTime();
            this.jedisService.expire(this.sessionKey, liveTime);
            if (this.sessionUser != null) {
                String userTokenKey = USER_TOKEN_PREFIX + this.sessionUser.getUid();
                this.jedisService.expire(userTokenKey, liveTime);
            }
        }
    }

    public String getToken() {
        return this.token;
    }

    public SessionUser getSessionUser() {
        if (this.sessionUser == null) {
            if (AppContext.isJedisSession()) {
                String str = (String)this.get(SESSION_USER_ATTR_KEY);
                if (!StringUtil.isEmpty(str)) {
                    this.sessionUser = JsonUtil.parseObject(str, SessionUser.class);
                }
            } else {
                this.sessionUser = (SessionUser)this.session.getAttribute(SESSION_USER_ATTR_KEY);
            }
        }
        return this.sessionUser;
    }

    public void setSessionUser(SessionUser sessionUser) {
        this.sessionUser = sessionUser;
        if (AppContext.isJedisSession()) {
            this.set(SESSION_USER_ATTR_KEY, StringUtil.toJson(sessionUser));
            String userTokenKey = USER_TOKEN_PREFIX + this.sessionUser.getUid();
            this.jedisService.set(userTokenKey, this.token);
            logger.debug("setSessionUser key:{} , token:{}", (Object)userTokenKey, (Object)this.token);
            this.live();
        } else {
            this.session.setAttribute(SESSION_USER_ATTR_KEY, (Object)sessionUser);
            loginSession.put(sessionUser.getUid(), this.session);
        }
    }

    public boolean isExpire() {
        if (this.invalid) {
            return true;
        }
        if (AppContext.isJedisSession()) {
            return this.jedisService.exists(this.sessionKey) == false;
        }
        if (this.session != null) {
            return this.session == null;
        }
        return false;
    }

    public void flush() {
        if (!this.invalid) {
            this.setSessionUser(this.sessionUser);
        }
    }

    public void invalidate() {
        logger.debug("session invalidate.");
        this.invalid = true;
        if (AppContext.isJedisSession()) {
            if (this.getSessionUser() != null) {
                String userTokenKey = USER_TOKEN_PREFIX + this.getSessionUser().getUid();
                this.jedisService.del(userTokenKey);
                logger.debug("invalidate key:{}", (Object)userTokenKey);
            }
            this.jedisService.del(this.sessionKey);
            logger.debug("invalidate token:{}", (Object)this.token);
        } else {
            if (this.session != null) {
                this.session.invalidate();
            }
            if (this.sessionUser != null) {
                loginSession.remove(this.sessionUser.getUid());
            }
        }
    }

    public static boolean expire(String uid) {
        if (AppContext.isJedisSession()) {
            JedisService jedisService = SpringContext.getBean(JedisService.class);
            String userTokenKey = USER_TOKEN_PREFIX + uid;
            String token = jedisService.get(userTokenKey);
            jedisService.del(userTokenKey);
            if (!StringUtil.isEmpty(token)) {
                jedisService.del(token);
            }
            logger.debug("expire userTokenKey:{} , token:{}", (Object)userTokenKey, (Object)token);
        } else {
            HttpSession session = loginSession.get(uid);
            if (session != null) {
                session.invalidate();
            }
            loginSession.remove(uid);
        }
        return true;
    }

    public static boolean isLogon(String uid) {
        if (AppContext.isJedisSession()) {
            JedisService jedisService = SpringContext.getBean(JedisService.class);
            String userTokenKey = USER_TOKEN_PREFIX + uid;
            boolean res = jedisService.exists(userTokenKey);
            logger.debug("uid:{}, isLogon:{}", (Object)uid, (Object)res);
            return res;
        }
        return loginSession.get(uid) != null;
    }
}

