/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.context.service;

import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.context.service.JsmSecurityService;
import cn.ibaijia.jsm.utils.LogUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class WebJsmSecurityService
implements JsmSecurityService {
    private Logger logger = LogUtil.log(this.getClass());

    @Override
    public boolean hasRole(String role) {
        List<String> roleList = WebContext.currentRoles();
        if (roleList == null) {
            this.logger.error("user have no roleId!");
            return false;
        }
        boolean resList = false;
        String elsStr = null;
        try {
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("list", roleList);
            elsStr = this.createExpression(role);
            resList = (Boolean)parser.parseExpression(elsStr).getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception e) {
            this.logger.error("role {},elsStr {} ", (Object)role, elsStr);
        }
        return resList;
    }

    @Override
    public boolean hasAnyRole(List<String> roleIdList) {
        for (String roleId : roleIdList) {
            if (!this.hasRole(roleId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPermission(String permissionCode) {
        List<String> permissionList = WebContext.currentPermissions();
        if (permissionList == null) {
            this.logger.error("user have no permission!");
            return false;
        }
        if (permissionList.contains("SUPER_ADMIN")) {
            return true;
        }
        boolean resList = false;
        String elsStr = null;
        try {
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("list", permissionList);
            elsStr = this.createExpression(permissionCode);
            resList = (Boolean)parser.parseExpression(elsStr).getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception e) {
            this.logger.error("permissionCode {},elsStr {} ", (Object)permissionCode, elsStr);
        }
        return resList;
    }

    @Override
    public boolean hasAnyPermission(List<String> permissionCodeList) {
        for (String permissionCode : permissionCodeList) {
            if (!this.hasPermission(permissionCode)) continue;
            return true;
        }
        return false;
    }

    private String createExpression(String permission) {
        String pattern = "([0-9a-zA-Z_-]+)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(permission);
        String s = m.replaceAll("#list?.contains('$1')");
        return s;
    }
}

