/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.context.rest.order;

import cn.ibaijia.jsm.annotation.OrderAnn;
import cn.ibaijia.jsm.cache.jedis.JedisService;
import cn.ibaijia.jsm.cache.jedis.ShardedJedisCmd;
import cn.ibaijia.jsm.consts.BasePairConstants;
import cn.ibaijia.jsm.consts.Pair;
import cn.ibaijia.jsm.context.rest.order.BaseOrderLine;
import cn.ibaijia.jsm.utils.TemplateUtil;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import redis.clients.jedis.ShardedJedis;

public class FairLineService
extends BaseOrderLine {
    @Resource
    private JedisService jedisService;
    private AtomicLong seed = new AtomicLong();

    @Override
    public Pair<String> order(final String key, OrderAnn orderAnn) {
        if (this.getStatus().equals(BasePairConstants.ACTIVITY_NOT_STARTED) || this.getStatus().equals(BasePairConstants.ACTIVITY_OVER)) {
            return this.getStatus();
        }
        final String member = TemplateUtil.formatWithContextVar(orderAnn.userKey());
        Long idx = this.jedisService.exec(new ShardedJedisCmd<Long>(){

            @Override
            public Long run(ShardedJedis shardedJedis) throws Exception {
                Long idx = shardedJedis.zrank(key, member);
                if (idx == null) {
                    shardedJedis.zadd(key, (double)FairLineService.this.seed.incrementAndGet(), member);
                } else {
                    shardedJedis.zincrby(key, -1.0, member);
                }
                return shardedJedis.zrank(key, member);
            }
        });
        if (idx == 0L) {
            return BasePairConstants.ACTIVITY_TURN;
        }
        return BasePairConstants.ACTIVITY_QUEUEING;
    }
}

