/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.context.rest;

import cn.ibaijia.jsm.consts.Pair;
import cn.ibaijia.jsm.context.interceptor.MyDateEditor;
import cn.ibaijia.jsm.context.rest.resp.RestResp;
import cn.ibaijia.jsm.utils.ExceptionUtil;
import cn.ibaijia.jsm.utils.JsmFrameUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import java.beans.PropertyEditor;
import java.util.Date;
import org.slf4j.Logger;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

@RestController
public abstract class BaseRest {
    protected Logger logger = LogUtil.log(this.getClass());

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new MyDateEditor());
    }

    @ExceptionHandler(value={Exception.class})
    public RestResp globalExceptionHandler(Exception e) {
        this.logger.error("globalExceptionHandler error.", (Throwable)e);
        return JsmFrameUtil.dealException(e);
    }

    protected void failed(String errorMsg) {
        ExceptionUtil.failed(errorMsg);
    }

    protected void failed(Pair errorPair) {
        ExceptionUtil.failed(errorPair);
    }

    protected void failed(Pair errorPair, String errorMsg) {
        ExceptionUtil.failed(errorPair, errorMsg);
    }

    protected void notFound(String errorMsg) {
        ExceptionUtil.notFound(errorMsg);
    }

    protected void notFound(Pair errorPair) {
        ExceptionUtil.notFound(errorPair);
    }

    protected void notFound(Pair errorPair, String errorMsg) {
        ExceptionUtil.notFound(errorPair, errorMsg);
    }

    protected <T> RestResp<T> success(T result) {
        return this.success(result, "1001", "success");
    }

    protected <T> RestResp<T> success(T result, String code) {
        return this.success(result, code, "success");
    }

    protected <T> RestResp<T> success(T result, String code, String message) {
        RestResp resp = new RestResp();
        resp.result = result;
        resp.code = code;
        resp.message = message;
        return resp;
    }
}

