/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.context.listener;

import cn.ibaijia.jsm.cache.CacheService;
import cn.ibaijia.jsm.context.JsmConfigurer;
import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.context.job.ScheduleTaskService;
import cn.ibaijia.jsm.stat.JsmSysStatService;
import cn.ibaijia.jsm.utils.LogUtil;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class JsmServletContextListener
implements ServletContextListener {
    private static Logger logger = LogUtil.log(JsmServletContextListener.class);

    public void contextDestroyed(ServletContextEvent sce) {
        ScheduleTaskService scheduleTaskService;
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext());
        JsmConfigurer.getJsmAppListenerService().close(sce);
        CacheService cacheService = SpringContext.getBean(CacheService.class);
        if (cacheService != null) {
            cacheService.close();
        }
        if ((scheduleTaskService = SpringContext.getBean(ScheduleTaskService.class, wac)) != null) {
            scheduleTaskService.destroy();
        }
        logger.info("app close complete!");
    }

    public void contextInitialized(ServletContextEvent sce) {
        CacheService cacheService;
        JsmSysStatService jsmSysStatService;
        WebContext.setContextPath(sce.getServletContext().getContextPath());
        WebContext.setRealPath(sce.getServletContext().getRealPath("/"));
        System.setProperty("file.encoding", "utf-8");
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext());
        JsmConfigurer.getJsmAppListenerService().init(sce);
        ScheduleTaskService scheduleTaskService = SpringContext.getBean(ScheduleTaskService.class, wac);
        if (scheduleTaskService != null) {
            logger.info("scheduleTaskService.loadTasks... \u52a8\u6001job\u4e0d\u652f\u6301 @ClusterJobLockAnn,\u8bf7job\u81ea\u884c\u89e3\u51b3\u96c6\u7fa4\u73af\u5883\u4e2d\u7684\u95ee\u9898");
            scheduleTaskService.loadTasks();
        }
        if ((jsmSysStatService = SpringContext.getBean(JsmSysStatService.class, wac)) != null) {
            jsmSysStatService.start();
        }
        if ((cacheService = SpringContext.getBean(CacheService.class, wac)) != null) {
            cacheService.init();
        }
        logger.info("jsm-frame init complete!");
    }
}

