/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.context.interceptor;

import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.context.rest.resp.RestResp;
import cn.ibaijia.jsm.stat.JsmApiStatService;
import cn.ibaijia.jsm.stat.model.ApiStat;
import cn.ibaijia.jsm.utils.DateUtil;
import cn.ibaijia.jsm.utils.JsmFrameUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.ResponseUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.ThreadLocalUtil;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.filter.OncePerRequestFilter;

public class JsmFilter
extends OncePerRequestFilter {
    private Logger logger = LogUtil.log(((Object)((Object)this)).getClass());
    private String encoding = "UTF-8";
    private String[] excludeArr = null;
    private boolean cors = AppContext.getAsBoolean("jsm.cors.open", false);
    private String corsAllowOrigin = AppContext.get("jsm.cors.allowOrigin", "*");
    private String corsAllowMethods = AppContext.get("jsm.cors.allowMethods", "POST, GET, OPTIONS, DELETE, HEAD");
    private String corsAllowHeaders = AppContext.get("jsm.cors.allowHeaders", "DNT,X-Mx-ReqToken,Keep-Alive,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,access-control-allow-origin,Authorization,access_token,at,ht");
    private String corsAllowCredentials = AppContext.get("jsm.cors.allowCredentials", "true");
    private String corsMaxAge = AppContext.get("jsm.cors.maxAge", "3600");

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        String exclude = this.getFilterConfig().getInitParameter("exclude");
        if (!StringUtil.isEmpty(exclude)) {
            this.excludeArr = exclude.split(";");
        }
    }

    private boolean isExclude(HttpServletRequest request) {
        if (this.excludeArr != null) {
            String servletPath = request.getServletPath();
            for (String pattern : this.excludeArr) {
                if (!servletPath.startsWith(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain fc) {
        String traceId = WebContext.getTraceId();
        if (this.isExclude(request)) {
            try {
                fc.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
            }
            return;
        }
        WebContext.setRequest(request);
        WebContext.setResponse(response);
        String reqMethod = request.getMethod();
        long pid = Thread.currentThread().getId();
        String uri = String.format("%s;%s;%s", pid, reqMethod, request.getRequestURI());
        this.logger.info(uri);
        long startTime = System.currentTimeMillis();
        response.setCharacterEncoding(this.encoding);
        try {
            if (reqMethod.equals(RequestMethod.OPTIONS.name())) {
                String error = "request method not support.";
                this.logger.warn("request method not support {}", (Object)reqMethod);
                throw new RuntimeException(error);
            }
            this.logger.debug("before fc.doFilter");
            fc.doFilter((ServletRequest)request, (ServletResponse)response);
            this.logger.debug("after fc.doFilter");
        }
        catch (Exception e) {
            String error = "request error url:" + request.getRequestURL().toString();
            this.logger.error(error, (Throwable)e);
            RestResp errorResp = JsmFrameUtil.dealException(e);
            ResponseUtil.outputRestResp(response, errorResp);
        }
        finally {
            this.statApi(request, response, reqMethod, startTime, traceId);
            ThreadLocalUtil.cleanAll();
            WebContext.clearTraceId();
            if (this.cors) {
                response.setHeader("Access-Control-Allow-Origin", this.corsAllowOrigin);
                response.setHeader("Access-Control-Allow-Methods", this.corsAllowMethods);
                response.setHeader("Access-Control-Allow-Headers", this.corsAllowHeaders);
                response.setHeader("Access-Control-Allow-Credentials", this.corsAllowCredentials);
                response.setHeader("Access-Control-Max-Age", this.corsMaxAge);
            }
        }
    }

    private void statApi(HttpServletRequest request, HttpServletResponse response, String reqMethod, long startTime, String traceId) {
        JsmApiStatService apiStatService = SpringContext.getBean(JsmApiStatService.class);
        long endTime = System.currentTimeMillis();
        long spendTime = endTime - startTime;
        ApiStat apiStat = new ApiStat();
        apiStat.traceId = traceId;
        apiStat.url = reqMethod + " " + request.getRequestURI();
        apiStat.beginTime = startTime;
        apiStat.endTime = endTime;
        apiStat.spendTime = spendTime;
        apiStat.httpStatus = response.getStatus();
        apiStat.respCode = (String)request.getAttribute("jsm-resp-code");
        apiStat.time = DateUtil.currentTime();
        apiStatService.add(apiStat);
    }
}

