/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.context.dao.model;

import cn.ibaijia.jsm.annotation.FieldAnn;
import cn.ibaijia.jsm.annotation.FieldType;
import cn.ibaijia.jsm.context.rest.validate.ValidateModel;
import cn.ibaijia.jsm.utils.DateUtil;
import cn.ibaijia.jsm.utils.EncryptUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;

public class Page<T>
implements ValidateModel {
    private static Logger logger = LogUtil.log(Page.class);
    @ApiParam(hidden=true)
    @FieldAnn(required=false, comments="\u5f53\u524d\u9875\u6570\u636e\u5217\u8868")
    public List<T> list;
    @FieldAnn(required=true, type=FieldType.NUMBER, comments="\u5f53\u524d\u9875\u6570")
    public int pageNo = 1;
    @FieldAnn(required=true, type=FieldType.NUMBER, comments="\u6bcf\u9875\u6761\u6570")
    public int pageSize = 15;
    @ApiParam(hidden=true)
    @FieldAnn(required=false, comments="\u603b\u6761\u6570")
    public long totalCount = 0L;
    @FieldAnn(required=false, comments="\u67e5\u8be2\u6761\u4ef6")
    public String queryString = "";
    @ApiParam(hidden=true)
    @JsonIgnore
    private Map<String, Object> queryMap;
    @ApiParam(hidden=true)
    @JsonIgnore
    private String dbDialect = null;

    public Page() {
    }

    public Page(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void convertParamToInteger(String key) {
        Object val = this.getQueryMap().get(key);
        if (val != null && !(val instanceof Integer)) {
            this.getQueryMap().put(key, StringUtil.toInteger(val.toString()));
        }
    }

    public void convertParamToLong(String key) {
        Object val = this.getQueryMap().get(key);
        if (val != null && !(val instanceof Long)) {
            this.getQueryMap().put(key, StringUtil.toLong(val.toString()));
        }
    }

    public void convertParamToFloat(String key) {
        Object val = this.getQueryMap().get(key);
        if (val != null && !(val instanceof Float)) {
            this.getQueryMap().put(key, StringUtil.toFloat(val.toString()));
        }
    }

    public void convertParamToDouble(String key) {
        Object val = this.getQueryMap().get(key);
        if (val != null && !(val instanceof Double)) {
            this.getQueryMap().put(key, StringUtil.toDouble(val.toString()));
        }
    }

    public void convertParamToDate(String key) {
        Object val = this.getQueryMap().get(key);
        if (val != null && !(val instanceof Date)) {
            this.getQueryMap().put(key, DateUtil.parse(val.toString()));
        }
    }

    public void convertParamToDateOfBegin(String key) {
        Object val = this.getQueryMap().get(key);
        if (val != null && !(val instanceof Date)) {
            Date date = DateUtil.parse(val.toString());
            this.getQueryMap().put(key, DateUtil.dayOfBegin(date));
        }
    }

    public void convertParamToDateOfEnd(String key) {
        Object val = this.getQueryMap().get(key);
        if (val != null && !(val instanceof Date)) {
            Date date = DateUtil.parse(val.toString());
            this.getQueryMap().put(key, DateUtil.dayOfEnd(date));
        }
    }

    public void convertParamToDate(String key, String pattern) {
        Object val = this.getQueryMap().get(key);
        if (val != null && !(val instanceof Date)) {
            this.getQueryMap().put(key, DateUtil.parse(val.toString(), pattern));
        }
    }

    public void convertParamToDateOfBegin(String key, String pattern) {
        Object val = this.getQueryMap().get(key);
        if (val != null && !(val instanceof Date)) {
            Date date = DateUtil.parse(val.toString(), pattern);
            this.getQueryMap().put(key, DateUtil.dayOfBegin(date));
        }
    }

    public void convertParamToDateOfEnd(String key, String pattern) {
        Object val = this.getQueryMap().get(key);
        if (val != null && !(val instanceof Date)) {
            Date date = DateUtil.parse(val.toString(), pattern);
            this.getQueryMap().put(key, DateUtil.dayOfEnd(date));
        }
    }

    public void setParam(String key, Object value) {
        this.getQueryMap().put(key, value);
    }

    public String getParamAsString(String key) {
        return (String)this.getQueryMap().get(key);
    }

    public Integer getParamAsInteger(String key) {
        this.convertParamToInteger(key);
        return (Integer)this.getQueryMap().get(key);
    }

    public Long getParamAsLong(String key) {
        this.convertParamToLong(key);
        return (Long)this.getQueryMap().get(key);
    }

    public Float getParamAsFloat(String key) {
        this.convertParamToFloat(key);
        return (Float)this.getQueryMap().get(key);
    }

    public Date getParamAsDate(String key) {
        this.convertParamToDate(key);
        return (Date)this.getQueryMap().get(key);
    }

    public Date getParamAsDateOfBegin(String key) {
        this.convertParamToDateOfBegin(key);
        return (Date)this.getQueryMap().get(key);
    }

    public Date getParamAsDateOfEnd(String key) {
        this.convertParamToDateOfEnd(key);
        return (Date)this.getQueryMap().get(key);
    }

    public Date getParamAsDate(String key, String pattern) {
        this.convertParamToDate(key, pattern);
        return (Date)this.getQueryMap().get(key);
    }

    public Date getParamAsDateOfBegin(String key, String pattern) {
        this.convertParamToDateOfBegin(key, pattern);
        return (Date)this.getQueryMap().get(key);
    }

    public Date getParamAsDateOfEnd(String key, String pattern) {
        this.convertParamToDateOfEnd(key, pattern);
        return (Date)this.getQueryMap().get(key);
    }

    public Map<String, Object> getQueryMap() {
        if (this.queryMap != null) {
            return this.queryMap;
        }
        if (!StringUtil.isEmpty(this.queryString)) {
            try {
                String[] paramArr;
                this.queryMap = new HashMap<String, Object>();
                for (String param : paramArr = this.queryString.split("&")) {
                    String[] arr = param.split("=");
                    if (arr.length < 2) continue;
                    this.queryMap.put(arr[0], StringUtil.trim(EncryptUtil.urlDecode(StringUtil.trim(arr[1]))));
                }
            }
            catch (Exception e) {
                logger.error("queryString parse map error!" + this.queryString, (Throwable)e);
                this.queryMap = new HashMap<String, Object>();
            }
        } else {
            this.queryMap = new HashMap<String, Object>();
        }
        return this.queryMap;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo < 1 ? 1 : pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize < 1 ? 15 : pageSize;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getTotalPage() {
        if (this.totalCount <= 0L) {
            return 1L;
        }
        long count = this.totalCount / (long)this.pageSize;
        if (this.totalCount % (long)this.pageSize > 0L) {
            ++count;
        }
        return count;
    }

    public boolean isHasPrevPage() {
        return this.pageNo - 1 >= 1;
    }

    public int getPrevPage() {
        return this.isHasPrevPage() ? this.pageNo - 1 : this.pageNo;
    }

    public boolean isHasNextPage() {
        return (long)(this.pageNo + 1) <= this.getTotalPage();
    }

    public int getNextPage() {
        return this.isHasNextPage() ? this.pageNo + 1 : this.pageNo;
    }

    public int getBeginIndex() {
        return (this.pageNo - 1) * this.pageSize;
    }

    public String getDbDialect() {
        return this.dbDialect;
    }

    public void setDbDialect(String dbDialect) {
        this.dbDialect = dbDialect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return this.pageNo == page.pageNo && this.pageSize == page.pageSize && this.totalCount == page.totalCount && Objects.equals(this.queryString, page.queryString);
    }

    public int hashCode() {
        return Objects.hash(this.pageNo, this.pageSize, this.totalCount, this.queryString);
    }
}

