/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.context;

import cn.ibaijia.jsm.consts.BasePairConstants;
import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.rest.resp.RestResp;
import cn.ibaijia.jsm.context.session.Session;
import cn.ibaijia.jsm.context.session.SessionUser;
import cn.ibaijia.jsm.utils.DateUtil;
import cn.ibaijia.jsm.utils.IpUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.ThreadLocalUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;

public class WebContext {
    private static Logger logger = StatusLogger.getLogger();
    public static final String JSM_TRACE_ID = "jsm-trace-id";
    public static final String JSM_AT = "at";
    public static final String JSM_HT = "ht";
    public static final String JSM_TOKEN = "jsm-token";
    public static String JSM_AUTHORIZATION = "Authorization";
    public static final String NO_AUTH_HEADER = "no-auth-header";
    public static final String JSM_RESP_CODE = "jsm-resp-code";
    public static final String JSM_MOCK = "jsm-mock";
    private static AtomicInteger traceIdAi = new AtomicInteger(0);
    private static String clsId;
    private static Map<String, String> traceIdMap;
    private static String contextPath;
    private static String realPath;

    private static String getClsId() {
        if (clsId == null) {
            clsId = "req-" + AppContext.getClusterId() + "-";
        }
        return clsId;
    }

    public static void setRequest(HttpServletRequest request) {
        ThreadLocalUtil.requestTL.set(request);
    }

    public static HttpServletRequest getRequest() {
        if (ThreadLocalUtil.requestTL.get() != null) {
            return ThreadLocalUtil.requestTL.get();
        }
        return WebContext.getJspRequest();
    }

    public static boolean isRequestMethod(String method) {
        if (WebContext.getRequest() == null) {
            return false;
        }
        return WebContext.getRequest().getMethod().equals(method);
    }

    public static void clearTraceId() {
        String key = "traceId_" + Thread.currentThread().getName();
        traceIdMap.remove(key);
    }

    public static void setTraceId(String traceId) {
        WebContext.setTraceId(Thread.currentThread().getName(), traceId);
    }

    public static void setTraceId(String threadName, String traceId) {
        String key = "traceId_" + threadName;
        traceIdMap.put(key, traceId);
    }

    public static String getTraceId(String threadName) {
        String key = "traceId_" + threadName;
        return traceIdMap.get(key);
    }

    public static String getTraceId() {
        HttpServletRequest request = WebContext.getRequest();
        String key = "traceId_" + Thread.currentThread().getName();
        String traceId = traceIdMap.get(key);
        if (traceId == null && request != null) {
            traceId = request.getHeader(JSM_TRACE_ID);
            if (traceId == null) {
                traceId = request.getParameter(JSM_TRACE_ID);
            }
            if (traceId == null) {
                traceId = (String)request.getAttribute(JSM_TRACE_ID);
            }
            if (traceId == null) {
                StringBuilder traceSb = new StringBuilder();
                String hexIp = IpUtil.ipToHex(WebContext.getRemoteIp());
                int intCount = traceIdAi.getAndIncrement();
                if (intCount > 2147483547) {
                    traceIdAi.set(0);
                }
                traceSb.append(WebContext.getClsId()).append(hexIp).append("-").append(intCount);
                traceId = traceSb.toString();
                request.setAttribute(JSM_TRACE_ID, (Object)traceId);
            }
            traceIdMap.put(key, traceId);
        }
        return traceId;
    }

    public static String getRequestAt() {
        HttpServletRequest request = WebContext.getRequest();
        String at = null;
        if (request != null && StringUtil.isEmpty(request.getAttribute(NO_AUTH_HEADER))) {
            return WebContext.getFromAllScope(JSM_AT);
        }
        return at;
    }

    public static String getRequestHt() {
        HttpServletRequest request = WebContext.getRequest();
        String ht = null;
        if (request != null && StringUtil.isEmpty(request.getAttribute(NO_AUTH_HEADER))) {
            return WebContext.getFromAllScope(JSM_HT);
        }
        return ht;
    }

    public static String getRequestToken() {
        HttpServletRequest request = WebContext.getRequest();
        String token = null;
        if (request != null && StringUtil.isEmpty(request.getAttribute(NO_AUTH_HEADER))) {
            return WebContext.getFromHeaderAndParam(JSM_TOKEN);
        }
        return token;
    }

    public static String getRequestAuthorization() {
        HttpServletRequest request = WebContext.getRequest();
        String authorization = null;
        if (request != null && StringUtil.isEmpty(request.getAttribute(NO_AUTH_HEADER))) {
            return WebContext.getFromHeaderAndParam(JSM_AUTHORIZATION);
        }
        return authorization;
    }

    private static String getFromAllScope(String key) {
        Cookie[] cookies;
        HttpServletRequest request = WebContext.getRequest();
        String value = request.getHeader(key);
        if (value == null) {
            value = request.getParameter(key);
        }
        if (value == null && value == null && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(key)) continue;
                value = cookie.getValue();
            }
        }
        return value;
    }

    public static String getFromHeaderAndParam(String key) {
        HttpServletRequest request = WebContext.getRequest();
        String value = request.getHeader(key);
        if (value == null) {
            value = request.getParameter(key);
        }
        return value;
    }

    private static HttpServletRequest getJspRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return servletRequestAttributes == null ? null : servletRequestAttributes.getRequest();
    }

    public static String currentSessionId() {
        Session session = WebContext.currentSession();
        return session == null ? null : session.getToken();
    }

    public static Session currentSession() {
        HttpServletRequest request = WebContext.getRequest();
        return (Session)(request == null ? null : request.getAttribute("jsm:session:attrKey"));
    }

    public static void setResponse(HttpServletResponse response) {
        ThreadLocalUtil.responseTL.set(response);
    }

    public static HttpServletResponse getResponse() {
        if (ThreadLocalUtil.responseTL.get() != null) {
            return ThreadLocalUtil.responseTL.get();
        }
        return WebContext.getJspResponse();
    }

    public static HttpServletResponse getJspResponse() {
        ServletWebRequest servletWebRequest = (ServletWebRequest)RequestContextHolder.getRequestAttributes();
        return servletWebRequest == null ? null : servletWebRequest.getResponse();
    }

    public static void redirect(String action) throws IOException {
        WebContext.getResponse().sendRedirect(WebContext.getContextPath() + action);
    }

    public static boolean isRest() {
        String uri = WebContext.getRequest().getRequestURI().toLowerCase();
        return !uri.contains(".");
    }

    private static void sendAjaxError(String msg) {
        RestResp baseResp = new RestResp();
        baseResp.setPair(BasePairConstants.ERROR);
        baseResp.result = msg;
        try {
            WebContext.getResponse().addHeader("Content-Type", "text/json;charset=UTF-8");
            WebContext.getResponse().addHeader("Content-Type", "application/json;charset=UTF-8");
            WebContext.getResponse().getWriter().write(StringUtil.toJson(baseResp));
            WebContext.getResponse().getWriter().flush();
            WebContext.getResponse().getWriter().close();
        }
        catch (Exception e) {
            logger.error("sendAjaxError error!", (Throwable)e);
        }
    }

    public static String getRealPath() {
        return realPath;
    }

    public static void setRealPath(String realPath) {
        WebContext.realPath = realPath;
    }

    public static String getContextPath() {
        return contextPath;
    }

    public static void setContextPath(String contextPath) {
        WebContext.contextPath = contextPath;
    }

    public static String getRandomFileName(String type, String ext) {
        StringBuilder sb = new StringBuilder();
        sb.append(type).append("_").append(DateUtil.format(new Date(), "yyyyMMddHHmmss"));
        sb.append("_").append(new Random().nextInt(1000)).append(".").append(ext);
        return sb.toString();
    }

    public static String saveExcel(HSSFWorkbook workbook) throws IOException {
        String fileName = WebContext.getRandomFileName("temp", "xls");
        FileOutputStream os = new FileOutputStream(fileName);
        workbook.write((OutputStream)os);
        ((OutputStream)os).close();
        return fileName.substring(fileName.lastIndexOf("\\") + 1);
    }

    public static SessionUser currentUser() {
        Session session = WebContext.currentSession();
        if (session == null) {
            return null;
        }
        return session.getSessionUser();
    }

    public static String currentUserId() {
        SessionUser currentUser = WebContext.currentUser();
        if (currentUser == null) {
            return null;
        }
        return currentUser.getUid();
    }

    public static List<String> currentPermissions() {
        SessionUser sessionUser = WebContext.currentUser();
        if (sessionUser == null) {
            return null;
        }
        return sessionUser.getPermissions();
    }

    public static List<String> currentRoles() {
        SessionUser sessionUser = WebContext.currentUser();
        if (sessionUser == null) {
            return null;
        }
        return sessionUser.getRoles();
    }

    public static boolean isAjax() {
        String type = WebContext.getRequest().getHeader("X-Requested-With");
        return "XMLHttpRequest".equals(type);
    }

    public static String getFirstForwardIp() {
        String[] ips = WebContext.getForwardedIps();
        if (ips == null) {
            return null;
        }
        return ips[0];
    }

    public static String getLastForwardIp() {
        String[] ips = WebContext.getForwardedIps();
        if (ips == null) {
            return null;
        }
        return ips[ips.length - 1];
    }

    public static String[] getForwardedIps() {
        HttpServletRequest request = WebContext.getRequest();
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.contains(",")) {
            ip = ip.replaceAll(" ", "");
        }
        return ip == null ? null : ip.split(",");
    }

    public static String getRemoteIp() {
        HttpServletRequest request = WebContext.getRequest();
        if (request == null) {
            return null;
        }
        return WebContext.getRemoteIp(request);
    }

    public static String getRemoteIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.contains(",")) {
            ip = ip.split(",")[0];
        }
        return ip;
    }

    public static void setJspPath(String path) {
        ThreadLocalUtil.jspPathTL.set(path);
    }

    public static String getJspPath() {
        String path = ThreadLocalUtil.jspPathTL.get();
        ThreadLocalUtil.jspPathTL.remove();
        return path;
    }

    public static String getBackUrl() {
        if ("GET".equals(WebContext.getRequest().getMethod())) {
            return WebContext.getActionUri();
        }
        String url = WebContext.getRequest().getHeader("REFERER");
        return url.substring(url.indexOf("=") + 1);
    }

    public static byte[] getRequestBodyBytes(HttpServletRequest request) {
        try {
            int readlen;
            int contentLength = request.getContentLength();
            if (contentLength < 0) {
                return null;
            }
            byte[] buffer = new byte[contentLength];
            for (int i = 0; i < contentLength && (readlen = request.getInputStream().read(buffer, i, contentLength - i)) != -1; i += readlen) {
            }
            return buffer;
        }
        catch (IOException e) {
            logger.error("getRequestBodyBytes error!", (Throwable)e);
            return null;
        }
    }

    public static String getRequestBody(HttpServletRequest request) {
        try {
            byte[] buffer = WebContext.getRequestBodyBytes(request);
            String charEncoding = request.getCharacterEncoding();
            if (charEncoding == null) {
                charEncoding = "UTF-8";
            }
            if (buffer != null) {
                return new String(buffer, charEncoding);
            }
        }
        catch (Exception e) {
            logger.error("getRequestBody error!", (Throwable)e);
        }
        return null;
    }

    public static String getRequestBody() {
        return WebContext.getRequestBody(WebContext.getRequest());
    }

    public static String getActionUri() {
        return WebContext.getRequest().getRequestURI().substring(WebContext.getContextPath().length());
    }

    static {
        traceIdMap = new HashMap<String, String>();
    }
}

