/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.context;

import java.util.Locale;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
public class SpringContext
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringContext.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        SpringContext.checkApplicationContext();
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        SpringContext.checkApplicationContext();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        SpringContext.checkApplicationContext();
        Map beanMaps = applicationContext.getBeansOfType(clazz);
        if (beanMaps != null && !beanMaps.isEmpty()) {
            return (T)beanMaps.values().iterator().next();
        }
        return null;
    }

    public static <T> T getBean(Class<T> clazz, WebApplicationContext applicationContext) {
        try {
            return (T)applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMessage(String key, Object ... args) {
        return SpringContext.getMessage(Locale.CHINA, key, args);
    }

    public static String getMessage(Locale locale, String key, Object ... args) {
        if (applicationContext == null) {
            return key;
        }
        return applicationContext.getMessage(key, args, locale);
    }

    private static void checkApplicationContext() {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u672a\u6ce8\u5165,\u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder");
        }
    }
}

