/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.context;

import cn.ibaijia.jsm.utils.IpUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.PropUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.springframework.core.env.Environment;

public class AppContext {
    private static Logger logger = LogUtil.log(AppContext.class);
    private static Map<String, String> propMap = new HashMap<String, String>();
    private static Environment environment;
    private static Boolean devModel;
    private static Boolean jedisSession;
    private static String projectName;
    private static String clusterId;
    private static String optLogUrl;
    private static Integer sessionExpireTime;
    private static Integer atExpireTime;

    private static void setInitData() {
        AppContext.set("regex.valid.email", "[\\w!#$%&'*+/=?^_`{|}~-]+(?:\\.[\\w!#$%&'*+/=?^_`{|}~-]+)*@(?:[\\w](?:[\\w-]*[\\w])?\\.)+[\\w](?:[\\w-]*[\\w])?");
        AppContext.set("regex.valid.chinese", " [\\u4E00-\\u9FA5]");
        AppContext.set("regex.valid.ipv4", "^\\d+\\.\\d+\\.\\d+\\.\\d+$");
        AppContext.set("regex.valid.date", "^\\d{4}-\\d{1,2}-\\d{1,2}$");
        AppContext.set("regex.valid.datetime", "^\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}$");
        AppContext.set("regex.valid.url", "[a-zA-z]+://[^\\s]*");
        AppContext.set("regex.valid.idcard", "^(\\d{6})(\\d{4})(\\d{2})(\\d{2})(\\d{3})([0-9]|X)$");
        AppContext.set("regex.valid.telno", "^(\\(\\d{3,4}-)|\\d{3.4}-)?\\d{7,8}$");
        AppContext.set("regex.valid.mobno", "^(13[0-9]|14[0-9]|15[0-9]|16[0-9]|17[0-9]|18[0-9]|19[0-9])\\d{8}$");
        AppContext.set("regex.valid.number", "^[0-9]*$");
        AppContext.set("regex.valid.ennum", "^[A-Za-z0-9]+$");
        AppContext.set("regex.valid.account", "^[a-zA-Z][a-zA-Z0-9_]+$");
        AppContext.set("regex.valid.money", "^(([1-9]\\d{0,9})|0)(\\.\\d{1,2})?$");
        AppContext.set("regex.valid.bankcard", "^(\\d{16}|\\d{19})$");
        AppContext.set("regex.extract.money", "(([1-9]\\d{0,9})|0)(\\.\\d{1,2})?");
        AppContext.set("regex.extract.number", "\\d+(\\.\\d+)?");
    }

    public static boolean isDevModel() {
        if (devModel == null) {
            devModel = AppContext.getAsBoolean("jsm.dev.model");
        }
        return devModel;
    }

    public static boolean isJedisSession() {
        if (jedisSession == null) {
            jedisSession = AppContext.getAsBoolean("jsm.jedis.session");
        }
        return jedisSession;
    }

    public static String getProjectName() {
        if (projectName == null) {
            projectName = AppContext.get("jsm.appName");
        }
        return projectName;
    }

    public static String getClusterId() {
        if (clusterId == null && (clusterId = AppContext.get("jsm.clusterId")) == null) {
            clusterId = AppContext.getProjectName() + "." + IpUtil.ipToHex(IpUtil.getHostIp());
        }
        return clusterId;
    }

    public static String getOptLogUrl() {
        if (optLogUrl == null) {
            optLogUrl = AppContext.get("jsm.optlog.recordUrl", "");
        }
        return optLogUrl;
    }

    public static int getSessionExpireTime() {
        if (sessionExpireTime == null) {
            sessionExpireTime = AppContext.getAsInteger("jsm.session.expireTime", 14400);
        }
        return sessionExpireTime;
    }

    public static int getAtExpireTime() {
        if (atExpireTime == null) {
            atExpireTime = AppContext.getAsInteger("jsm.at.expireTime", 60000);
        }
        return atExpireTime;
    }

    public static String getDirect(String key) {
        String val = PropUtil.get(key, "app.properties");
        if (val != null) {
            return val;
        }
        val = PropUtil.get(key, "project.properties");
        if (val != null) {
            return val;
        }
        return null;
    }

    public static String get(String key, String defaultVal) {
        String res = AppContext.get(key);
        return res == null ? defaultVal : res;
    }

    public static String get(String key) {
        String res = AppContext.getFromSpringEnv(key);
        if (!StringUtil.isEmpty(res)) {
            return res;
        }
        res = propMap.get(key);
        if (!StringUtil.isEmpty(res)) {
            return res;
        }
        res = System.getProperty(key);
        if (!StringUtil.isEmpty(res)) {
            return res;
        }
        return System.getenv(key);
    }

    private static String getFromSpringEnv(String key) {
        if (environment == null) {
            return null;
        }
        return environment.getProperty(key);
    }

    public static Integer getAsInteger(String key) {
        return AppContext.getAsInteger(key, null);
    }

    public static Integer getAsInteger(String key, Integer defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toInteger(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsInteger error! key {}", (Object)key);
            return null;
        }
    }

    public static Short getAsShort(String key) {
        return AppContext.getAsShort(key, null);
    }

    public static Short getAsShort(String key, Short defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toShort(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsShort error! key {}", (Object)key);
            return null;
        }
    }

    public static Byte getAsByte(String key) {
        return AppContext.getAsByte(key, null);
    }

    public static Byte getAsByte(String key, Byte defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toByte(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsByte error! key {}", (Object)key);
            return null;
        }
    }

    public static Float getAsFloat(String key) {
        return AppContext.getAsFloat(key, null);
    }

    public static Float getAsFloat(String key, Float defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toFloat(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsFloat error! key {}", (Object)key);
            return null;
        }
    }

    public static Long getAsLong(String key) {
        return AppContext.getAsLong(key, null);
    }

    public static Long getAsLong(String key, Long defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toLong(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsLong error! key {}", (Object)key);
            return null;
        }
    }

    public static Boolean getAsBoolean(String key) {
        return AppContext.getAsBoolean(key, null);
    }

    public static Boolean getAsBoolean(String key, Boolean defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toBoolean(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsBoolean error! key {}", (Object)key);
            return null;
        }
    }

    private static void setProxy() {
        Properties prop = System.getProperties();
        String httpProxyHost = AppContext.get("http.proxyHost");
        String httpProxyPort = AppContext.get("http.proxyPort");
        String httpNonProxyHosts = AppContext.get("http.nonProxyHosts");
        String httpsProxyHost = AppContext.get("https.proxyHost");
        String httpsProxyPort = AppContext.get("https.proxyPort");
        String httpsNonProxyHosts = AppContext.get("https.nonProxyHosts");
        String ftpProxyHost = AppContext.get("ftp.proxyHost");
        String ftpProxyPort = AppContext.get("ftp.proxyPort");
        String ftpNonProxyHosts = AppContext.get("ftp.nonProxyHosts");
        String socksProxyHost = AppContext.get("socks.proxyHost");
        String socksProxyPort = AppContext.get("socks.proxyPort");
        String socksNonProxyHosts = AppContext.get("socks.nonProxyHosts");
        if (!StringUtil.isEmpty(httpProxyHost)) {
            System.out.println("http.proxyHost:" + httpProxyHost);
            System.out.println("http.proxyPort:" + httpProxyPort);
            System.out.println("http.nonProxyHosts:" + httpNonProxyHosts);
            prop.setProperty("http.proxyHost", httpProxyHost);
            prop.setProperty("http.proxyPort", httpProxyPort);
            prop.setProperty("http.nonProxyHosts", httpNonProxyHosts);
        }
        if (!StringUtil.isEmpty(httpsProxyHost)) {
            System.out.println("https.proxyHost:" + httpsProxyHost);
            System.out.println("https.proxyPort:" + httpsProxyPort);
            System.out.println("https.nonProxyHosts:" + httpsNonProxyHosts);
            prop.setProperty("https.proxyHost", httpsProxyHost);
            prop.setProperty("https.proxyPort", httpsProxyPort);
            prop.setProperty("https.nonProxyHosts", httpsNonProxyHosts);
        }
        if (!StringUtil.isEmpty(ftpProxyHost)) {
            System.out.println("ftp.proxyHost:" + ftpProxyHost);
            System.out.println("ftp.proxyPort:" + ftpProxyPort);
            System.out.println("ftp.nonProxyHosts:" + ftpNonProxyHosts);
            prop.setProperty("ftp.proxyHost", ftpProxyHost);
            prop.setProperty("ftp.proxyPort", ftpProxyPort);
            prop.setProperty("ftp.nonProxyHosts", ftpNonProxyHosts);
        }
        if (!StringUtil.isEmpty(socksProxyHost)) {
            System.out.println("socks.proxyHost:" + socksProxyHost);
            System.out.println("socks.proxyPort:" + socksProxyPort);
            prop.setProperty("socksProxyHost", socksProxyHost);
            prop.setProperty("socksProxyPort", socksProxyPort);
            prop.setProperty("socksNonProxyHosts", socksNonProxyHosts);
        }
        String proxyUsername = AppContext.get("proxy.username");
        String proxyPassword = AppContext.get("proxy.password");
        if (!StringUtil.isEmpty(proxyUsername)) {
            System.out.println("proxy.username:" + proxyUsername);
            final String username = proxyUsername;
            final String password = proxyPassword;
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
    }

    public static void init() {
        String propFile = "project.properties";
        System.out.println("load:" + propFile);
        Properties properties = PropUtil.getProperties(propFile);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            propMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        propFile = "app.properties";
        System.out.println("load:" + propFile);
        properties = PropUtil.getProperties(propFile);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            propMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        System.out.println("props:" + StringUtil.toJson(propMap));
        AppContext.setProxy();
    }

    public static String set(String key, String value) {
        System.getProperties().setProperty(key, value);
        return propMap.put(key, value);
    }

    public static void setEnvironment(Environment environment) {
        AppContext.environment = environment;
    }

    static {
        AppContext.setInitData();
    }
}

