/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.cache.jedis;

import cn.ibaijia.jsm.cache.jedis.JedisCmd;
import cn.ibaijia.jsm.cache.jedis.JedisCmdThrowable;
import cn.ibaijia.jsm.cache.jedis.JedisDataSource;
import cn.ibaijia.jsm.cache.jedis.ShardedJedisCmd;
import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.stat.model.Alarm;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.SystemUtil;
import com.mchange.v2.ser.SerializableUtils;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ShardedJedis;

@Repository
public class JedisService {
    private final Logger logger = LoggerFactory.getLogger(JedisService.class);
    @Resource
    private JedisDataSource redisDataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setex(String key, int seconds, String value) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.setex(key, seconds, value);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("setex", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setnx(String key, int seconds, String value) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.set(key, value, "NX", "EX", (long)seconds);
        }
        catch (Exception e) {
            this.logger.error("setnx error.", (Throwable)e);
            broken = true;
            this.addAlarm("setnx", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setnx(String key, String value) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.setnx(key, value);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("setnx", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.set(key, value);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("set", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmset(String key, Map<String, String> map) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.hmset(key, map);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("hmset", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hmget(String key, String ... fields) {
        List result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.hmget(key, fields);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("hmget", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(String key, String field, String value) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.hset(key, field, value);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("hset", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String field) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.hget(key, field);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("hget", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hdel(String key, String ... fields) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.hdel(key, fields);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("hdel", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.get(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("get", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exists(String key) {
        Boolean result = false;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.exists(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("exists", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String type(String key) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.type(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("type", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expire(String key, int seconds) {
        this.logger.debug("key {} expire after {}", (Object)key, (Object)seconds);
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.expire(key, seconds);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("expire", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expireAt(String key, long unixTime) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.expireAt(key, unixTime);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("expireAt", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long ttl(String key) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.ttl(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("ttl", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setRange(String key, long offset, String value) {
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        long result = 0L;
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.setrange(key, offset, value);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("setRange", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRange(String key, long startOffset, long endOffset) {
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        String result = null;
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.getrange(key, startOffset, endOffset);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("getRange", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String key) {
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        Long result = null;
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.del(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("del", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lpop(String key) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.lpop(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("lpop", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rpop(String key) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.rpop(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("rpop", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpush(String key, String ... values) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.lpush(key, values);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("lpush", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpush(String key, String ... values) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.rpush(key, values);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("rpush", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long llen(String key) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        boolean broken = false;
        try {
            result = shardedJedis.llen(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            broken = true;
            this.addAlarm("llen", e.getMessage());
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, broken);
        }
        return result;
    }

    public String setObject(String key, Serializable value) throws NotSerializableException {
        return this.set(key.getBytes(), SerializableUtils.toByteArray((Object)value));
    }

    public String set(final byte[] key, final byte[] value) {
        return this.exec(new ShardedJedisCmd<String>(){

            @Override
            public String run(ShardedJedis shardedJedis) {
                return shardedJedis.set(key, value);
            }
        });
    }

    public String setexObject(String key, int seconds, Serializable value) throws NotSerializableException {
        return this.setex(key.getBytes(), seconds, SerializableUtils.toByteArray((Object)value));
    }

    public String setex(final byte[] key, final int seconds, final byte[] value) {
        return this.exec(new ShardedJedisCmd<String>(){

            @Override
            public String run(ShardedJedis shardedJedis) {
                return shardedJedis.setex(key, seconds, value);
            }
        });
    }

    public <T> T getObject(final String key) throws Exception {
        return this.exec(new ShardedJedisCmd<T>(){

            @Override
            public T run(ShardedJedis shardedJedis) throws Exception {
                byte[] bytes = shardedJedis.get(key.getBytes());
                if (bytes != null && bytes.length > 0) {
                    return SerializableUtils.fromByteArray((byte[])bytes);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T exec(ShardedJedisCmd<T> shardedJedisCmd) {
        T result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getSharedJedis();
        if (shardedJedis == null) {
            return result;
        }
        try {
            result = shardedJedisCmd.run(shardedJedis);
        }
        catch (Exception e) {
            this.logger.error("exec shardedJedisCmd error.", (Throwable)e);
            this.addAlarm("exec shardedJedisCmd", e.getMessage());
            if (shardedJedisCmd instanceof JedisCmdThrowable) {
                ((JedisCmdThrowable)((Object)shardedJedisCmd)).throwable(e);
            }
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T exec(JedisCmd<T> jedisCmd) {
        T result = null;
        Jedis jedis = this.redisDataSource.getJedis();
        if (jedis == null) {
            return result;
        }
        try {
            result = jedisCmd.run(jedis);
        }
        catch (Exception e) {
            this.logger.error("exec jedisCmd error.", (Throwable)e);
            this.addAlarm("exec jedisCmd", e.getMessage());
            if (jedisCmd instanceof JedisCmdThrowable) {
                ((JedisCmdThrowable)((Object)jedisCmd)).throwable(e);
            }
        }
        finally {
            this.redisDataSource.returnResource(jedis);
        }
        return result;
    }

    public boolean lock(String lockKey) {
        String sid = WebContext.currentSessionId();
        return this.lock(lockKey, StringUtil.isEmpty(sid) ? "-1" : sid, 3000, 3600);
    }

    public boolean lock(String lockKey, int retryTimes, int lockTimes) {
        String sid = WebContext.currentSessionId();
        return this.lock(lockKey, StringUtil.isEmpty(sid) ? "-1" : sid, retryTimes, lockTimes);
    }

    public synchronized boolean lock(String lockKey, String requestId, int retryTimes, int lockTimes) {
        String val = this.setnx(lockKey, lockTimes, requestId);
        boolean res = true;
        if (!"OK".equals(val)) {
            int i = 0;
            while (!"OK".equals(val = this.setnx(lockKey, lockTimes, requestId))) {
                if (i == retryTimes) {
                    this.logger.info("wait lock time out retry times {}", (Object)retryTimes);
                    res = false;
                    break;
                }
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    this.logger.error("", (Throwable)e);
                }
                ++i;
            }
        }
        return res;
    }

    public synchronized void unlock(String lockKey) {
        this.del(lockKey);
    }

    private void addAlarm(String method, String errorMessage) {
        SystemUtil.addAlarm(new Alarm("JedisService", "" + method + "," + errorMessage));
    }
}

