/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.cache.jedis;

import cn.ibaijia.jsm.stat.model.Alarm;
import cn.ibaijia.jsm.utils.SystemUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

@Repository
public class JedisDataSource {
    private Logger logger = LoggerFactory.getLogger(JedisDataSource.class);
    @Resource
    private ShardedJedisPool shardedJedisPool;
    @Resource
    private JedisPool jedisPool;

    public ShardedJedis getSharedJedis() {
        ShardedJedis shardJedis = null;
        try {
            shardJedis = this.shardedJedisPool.getResource();
            return shardJedis;
        }
        catch (Exception e) {
            this.logger.error("getSharedJedis error:", (Throwable)e);
            SystemUtil.addAlarm(new Alarm("JedisService", "getSharedJedis error." + e.getMessage()));
            if (null != shardJedis) {
                shardJedis.close();
            }
            return null;
        }
    }

    public Jedis getJedis() {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            return jedis;
        }
        catch (Exception e) {
            SystemUtil.addAlarm(new Alarm("JedisService", "getJedis error." + e.getMessage()));
            this.logger.error("getSharedJedis error:", (Throwable)e);
            if (null != jedis) {
                jedis.close();
            }
            return null;
        }
    }

    public void returnResource(ShardedJedis shardedJedis) {
        shardedJedis.close();
    }

    public void returnResource(ShardedJedis shardedJedis, boolean broken) {
        shardedJedis.close();
    }

    public void returnResource(Jedis jedis) {
        jedis.close();
    }

    public void returnResource(Jedis jedis, boolean broken) {
        jedis.close();
    }
}

